(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	$(document).ready(function(){
		// list tables js start
		$(document).find("input#personal-dictionary-search-input + input#search-submit").on("click", function (e) {
            var _this  = $(this);
            var parent = _this.parents('form');
            
            var search_input = parent.find('input#personal-dictionary-search-input');
            var input_value  = search_input.val();

            var field = 's';
            var flag = false;
            var url = window.location.href;
            if(url.indexOf('?' + field + '=') != -1){
                flag = true;
            }
            else if(url.indexOf('&' + field + '=') != -1){
                flag = true;
            }

            if (flag) {
                if (typeof input_value != 'undefined' && input_value != "") {
                    e.preventDefault();
                    location.href=location.href.replace(/&s=([^&]$|[^&]*)/i, "&s="+input_value);
                }
            }
        });

        $(document).find('.ays-pd-all-filter-button-top, .ays-pd-all-filter-button-bottom').on('click', function(e) {
			e.preventDefault();
            var $this = $(this);
            var parent = $this.parents('.tablenav');

            var html_name = '';
            var top_or_bottom = 'top';

            if ( parent.hasClass('bottom') ) {
                top_or_bottom = 'bottom';
            }

            var groupFilter = $(document).find('select[name="filterbygroup-'+ top_or_bottom +'"]').val();
            var link = location.href;

			if(typeof groupFilter != "undefined"){
                link = allFiltersForListTable(link, {
                    what: 'filterbygroup',
                    value: groupFilter
                });
            }

            document.location.href = link;
		});

		function allFiltersForListTable(link, options){
            if( options.value != '' ){
                options.value = "&" + options.what + "=" + options.value;
                var linkModifiedStart = link.split('?')[0];
                var linkModified = link.split('?')[1].split('&');
                for(var i = 0; i < linkModified.length; i++){
                    if ( linkModified[i].split("=")[0] == "ays_result_tab" ) {
                        linkModified.splice(i, 1, "ays_result_tab=poststuff");
                    }
                    if(linkModified[i].split("=")[0] == options.what){
                        linkModified.splice(i, 1);
                    }
                }
                linkModified = linkModified.join('&');
                return linkModifiedStart + "?" + linkModified + options.value;
            }else{
                var linkModifiedStart = link.split('?')[0];
                var linkModified = link.split('?')[1].split('&');
                for(var i = 0; i < linkModified.length; i++){
                    if(linkModified[i].split("=")[0] == options.what){
                        linkModified.splice(i, 1);
                    }
                }
                linkModified = linkModified.join('&');
                return linkModifiedStart + "?" + linkModified;
            }
        }

		if ($('.pagination-links:visible').length) {
            if ($('#ays-popup-box-search-input').length) {
                var search_string = $("#ays-popup-box-search-input").val();
                if (search_string != "") {
                    $(".pagination-links a").each(function() {
                        this.href = this.href + "&s=" + search_string;
                    });
                }
            }
        }
		// list tables js end

		$('[data-toggle="tooltip"]').tooltip();
		$('#ays_pd_users_select').select2();

		// WP color picker start
		var defaultColors = {
			bgColor: "#ffffff",
            bgColorMobile: "#ffffff",
			mainColor: "#1A7EFB",
            mainColorMobile: "#1A7EFB",
			textColor: "#000",
            textColorMobile: "#000",
			containerBorderColor: "#ccc",
            containerBorderColorMobile: "#ccc",
			answerBorderColor: "rgba(148,148,148,0.85)",
            answerBackgroundColor: "#ffffff",
			buttonsTextColor: "#ffffff",
			titleBoxShadowColor: "rgba(234,234,234,0)",
            containerBoxShadowColor: "rgba(21, 62, 113, 0.14)",
            answerBoxShadowColor: "rgba(21, 62, 113, 0.14)",
		};

		var ays_pd_bg_color_picker = {
            defaultColor: defaultColors.bgColor,
			change: function (e) {}
        };

        var ays_pd_bg_color_mobile_picker = {
            defaultColor: defaultColors.bgColorMobile,
            change: function (e) {}
        };

		var ays_pd_main_color_picker = {
            defaultColor: defaultColors.mainColor,
			change: function (e) {}
        };

        var ays_pd_text_color_mobile_picker = {
            defaultColor: defaultColors.textColorMobile,
            change: function (e) {}
        };

        var ays_pd_cont_border_color_picker = {
            defaultColor: defaultColors.containerBorderColor,
            change: function (e) {}
        };

        var ays_pd_cont_border_color_mobile_picker = {
            defaultColor: defaultColors.containerBorderColorMobile,
            change: function (e) {}
        };

        var ays_pd_answ_border_color_picker = {
            defaultColor: defaultColors.answerBorderColor,
            change: function (e) {}
        };

        var ays_pd_answ_bg_color_picker = {
            defaultColor: defaultColors.answerBackgroundColor,
            change: function (e) {}
        };

        var ays_pd_main_color_mobile_picker = {
            defaultColor: defaultColors.mainColorMobile,
            change: function (e) {}
        };

		var ays_pd_text_color_picker = {
            defaultColor: defaultColors.textColor,
			change: function (e) {}
        };
		
		var ays_pd_buttonsText_color_picker = {
            defaultColor: defaultColors.buttonsTextColor,
			change: function (e) {}
        };

        var ays_pd_containerBoxShadow_color_picker = {
            defaultColor: defaultColors.containerBoxShadowColor,
			change: function (e) {}
        };

        var ays_pd_answerBoxShadow_color_picker = {
            defaultColor: defaultColors.answerBoxShadowColor,
            change: function (e) {}
        };

        var ays_pd_titleBoxShadow_color_picker = {
            defaultColor: defaultColors.titleBoxShadowColor,
			change: function (e) {}
        };

         var ays_pd_descriptionBoxShadow_color_picker = {
            defaultColor: defaultColors.descriptionBoxShadowColor,
			change: function (e) {}
        };

		$.fn.goToNormal = function() {
            $('html, body').animate({
                scrollTop: this.offset().top - 200 + 'px'
            }, 'normal');
            return this; // for chaining...
        }

		$(document).find('#ays_pd_bg_color').wpColorPicker(ays_pd_bg_color_picker);
        $(document).find('#ays_pd_bg_color_mobile').wpColorPicker(ays_pd_bg_color_mobile_picker);
		$(document).find('#ays_pd_main_color').wpColorPicker(ays_pd_main_color_picker);
        $(document).find('#ays_pd_main_color_mobile').wpColorPicker(ays_pd_main_color_mobile_picker);
		$(document).find('#ays_pd_text_color').wpColorPicker(ays_pd_text_color_picker);
        $(document).find('#ays_pd_text_color_mobile').wpColorPicker(ays_pd_text_color_mobile_picker);
		$(document).find('#ays_pd_container_border_color').wpColorPicker(ays_pd_cont_border_color_picker);
        $(document).find('#ays_pd_container_border_color_mobile').wpColorPicker(ays_pd_cont_border_color_mobile_picker);
		$(document).find('#ays_pd_answer_border_color').wpColorPicker(ays_pd_answ_border_color_picker);
        $(document).find('#ays_pd_answer_bg_color').wpColorPicker(ays_pd_answ_bg_color_picker);
        $(document).find('#ays_pd_container_box_shadow_color').wpColorPicker(ays_pd_containerBoxShadow_color_picker);
        $(document).find('#ays_pd_answer_box_shadow_color').wpColorPicker(ays_pd_answerBoxShadow_color_picker);
		$(document).find('#ays_pd_button_text_color').wpColorPicker(ays_pd_buttonsText_color_picker);
		$(document).find('#ays_pd_title_text_shadow_color').wpColorPicker(ays_pd_titleBoxShadow_color_picker);
		$(document).find('#ays_pd_description_text_shadow_color').wpColorPicker(ays_pd_descriptionBoxShadow_color_picker);
		// WP color picker end

		// Code Mirror

		setTimeout(function(){
			if($(document).find('#ays_custom_css').length > 0){
				let CodeEditor = null;
				if(wp.codeEditor){
					CodeEditor = wp.codeEditor.initialize($(document).find('#ays_custom_css'), cm_settings);
				}
				if(CodeEditor !== null){
					CodeEditor.codemirror.on('change', function(e, ev){
						$(CodeEditor.codemirror.display.input.div).find('.CodeMirror-linenumber').remove();
						$(document).find('#ays_custom_css').val(CodeEditor.codemirror.display.input.div.innerText);
							
					});
				}
			}
        }, 500);

  		let toggle_ddmenu = $(document).find('.toggle_ddmenu');
        toggle_ddmenu.on('click', function () {
            let ddmenu = $(this).next();
            let state = ddmenu.attr('data-expanded');
            switch (state) {
                case 'true':
                    $(this).find('.ays_fa_pd').css({
                        transform: 'rotate(0deg)'
                    });
                    ddmenu.attr('data-expanded', 'false');
                    break;
                case 'false':
                    $(this).find('.ays_fa_pd').css({
                        transform: 'rotate(90deg)'
                    });
                    ddmenu.attr('data-expanded', 'true');
                    break;
            }
        });

        $(document).find('input.ays_pd_shortcode').on('mouseleave', function(){
            var _this = $(this);

            _this.attr( 'data-original-title', pdAdminLangObj.clickForCopy );
			_this.tooltip("hide");
        });

        $(document).keydown(function(event) {
            var editButton = $(document).find("input#ays_pd_submit_top");
            if (!(event.which == 83 && event.ctrlKey) && !(event.which == 19)){
                return true;  
            }

            editButton.trigger("click");
            event.preventDefault();
            return false;
        });

        var subButtons = '.button#ays_pd_submit_top';
		$(document).on('click', subButtons ,function () {     
			var $this = $(this);
			submitOnce($this);
		});

		function submitOnce(subButton){
			var subLoader = subButton.siblings(".display_none");
			subLoader.removeClass("display_none");
			subLoader.css("padding-left" , "8px");
			subLoader.css("display" , "inline-block");
			setTimeout(function() {
				$(subButtons).attr('disabled', true);
			}, 50);
			setTimeout(function() {
				$(subButtons).attr('disabled', false);
				subLoader.addClass("display_none");
			}, 5000);
		}

		$('#reset_to_default').on('click', function () {
            setTimeout(function(){
                if($(document).find('#ays_custom_css').length > 0){
                    if(wp.codeEditor){
                        $(document).find('#ays_custom_css').next('.CodeMirror').remove();
                        $(document).find('#ays_custom_css').val('');
                        wp.codeEditor.initialize($(document).find('#ays_custom_css'), cm_settings);
                    }
                }
            }, 100);

            
            $(document).find("#ays_pd_show_title").prop('checked', true).change();            
            $(document).find("#ays_pd_show_title_mobile").prop('checked', true).change();
                       
            $(document).find("#ays_pd_show_description").prop('checked', true).change();
            $(document).find("#ays_pd_show_description_mobile").prop('checked', true).change(); 

            $(document).find('img.ays-pd-img').attr('src', '').change();
            $(document).find('input#ays_pd_add_logo').val('');
            $(document).find('.ays-pd-image-body').hide().change();
            $(document).find('.ays-pd-logo-url-box').hide().change();
            $(document).find('.ays_pd_logo_position').hide().change();
            $(document).find('.ays-pd-add-image').text('Add Image').show().change();

            $(document).find('#ays_pd_learned_points').val(10);
            $(document).find('#ays_pd_right_points').val(1);
            $(document).find('#ays_pd_wrong_points').val('-0.25');

            $(document).find("#ays_pd_show_correct_answer").prop('checked', false).change();
            $(document).find("#ays_pd_show_correct_answer_mobile").prop('checked', false).change();
            $(document).find("#ays_pd_show_next_button").prop('checked', true).change();
            $(document).find("#ays_pd_show_next_button_mobile").prop('checked', true).change();
            $(document).find("#ays_pd_enable_full_screen_mode").prop('checked', false).change();
            $(document).find("#ays_pd_enable_add_words_from_front").prop('checked', false).change();

            $(document).find("#ays_pd_enable_add_image_from_front").prop('checked', false).change();
            $(document).find("#ays_pd_enable_add_audio_from_front").prop('checked', false).change();
            
            $(document).find("#ays_pd_enable_add_image_to_games").prop('checked', false).change();
            $(document).find("#ays_pd_enable_add_audio_to_games").prop('checked', false).change();

			$(document).find("#ays_pd_show_games").prop('checked', true).change();
            $(document).find("#ays_pd_show_game_find_the_word").prop('checked', true).change();
            $(document).find("#ays_pd_show_game_find_the_translation").prop('checked', true).change();
            $(document).find("#ays_pd_show_game_matching_words").prop('checked', true).change();
            $(document).find("#ays_pd_show_game_write_the_translation").prop('checked', true).change();

            $(document).find('#ays_pd_games_animation_effect').val('none').change();
            $(document).find('#ays_pd_enable_games_animation_effect_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_games_animation_effect_mobile').val('none').change();
            $(document).find('div.ays_pd_games_animation_effect_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_bg_color').val('#ffffff').change();
            $(document).find('#ays_pd_bg_color_mobile').val('#ffffff').change();
            $(document).find('#ays_pd_enable_bg_color_mobile').prop('checked', true).change();
            $(document).find('div.ays_pd_bg_color_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_main_color').val('#1a7efb').change();
            $(document).find('#ays_pd_main_color_mobile').val('#1a7efb').change();
            $(document).find('#ays_pd_enable_main_color_mobile').prop('checked', true).change();
            $(document).find('div.ays_pd_main_color_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_text_color').val('#000').change();
            $(document).find('#ays_pd_text_color_mobile').val('#000').change();
            $(document).find('#ays_pd_enable_text_color_mobile').prop('checked', true).change();
            $(document).find('div.ays_pd_text_color_mobile_container').css('display', 'block');
            
			$(document).find('#ays_pd_container_border_color').val('#ccc').change();
            $(document).find('#ays_pd_container_border_color_mobile').val('#ccc').change();
            $(document).find('#ays_pd_enable_container_border_color_mobile').prop('checked', true).change();
            $(document).find('div.ays_pd_container_border_color_mobile_container').css('display', 'block');

			$(document).find('#ays_pd_answer_border_color').val('rgba(148,148,148,0.85)').change();
            $(document).find('#ays_pd_answer_bg_color').val('#ffffff').change();
            
            $(document).find("#ays_pd_enable_container_box_shadow").prop('checked', true).change();
            $(document).find('#ays_pd_container_box_shadow_color').val('rgba(21, 62, 113, 0.14)').change();
            $(document).find('#ays_pd_container_box_shadow_x_offset').val(0);
            $(document).find('#ays_pd_container_box_shadow_y_offset').val(4);
            $(document).find('#ays_pd_container_box_shadow_z_offset').val(9);

            $(document).find("#ays_pd_enable_answer_box_shadow").prop('checked', false).change();
            $(document).find('#ays_pd_answer_box_shadow_color').val('rgba(21, 62, 113, 0.14)').change();
            $(document).find('#ays_pd_answer_box_shadow_x_offset').val(0);
            $(document).find('#ays_pd_answer_box_shadow_y_offset').val(4);
            $(document).find('#ays_pd_answer_box_shadow_z_offset').val(9);

            $(document).find("#ays_pd_enable_title_text_shadow").prop('checked', false).change();
            $(document).find('#ays_pd_title_text_shadow_color').val('rgba(234,234,234,0)').change();
            $(document).find('#ays_pd_title_text_shadow_x_offset').val(2);
            $(document).find('#ays_pd_title_text_shadow_y_offset').val(2);
            $(document).find('#ays_pd_title_text_shadow_z_offset').val(2);

            $(document).find('#ays_pd_title_alignment').val('left').change();
            $(document).find('#ays_pd_enable_title_alignment_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_title_alignment_mobile').val('left').change();
            $(document).find('div.ays_pd_title_alignment_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_desc_alignment').val('left').change();
            $(document).find('#ays_pd_enable_desc_alignment_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_desc_alignment_mobile').val('left').change();
            $(document).find('div.ays_pd_desc_alignment_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_answer_view').val('grid').change();
            $(document).find('#ays_pd_enable_answer_view_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_answer_view_mobile').val('grid').change();
            $(document).find('div.ays_pd_answer_view_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_description_font_size').val(18);
            $(document).find('#ays_pd_description_font_size_for_mobile').val(18);

			$(document).find('#ays_pd_title_font_size').val(30);
            $(document).find('#ays_pd_title_font_size_for_mobile').val(30);

            $(document).find("#ays_pd_enable_description_text_shadow").prop('checked', false).change();
            $(document).find('#ays_pd_description_text_shadow_color').val('rgba(234,234,234,0)').change();
            $(document).find('#ays_pd_description_text_shadow_x_offset').val(2);
            $(document).find('#ays_pd_description_text_shadow_y_offset').val(2);
            $(document).find('#ays_pd_description_text_shadow_z_offset').val(2);

            $(document).find('#ays_pd_change_group_name').val('Group');
            $(document).find('#ays_pd_change_word_name').val('Word');
            $(document).find('#ays_pd_change_translation_name').val('Translation');
			// Menu styles start
            $(document).find('#ays_pd_menu_items').val('text-icon').change();
            $(document).find('#ays_pd_enable_menu_items_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_menu_items_mobile').val('icon').change();
            $(document).find('div.ays_pd_menu_items_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_menu_position').val('left').change();
            $(document).find('#ays_pd_enable_menu_position_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_menu_position_mobile').val('top').change();
            $(document).find('div.ays_pd_menu_position_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_menu_layout').val('grid').change();
            $(document).find('#ays_pd_enable_menu_layout_mobile').prop('checked', false).change();
            $(document).find('#ays_pd_menu_layout_mobile').val('grid').change();
            $(document).find('div.ays_pd_menu_layout_mobile_container').css('display', 'none');
            // Menu styles end

            $(document).find('#ays_pd_button_text_color').val('#ffffff').change();

            $(document).find('#ays_pd_buttons_font_size').val(14);
            $(document).find('#ays_pd_buttons_font_size_for_mobile').val(14);

            $(document).find('#ays_pd_buttons_left_right_padding').val(12);
            $(document).find('#ays_pd_buttons_top_bottom_padding').val(7);

            $(document).find('#ays_pd_buttons_border_radius').val(6);
			$(document).find('#ays_pd_container_border_radius').val(6);
            $(document).find('#ays_pd_container_border_radius_mobile').val(6);
			$(document).find('#ays_pd_container_border_width').val(0);
            $(document).find('#ays_pd_container_border_width_mobile').val(0);

            $(document).find('#ays_pd_container_border_style').val('solid').change();
            $(document).find('#ays_pd_enable_container_border_style_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_container_border_style_mobile').val('solid').change();
            $(document).find('div.ays_pd_container_border_style_mobile_container').css('display', 'block');

            $(document).find('#ays_pd_question_font_size').val(16);
            $(document).find('#ays_pd_question_font_size_for_mobile').val(16);

            $(document).find("#ays_pd_enable_answer_border").prop('checked', false).change();

			$(document).find('#ays_pd_answer_border_width').val(1);
            $(document).find('#ays_pd_enable_answer_border_width_mobile').prop('checked', true).change();
            $(document).find('#ays_pd_answer_border_width_mobile').val(1);
            $(document).find('div.ays_pd_answer_border_width_mobile_container').css('display', 'block');

			$(document).find('#ays_pd_answer_border_style').val('solid').change();
            $(document).find('#ays_pd_answer_font_size').val(15);
            $(document).find('#ays_pd_answer_font_size_for_mobile').val(15);

            $(document).find('#ays_custom_class').val('');

			$(document).find('.ays_pd_current_device_name_pc_default_on').css('display', 'block');
            $(document).find('.ays_pd_option_for_desktop, .ays_pd_option_for_mobile_device_cb').trigger('click');
            $(document).find("#tab1").goToNormal();
        });

        $(document).on('change', '#ays_pd_menu_position, #ays_pd_menu_position_mobile', function() {
            var value = $(this).val();
            var id = $(this).attr('id');

            if (id == 'ays_pd_menu_position') {
                var manuLayoutSelect = $(document).find('#ays_pd_menu_layout');
            } else {
                var manuLayoutSelect = $(document).find('#ays_pd_menu_layout_mobile');
            }

            if (value == 'left') {
                manuLayoutSelect.prop('disabled', true);
            } else {
                manuLayoutSelect.prop('disabled', false);
            }
        })

        $(document).on('mouseover', '.ays-dashicons', function(){
            var allRateStars = $(document).find('.ays-dashicons');
            var index = allRateStars.index(this);
            allRateStars.removeClass('ays-dashicons-star-filled').addClass('ays-dashicons-star-empty');
            for (var i = 0; i <= index; i++) {
                allRateStars.eq(i).removeClass('ays-dashicons-star-empty').addClass('ays-dashicons-star-filled');
            }
        });
        
        $(document).on('mouseleave', '.ays-rated-link', function(){
            $(document).find('.ays-dashicons').removeClass('ays-dashicons-star-filled').addClass('ays-dashicons-star-empty');                
        });

        $(document).on('change', '#ays_pd_enable_menu_position_mobile', function() {
            var state = $(this).prop('checked');
            var manuPositionSelect = $(document).find('#ays_pd_menu_position');
            var manuPositionMobileSelect = $(document).find('#ays_pd_menu_position_mobile');
            var manuLayoutSelect = $(document).find('#ays_pd_menu_layout_mobile');

            var menuPositionVal = state ? manuPositionMobileSelect.val() : manuPositionSelect.val();

            if (menuPositionVal == 'left') {
                manuLayoutSelect.prop('disabled', true);
            } else {
                manuLayoutSelect.prop('disabled', false);
            }
        });

		$(document).on('change', '.ays_toggle_mobile_checkbox', function (e) {
            var state = $(this).prop('checked');
            let parent = $(this).parents('.ays_toggle_parent');
            switch (state) {
                case true:
                    parent.find('.ays_toggle_target').show(250);
                    break;
                case false:
                    parent.find('.ays_toggle_target').hide(250);
                    break;
            }
        });

		$(document).on('change', '.ays_toggle', function (e) {
            let state = $(this).prop('checked');
            if($(this).hasClass('ays_toggle_slide')){
                switch (state) {
                    case true:
                        $(this).parent().find('.ays_toggle_target').slideDown(250);
                        break;
                    case false:
                        $(this).parent().find('.ays_toggle_target').slideUp(250);
                        break;
                }
            }else{
                switch (state) {
                    case true:
                        $(this).parent().find('.ays_toggle_target').show(250);
                        break;
                    case false:
                        $(this).parent().find('.ays_toggle_target').hide(250);
                        break;
                }
            }
        });

		$('#ays-pd-lb-table').dataTable( { 
			
		} );

		// users vocabulary
		$(document).find('#ays_pd_users_select').on('change', function() {
			selectUserVocabulary($(this));
		});

		//Reports count per day

		if(typeof(PdChartData) !== 'undefined'){

			var perData = PdChartData.gamesCountPerDayData;           

			for (var i = 0; i < perData.length; i++) {
				perData[i] = new Array(
					new Date(
						perData[i][0]
					),
					perData[i][1]
				);
			}
			google.charts.load('current', {
				packages: ['corechart']
			}).then(function () {
				var data = new google.visualization.DataTable();
				data.addColumn('date', 'Date');
				data.addColumn('number', 'Count');
				
				data.addRows(perData);

				var populationRange = data.getColumnRange(1);

				var logOptions = {

					width: '100%',
					height: 300,
					fontSize: 14,
					hAxis: {
						title: 'Date',
						format: 'MMM d',
						gridlines: {count: 15}
					},
					vAxis: {
						title: 'Count'
					}
				};

				var logChart = new google.visualization.LineChart(document.getElementById('pd_games_chart_div'));
				logChart.draw(data, logOptions);
				dictionaryresizeChart(logChart, data, logOptions);
			});



			var perDataWords = PdChartData.wordsCountPerDayData;           

			for (var i = 0; i < perDataWords.length; i++) {
				perDataWords[i] = new Array(
					new Date(
						perDataWords[i][0]
					),
					perDataWords[i][1]
				);
			}
			google.charts.load('current', {
				packages: ['corechart']
			}).then(function () {
				var data = new google.visualization.DataTable();
				data.addColumn('date', 'Date');
				data.addColumn('number', 'Count');
				
				data.addRows(perDataWords);

				var populationRange = data.getColumnRange(1);

				var logOptions = {

					width: '100%',
					height: 300,
					fontSize: 14,
					hAxis: {
						title: 'Date',
						format: 'MMM d',
						gridlines: {count: 15}
					},
					vAxis: {
						title: 'Count'
					}
				};

				var logChart = new google.visualization.LineChart(document.getElementById('pd_words_chart_div'));
				logChart.draw(data, logOptions);
				dictionaryresizeChart(logChart, data, logOptions);

			});

			var perDataUsers = PdChartData.usersCountPerDayData;           

			for (var i = 0; i < perDataUsers.length; i++) {
				perDataUsers[i] = new Array(
					new Date(
						perDataUsers[i][0]
					),
					perDataUsers[i][1]
				);
			}
			google.charts.load('current', {
				packages: ['corechart']
			}).then(function () {
				var data = new google.visualization.DataTable();
				data.addColumn('date', 'Date');
				data.addColumn('number', 'Count');
				
				data.addRows(perDataUsers);

				var populationRange = data.getColumnRange(1);

				var logOptions = {

					width: '100%',
					height: 300,
					fontSize: 14,
					hAxis: {
						title: 'Date',
						format: 'MMM d',
						gridlines: {count: 15}
					},
					vAxis: {
						title: 'Count'
					}
				};

				var logChart = new google.visualization.LineChart(document.getElementById('pd_users_chart_div'));
				logChart.draw(data, logOptions);
				dictionaryresizeChart(logChart, data, logOptions);
			});
		}

		function dictionaryresizeChart(logchart, data, options){
			//create trigger to resizeEnd event
			$(window).resize(function() {
				if(this.resizeTO) clearTimeout(this.resizeTO);
				this.resizeTO = setTimeout(function() {
					$(this).trigger('resizeEnd');
				}, 100);
			});
			//redraw graph when window resize is completed
			$(window).on('resizeEnd', function() {
				logchart.draw( data, options );
			});
		}

		function selectUserVocabulary(el) {
			var selectedUserId = el.val();
			var currentUrl = window.location.href;

			if (currentUrl.indexOf('&user=') == -1) {
				currentUrl += '&user=' + selectedUserId;
			} else {
				var basePageUrl = currentUrl.split('?')[0] + '?page=personal-dictionary-dictionary-user-vocabulary&tab=2';
				if (selectedUserId == 0) {
					currentUrl = basePageUrl;
				} else {
					currentUrl = basePageUrl + '&user=' + selectedUserId;
				}
			}

			location.href = currentUrl;
		}

		// Add Image 
        $(document).on('click', '.ays-pd-add-image', function (e) {
            openMediaUploaderForImage(e, $(this));
        });

        // Remove Image
        $(document).on('click', '.removeImage', function (e) {
            var $this = $(this);
            $this.parents('.ays-pd-image-container').find('.ays-pd-image-body').fadeOut(500);
            $this.parents('.ays-pd-image-container').find('.ays-pd-add-image').text( PersonalDictionaryAdmin.addImage );
            setTimeout(function(){
                $(document).find("#ays_pd_logo_enable_image_url").prop("checked" , false);
                $this.parents('.ays-pd-image-container').parent().find('.ays-pd-logo-open-close').hide();
                $this.parents('.ays-pd-image-container').parent().find('.ays-pd-logo-open').hide();
                $this.parents('.ays-pd-image-container').find('.ays-pd-img').removeAttr('src');
                $this.parents('.ays-pd-image-container').find('.ays-pd-img-src').val('');
                $(document).find('.ays-pd-logo-url-box').addClass('display_none');
				$(document).find('.ays_pd_logo_position').addClass('display_none');
            }, 500);
        });

        $(document).on("click", ".ays-pd-cards-block .ays-pd-card__footer button.status-missing", function(e){
            var $this = $(this);
            var thisParent = $this.parents(".ays-pd-cards-block");

            $this.prop('disabled', true);
            $this.addClass('disabled');

            var loader_html = '<i class="fa fa-spinner fa-spin" aria-hidden="true"></i>';

            $this.html(loader_html);

            var attr_plugin = $this.attr('data-plugin');
            var wp_nonce = thisParent.find('#ays_pd_ajax_install_plugin_nonce').val();

            var data = {
                action: 'ays_pd_install_plugin',
                _ajax_nonce: wp_nonce,
                plugin: attr_plugin,
                type: 'plugin'
            };

            $.ajax({
                url: personalDictionary.ajax,
                method: 'post',
                dataType: 'json',
                data: data,
                success: function (response) {
                    if (response.success) {
                        swal.fire({
                            type: 'success',
                            html: "<h4>"+ response['data']['msg'] +"</h4>"
                        }).then( function(res) {
                            if ( $this.hasClass('status-missing') ) {
                                $this.removeClass('status-missing');
                            }
                            $this.text(personalDictionary.activated);
                            $this.addClass('status-active');
                        });
                    }
                    else {
                        swal.fire({
                            type: 'info',
                            html: "<h4>"+ response['data'][0]['message'] +"</h4>"
                        }).then( function(res) {
                            $this.text(personalDictionary.errorMsg);
                        });
                    }
                },
                error: function(){
                    swal.fire({
                        type: 'info',
                        html: "<h2>"+ personalDictionary.loadResource +"</h2><br><h6>"+ personalDictionary.somethingWentWrong +"</h6>"
                    }).then( function(res) {
                        $this.text(personalDictionary.errorMsg);
                    });                
                }
            });
        });

        $(document).on("click", ".ays-pd-cards-block .ays-pd-card__footer button.status-installed", function(e){
            var $this = $(this);
            var thisParent = $this.parents(".ays-pd-cards-block");

            $this.prop('disabled', true);
            $this.addClass('disabled');

            var loader_html = '<i class="fa fa-spinner fa-spin" aria-hidden="true"></i>';

            $this.html(loader_html);

            var attr_plugin = $this.attr('data-plugin');
            var wp_nonce = thisParent.find('#ays_pd_ajax_install_plugin_nonce').val();

            var data = {
                action: 'ays_pd_activate_plugin',
                _ajax_nonce: wp_nonce,
                plugin: attr_plugin,
                type: 'plugin'
            };

            $.ajax({
                url: personalDictionary.ajax,
                method: 'post',
                dataType: 'json',
                data: data,
                success: function (response) {
                    if( response.success ){
                        swal.fire({
                            type: 'success',
                            html: "<h4>"+ response['data'] +"</h4>"
                        }).then( function(res) {
                            if ( $this.hasClass('status-installed') ) {
                                $this.removeClass('status-installed');
                            }
                            $this.text(personalDictionary.activated);
                            $this.addClass('status-active disabled');
                        });
                    } else {
                        swal.fire({
                            type: 'info',
                            html: "<h4>"+ response['data'][0]['message'] +"</h4>"
                        });
                    }
                },
                error: function(){
                    swal.fire({
                        type: 'info',
                        html: "<h2>"+ personalDictionary.loadResource +"</h2><br><h6>"+ personalDictionary.somethingWentWrong +"</h6>"
                    }).then( function(res) {
                        $this.text(personalDictionary.errorMsg);
                    });                
                }
            });
        });
        
        $(document).find('.ays-pd-accordion-arrow-box').on('click', function(e) {
            var _this = $(this);
            openPdCloseAccordion( _this );
        });

        function openPdCloseAccordion( _this ){
            var parent = _this.closest(".ays-pd-accordion-options-main-container");
            var container = parent.find('.ays-pd-accordion-options-box');

            if( parent.attr('data-collapsed') === 'true' ){
                setTimeout( function() {
                    container.slideDown();
                    parent.find('.ays-pd-accordion-arrow-box .ays-pd-accordion-arrow').removeClass('ays-pd-accordion-arrow-right').addClass('ays-pd-accordion-arrow-down');
                    parent.attr('data-collapsed', 'false');
                    parent.find('.ays-pd-accordion-options-main-container').attr('data-collapsed', 'false');
                }, 150);
            }else{
                setTimeout( function() {
                    container.slideUp();
                    parent.find('.ays-pd-accordion-arrow-box .ays-pd-accordion-arrow').removeClass('ays-pd-accordion-arrow-down').addClass('ays-pd-accordion-arrow-right');
                    parent.attr('data-collapsed', 'true');
                    parent.find('.ays-pd-accordion-options-main-container').attr('data-collapsed', 'true');
                }, 150);
            }
        }

        // Toggle mobile settings start
        $(document).find('.ays_pd_different_settings_for_mobile').on('change', toggleMobileSettings);
        $(document).find('.ays_pd_option_for_desktop, .ays_pd_option_for_mobile_device_cb').on('click', toggleMobileSettingsCb);
        $(document).find('.ays_pd_image_option, .ays_pd_audio_option').on('click', toggleMediaSettings);
        
        // Toggle mobile settings end

        function toggleMobileSettings() {
            var optionDiv = $(this).parents('.ays_pd_pc_and_mobile_container');
            var deviceNames = optionDiv.find('.ays_pd_current_device_name');
            var mobileOptionDiv = optionDiv.find('.ays_pd_option_for_mobile_device');
            var cbLabel = optionDiv.find('.ays_pd_mobile_settings_container label');

            if ($(this).prop('checked')) {
                deviceNames.addClass('show');
                mobileOptionDiv.addClass('show');
                cbLabel.addClass('active');
            } else {
                deviceNames.removeClass('show');
                mobileOptionDiv.removeClass('show');
                cbLabel.removeClass('active');
            }
        }

        function toggleMobileSettingsCb() {
            var mainContainer = $(this).parent();
            var desktopContainer = mainContainer.find('.ays_pd_option_for_desktop');
            var mobileContainer = mainContainer.find('.ays_pd_option_for_mobile_device');
            var desktopCb = desktopContainer.find('.ays-pd-onoffswitch-checkbox');
            var mobileDeviceCb = mobileContainer.find('.ays-pd-onoffswitch-checkbox');
            var deviceNames = mainContainer.find('.ays_pd_current_device_name');

            if (desktopCb.is(':checked')) {
                if (!mobileContainer.hasClass('show')) {
                    mobileContainer.addClass('show');
                    mobileDeviceCb.prop('checked', true);
                    deviceNames.show().fadeIn('300');
                }
            } else {
                if (!mobileDeviceCb.is(':checked')) {
                    mobileContainer.removeClass('show');
                    deviceNames.hide().fadeOut('300');
                }
            }
        }

        function toggleMediaSettings(){
            var imageOption = $(document).find('.ays_pd_image_option');
            var audiOption = $(document).find('.ays_pd_audio_option');
            var image = imageOption.find('.ays-pd-onoffswitch-checkbox');
            var audio = audiOption.find('.ays-pd-onoffswitch-checkbox');
            var mainContainer = $(document).find('.ays_pd_show_media');
            
            if(audio.is(':checked') || image.is(':checked')) {
                mainContainer.show('250');
            } else {
                mainContainer.hide('250');
            }
            if(audio.is(':checked') ){
                mainContainer.find('#ays_pd_enable_add_audio_to_games').prop('disabled', false);
            } else {
                mainContainer.find('#ays_pd_enable_add_audio_to_games').prop('disabled', true);
                mainContainer.find('#ays_pd_enable_add_audio_to_games').prop('checked', false);
            }
            if(image.is(':checked') ){
                mainContainer.find('#ays_pd_enable_add_image_to_games').prop('disabled', false );
            } else {
                mainContainer.find('#ays_pd_enable_add_image_to_games').prop('disabled', true);
                mainContainer.find('#ays_pd_enable_add_image_to_games').prop('checked', false);
            }
        }

	});

})( jQuery );

function selectElementContents(el) {
	if (window.getSelection && document.createRange) {
		var _this = jQuery(document).find('input.ays_pd_shortcode');
		var _thisVal = _this.val();
		
		_this.select();
		document.execCommand('copy');
		
		_this.attr( "data-original-title", pdAdminLangObj.copied );
		_this.attr( "title", pdAdminLangObj.copied );

		_this.tooltip("show");

	} else if (document.selection && document.body.createTextRange) {
		var textRange = document.body.createTextRange();
		textRange.moveToElementText(el);
		textRange.select();
	}
}

function openMediaUploaderForImage(e, element) {
    e.preventDefault();
    var aysUploader = wp.media({
        title: 'Upload',
        button: {
            text: 'Upload'
        },
        library: {
            type: 'image'
        },
        multiple: false
    }).on('select', function () {
        var attachment = aysUploader.state().get('selection').first().toJSON();
        var answerImgCont = element.parents('.ays-pd-image-container').find('.ays-pd-image-body');
        var img = answerImgCont.find('img.ays-pd-img');
        var hiddenInp = answerImgCont.find('input.ays-pd-img-src');

        element.text( PersonalDictionaryAdmin.editImage );
        img.attr('src', attachment.url);
        hiddenInp.val(attachment.url);
        answerImgCont.show();
        img.removeClass('fade');
        jQuery(document).find(".ays-pd-logo-url-box").removeClass("display_none");
		jQuery(document).find(".ays_pd_logo_position").removeClass("display_none");
        var checkImgUrl = jQuery(document).find("#ays_pd_logo_enable_image_url").prop("checked");
        element.parents('.ays-pd-image-container').parent().find('.ays-pd-logo-open').show();
        if(checkImgUrl){
            element.parents('.ays-pd-image-container').parent().find('.ays-pd-logo-open-close').show();
        }
    }).open();
    return false;
}
