<?php
    class Personal_Dictionary_Settings_Actions{
        private $plugin_name;

        public function __construct($plugin_name) {
            $this->plugin_name = $plugin_name;
        }

        // Store Global settings
        public function ays_pd_store_global_settings(){
            global $wpdb;

            // Default options
            $meta_options = array(
                "learned_points" => 10,
                "right_points" => 1,
                "wrong_points" => -0.25,
                "enable_full_screen_mode" => "off",
                "enable_full_screen_mode_mobile" => "off",
                "enable_add_words_from_front" => "off",
                "enable_add_image_from_front" => "off",
                "enable_add_audio_from_front" => "off",
                "enable_add_audio_from_front" => "off",
                "enable_add_image_to_games" => "off",
                "enable_add_audio_to_games" => "off",
                "show_games" => "on",
                "show_game_find_the_word" => "on",
                "show_game_find_the_translation" => "on",
                "show_game_matching_words" => "on",
                "show_game_write_the_translation" => "on",
                "show_correct_answer" => "off",
                "show_correct_answer_mobile" => "off",
                "show_next_button" => "on",
                "show_next_button_mobile" => "on",
                "games_animation_effect" => "none",
                "enable_games_animation_effect_mobile" => "on",
                "games_animation_effect_mobile" => "none",
                "bg_color" => "#ffffff",
                "enable_bg_color_mobile" => "on",
                "bg_color_mobile" => "#ffffff",
                "main_color" => "#1A7EFB",
                "enable_main_color_mobile" => "on",
                "main_color_mobile" => "#1A7EFB",
                "text_color" => "#000",
                "enable_text_color_mobile" => "on",
                "text_color_mobile" => "#000",
                "container_border_color" => "#ccc",
                "enable_container_border_color_mobile" => "on",
                "container_border_color_mobile" => "#ccc",
                "button_text_color" => "#ffffff",
                "button_font_size" => 14,
                "buttons_left_right_padding" => 12,
                "buttons_top_bottom_padding" => 7,
                "buttons_border_radius" => 6,
                "container_border_radius" => 6,
                "container_border_radius_mobile" => 6,
                "enable_container_border_radius_mobile" => "on",
                "container_border_width" => 0,
                "container_border_width_mobile" => 0,
                "enable_container_border_width_mobile" => "on",
                "answer_border_width" => 1,
                "enable_answer_border_width_mobile" => "on",
                "answer_border_width_mobile" => 1,
                "container_border_style" => 'solid',
                "enable_container_border_style_mobile" => 'on',
                "container_border_style_mobile" => 'solid',
                "enable_container_box_shadow" => "on",
                "container_box_shadow_color" => "#153e7124",
                "container_box_shadow_x_offset" => 0,
                "container_box_shadow_y_offset" => 4,
                "container_box_shadow_z_offset" => 9,
                "enable_answer_box_shadow" => "off",
                "answer_box_shadow_color" => "#153e7124",
                "answer_box_shadow_x_offset" => 0,
                "answer_box_shadow_y_offset" => 4,
                "answer_box_shadow_z_offset" => 9,
                "answer_border_style" => 'solid',
                "question_font_size" => 16,
                "question_font_size_for_mobile" => 16,
                "answer_font_size" => 15,
                "answer_font_size_for_mobile" => 15,
                "custom_class" => "",
                "custom_css" => "",
                "title" => "Dictionary",
                "show_title" => "on",
                "show_title_mobile" => "on",
                "enable_title_text_shadow" => "off",
                "title_text_shadow_color" => "#333",
                "title_text_shadow_x_offset" => 2,
                "title_text_shadow_y_offset" => 2,
                "title_text_shadow_z_offset" => 2,
                "title_alignment" => "left",
                "enable_title_alignment_mobile" => "on",
                "title_alignment_mobile" => "left",
                "answer_view" => "grid",
                "enable_answer_view_mobile" => "on",
                "answer_view_mobile" => "grid",
                "pd_description" => "",
                "description_font_size" => 18,
                "description_font_size_for_mobile" => 18,
                "title_font_size"               => 30,
                "title_font_size_for_mobile"    => 30,
                "button_font_size_for_mobile" => 14,
                "desc_alignment" => "left",
                "enable_description_text_shadow" => "off",
                "enable_answer_border" => "on",
                "description_text_shadow_color" => "#333",
                "description_text_shadow_x_offset" => 2,
                "description_text_shadow_y_offset" => 2,
                "description_text_shadow_z_offset" => 2,
                "menu_items" => "text-icon",
                "enable_menu_items_mobile" => "on",
                "menu_items_mobile" => "icon",
                "menu_position" => "left",
                "enable_menu_position_mobile" => "on",
                "menu_position_mobile" => "top",
                "menu_layout" => "grid",
                "enable_menu_layout_mobile" => "off",
                "menu_layout_mobile" => "grid",
                "change_group_name" => 'Group',
                "change_word_name" => 'Word',
                "change_translation_name" => 'Translation',
            );

            if( isset( $_POST["ays_pd_submit_top"] ) ){
                // Update options after save
                $learned_points = isset($_POST['ays_pd_learned_points']) && $_POST['ays_pd_learned_points'] != '' ? floatval( sanitize_text_field( $_POST['ays_pd_learned_points'] ) ) : 10;
                $right_points = isset($_POST['ays_pd_right_points']) && $_POST['ays_pd_right_points'] != '' ? floatval( sanitize_text_field( $_POST['ays_pd_right_points'] ) ) : 1;
                $wrong_points = isset($_POST['ays_pd_wrong_points']) && $_POST['ays_pd_wrong_points'] != '' ? floatval( sanitize_text_field( $_POST['ays_pd_wrong_points'] ) ) : -0.25;
                $enable_full_screen_mode = isset($_POST['ays_pd_enable_full_screen_mode']) && $_POST['ays_pd_enable_full_screen_mode'] == 'on' ? 'on' : 'off';
                $enable_full_screen_mode_mobile = isset($_POST['ays_pd_enable_full_screen_mode_mobile']) && $_POST['ays_pd_enable_full_screen_mode_mobile'] == 'on' ? 'on' : 'off';
                $enable_add_words_from_front = isset($_POST['ays_pd_enable_add_words_from_front']) && $_POST['ays_pd_enable_add_words_from_front'] == 'on' ? 'on' : 'off';
                $enable_add_image_from_front = isset($_POST['ays_pd_enable_add_image_from_front']) && $_POST['ays_pd_enable_add_image_from_front'] == 'on' ? 'on' : 'off';
                $enable_add_audio_from_front = isset($_POST['ays_pd_enable_add_audio_from_front']) && $_POST['ays_pd_enable_add_audio_from_front'] == 'on' ? 'on' : 'off';
                $enable_add_image_to_games = isset($_POST['ays_pd_enable_add_image_to_games']) && $_POST['ays_pd_enable_add_image_to_games'] == 'on' ? 'on' : 'off';
                $enable_add_audio_to_games = isset($_POST['ays_pd_enable_add_audio_to_games']) && $_POST['ays_pd_enable_add_audio_to_games'] == 'on' ? 'on' : 'off';
                $show_games = isset($_POST['ays_pd_show_games']) && $_POST['ays_pd_show_games'] == 'on' ? 'on' : 'off';
                $show_game_find_the_word = isset($_POST['ays_pd_show_game_find_the_word']) && $_POST['ays_pd_show_game_find_the_word'] == 'on' ? 'on' : 'off';
                $show_game_find_the_translation = isset($_POST['ays_pd_show_game_find_the_translation']) && $_POST['ays_pd_show_game_find_the_translation'] == 'on' ? 'on' : 'off';
                $show_game_matching_words = isset($_POST['ays_pd_show_game_matching_words']) && $_POST['ays_pd_show_game_matching_words'] == 'on' ? 'on' : 'off';
                $show_game_write_the_translation = isset($_POST['ays_pd_show_game_write_the_translation']) && $_POST['ays_pd_show_game_write_the_translation'] == 'on' ? 'on' : 'off';
                $show_correct_answer  = isset($_POST['ays_pd_show_correct_answer']) && $_POST['ays_pd_show_correct_answer'] == 'on' ? "on" : "off";
                $show_correct_answer_mobile  = isset($_POST['ays_pd_show_correct_answer_mobile']) && $_POST['ays_pd_show_correct_answer_mobile'] == 'on' ? "on" : "off";
                $show_next_button  = isset($_POST['ays_pd_show_next_button']) && $_POST['ays_pd_show_next_button'] == 'on' ? "on" : "off";
                $show_next_button_mobile  = isset($_POST['ays_pd_show_next_button_mobile']) && $_POST['ays_pd_show_next_button_mobile'] == 'on' ? "on" : "off";
                // Animation Effect
                $games_animation_effect = isset($_POST['ays_pd_games_animation_effect']) && $_POST['ays_pd_games_animation_effect'] != '' ? sanitize_text_field( $_POST['ays_pd_games_animation_effect'] ) : 'none';                
                // Enable Animation Effect Mobile
                $enable_games_animation_effect_mobile = isset($_POST['ays_pd_enable_games_animation_effect_mobile']) && $_POST['ays_pd_enable_games_animation_effect_mobile'] == 'on' ? 'on' : 'off';
                //Animation Effect Mobile
                $games_animation_effect_mobile = isset($_POST['ays_pd_games_animation_effect_mobile']) && $_POST['ays_pd_games_animation_effect_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_games_animation_effect_mobile'] ) : 'none';
                // Background color
                $bg_color   = isset($_POST['ays_pd_bg_color']) && $_POST['ays_pd_bg_color'] != '' ? sanitize_text_field( $_POST['ays_pd_bg_color'] ) : "#ffffff";
                // Enable Background color Mobile
                $enable_bg_color_mobile = isset($_POST['ays_pd_enable_bg_color_mobile']) && $_POST['ays_pd_enable_bg_color_mobile'] == 'on' ? 'on' : 'off';
                // Background color Mobile
                $bg_color_mobile = isset($_POST['ays_pd_bg_color_mobile']) && $_POST['ays_pd_bg_color_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_bg_color_mobile'] ) : '#ffffff';
                // Main Color
                $main_color = isset($_POST['ays_pd_main_color']) && $_POST['ays_pd_main_color'] != '' ? sanitize_text_field( $_POST['ays_pd_main_color'] ) : "#1A7EFB";
                // Enable Main Color Mobile
                $enable_main_color_mobile = isset($_POST['ays_pd_enable_main_color_mobile']) && $_POST['ays_pd_enable_main_color_mobile'] == 'on' ? 'on' : 'off';
                // Main Color Mobile
                $main_color_mobile = isset($_POST['ays_pd_main_color_mobile']) && $_POST['ays_pd_main_color_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_main_color_mobile'] ) : '#1A7EFB';
                // Text Color
                $text_color = isset($_POST['ays_pd_text_color']) && $_POST['ays_pd_text_color'] != '' ? sanitize_text_field( $_POST['ays_pd_text_color'] ) : "#000";
                // Enable Text Color Mobile
                $enable_text_color_mobile = isset($_POST['ays_pd_enable_text_color_mobile']) && $_POST['ays_pd_enable_text_color_mobile'] == 'on' ? 'on' : 'off';
                // Text Color Mobile
                $text_color_mobile = isset($_POST['ays_pd_text_color_mobile']) && $_POST['ays_pd_text_color_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_text_color_mobile'] ) : '#000';            
                // Container Border Color
                $container_border_color = isset($_POST['ays_pd_container_border_color']) && $_POST['ays_pd_container_border_color'] != '' ? sanitize_text_field( $_POST['ays_pd_container_border_color'] ) : "#ccc";
                // Enable Container Border Color Mobile
                $enable_container_border_color_mobile = isset($_POST['ays_pd_enable_container_border_color_mobile']) && $_POST['ays_pd_enable_container_border_color_mobile'] == 'on' ? 'on' : 'off';
                // Container Border Color Mobile
                $container_border_color_mobile = isset($_POST['ays_pd_container_border_color_mobile']) && $_POST['ays_pd_container_border_color_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_container_border_color_mobile'] ) : '#ccc';
                $answer_border_color = isset($_POST['ays_pd_answer_border_color']) && $_POST['ays_pd_answer_border_color'] != '' ? sanitize_text_field( $_POST['ays_pd_answer_border_color'] ) : "rgba(148,148,148,0.85)";
                $answer_bg_color = isset($_POST['ays_pd_answer_bg_color']) && $_POST['ays_pd_answer_bg_color'] != '' ? sanitize_text_field( $_POST['ays_pd_answer_bg_color'] ) : "#ffffff";
                $button_text_color = isset($_POST['ays_pd_button_text_color']) && $_POST['ays_pd_button_text_color'] != '' ? sanitize_text_field( $_POST['ays_pd_button_text_color'] ) : "#ffffff";
                $button_font_size = isset($_POST['ays_pd_buttons_font_size']) && $_POST['ays_pd_buttons_font_size'] != '' ? absint(sanitize_text_field( $_POST['ays_pd_buttons_font_size'] )) : 14;
                $buttons_left_right_padding = isset($_POST['ays_pd_buttons_left_right_padding']) && $_POST['ays_pd_buttons_left_right_padding'] != '' ? absint(sanitize_text_field( $_POST['ays_pd_buttons_left_right_padding'] )) : 12;
                $button_font_size_for_mobile = isset($_POST['ays_pd_buttons_font_size_for_mobile']) && $_POST['ays_pd_buttons_font_size_for_mobile'] != '' && $_POST['ays_pd_buttons_font_size_for_mobile'] != 0 ? absint( sanitize_text_field($_POST['ays_pd_buttons_font_size_for_mobile'] )) : 14;
                $buttons_top_bottom_padding = isset($_POST['ays_pd_buttons_top_bottom_padding']) && $_POST['ays_pd_buttons_top_bottom_padding'] != '' ? absint(sanitize_text_field( $_POST['ays_pd_buttons_top_bottom_padding'] )) : 7;
                $buttons_border_radius = isset($_POST['ays_pd_buttons_border_radius']) && $_POST['ays_pd_buttons_border_radius'] != '' ? absint(sanitize_text_field( $_POST['ays_pd_buttons_border_radius'] )) : 6;
                $change_group_name = isset($_POST['ays_pd_change_group_name']) && $_POST['ays_pd_change_group_name'] != '' ? sanitize_text_field( $_POST['ays_pd_change_group_name']) : 'Group';
                $change_word_name = isset($_POST['ays_pd_change_word_name']) && $_POST['ays_pd_change_word_name'] != '' ? sanitize_text_field( $_POST['ays_pd_change_word_name']) : 'Word';
                $change_translation_name = isset($_POST['ays_pd_change_translation_name']) && $_POST['ays_pd_change_translation_name'] != '' ? sanitize_text_field( $_POST['ays_pd_change_translation_name']) : 'Translation';
                
                //Container border radius
                $container_border_radius = isset($_POST['ays_pd_container_border_radius']) && $_POST['ays_pd_container_border_radius'] != '' ? absint( sanitize_text_field( $_POST['ays_pd_container_border_radius'] )) : 6;
                
                // Enable Container border radius Mobile
                $enable_container_border_radius_mobile = isset($_POST['ays_pd_enable_container_border_radius_mobile']) && $_POST['ays_pd_enable_container_border_radius_mobile'] == 'on' ? 'on' : 'off';

                // Container border radius Mobile
                $container_border_radius_mobile = isset($_POST['ays_pd_container_border_radius_mobile']) && $_POST['ays_pd_container_border_radius_mobile'] != '' ? absint( sanitize_text_field( $_POST['ays_pd_container_border_radius_mobile'] ) ): 0;

                //Container border width
                $container_border_width = isset($_POST['ays_pd_container_border_width']) && $_POST['ays_pd_container_border_width'] != '' ? absint( sanitize_text_field( $_POST['ays_pd_container_border_width'] )) : 0;
                
                // Enable Container border width Mobile
                $enable_container_border_width_mobile = isset($_POST['ays_pd_enable_container_border_width_mobile']) && $_POST['ays_pd_enable_container_border_width_mobile'] == 'on' ? 'on' : 'off';

                // Container border width Mobile
                $container_border_width_mobile = isset($_POST['ays_pd_container_border_width_mobile']) && $_POST['ays_pd_container_border_width_mobile'] != '' ? absint( sanitize_text_field( $_POST['ays_pd_container_border_width_mobile'] ) ): 1;

                //Container border style
                $container_border_style = isset($_POST['ays_pd_container_border_style']) && $_POST['ays_pd_container_border_style'] != '' ? sanitize_text_field( $_POST['ays_pd_container_border_style'] ) : 'solid';
                
                // Enable Container border style Mobile
                $enable_container_border_style_mobile = isset($_POST['ays_pd_enable_container_border_style_mobile']) && $_POST['ays_pd_enable_container_border_style_mobile'] == 'on' ? 'on' : 'off';

                // Container border style Mobile
                $container_border_style_mobile = isset($_POST['ays_pd_container_border_style_mobile']) && $_POST['ays_pd_container_border_style_mobile'] != '' ?  sanitize_text_field( $_POST['ays_pd_container_border_style_mobile'] ) : 'solid';

                //Enable Container box shadow
                $enable_container_box_shadow = (isset($_POST['ays_pd_enable_container_box_shadow']) && $_POST['ays_pd_enable_container_box_shadow'] == 'on') ? 'on' : 'off';

                //Container box shadow color
                $container_box_shadow_color = (isset($_POST['ays_pd_container_box_shadow_color']) && $_POST['ays_pd_container_box_shadow_color'] != '') ? esc_attr($_POST['ays_pd_container_box_shadow_color']) : 'rgba(21, 62, 113, 0.14)';

                //Container box X offset
                $container_box_shadow_x_offset = (isset($_POST['ays_pd_container_box_shadow_x_offset']) && ( $_POST['ays_pd_container_box_shadow_x_offset'] ) != '' && ( $_POST['ays_pd_container_box_shadow_x_offset'] ) != 0) ? esc_attr( intval( $_POST['ays_pd_container_box_shadow_x_offset'] ) ) : 0;

                //Container box Y offset
                $container_box_shadow_y_offset = (isset($_POST['ays_pd_container_box_shadow_y_offset']) && ($_POST['ays_pd_container_box_shadow_y_offset']) != '' && ($_POST['ays_pd_container_box_shadow_y_offset']) != 0) ? esc_attr( intval( $_POST['ays_pd_container_box_shadow_y_offset']) ) : 4; 

                //Container box Z offset
                $container_box_shadow_z_offset = (isset($_POST['ays_pd_container_box_shadow_z_offset']) && ($_POST['ays_pd_container_box_shadow_z_offset']) != '' && ($_POST['ays_pd_container_box_shadow_z_offset']) != 0) ? esc_attr( intval($_POST['ays_pd_container_box_shadow_z_offset']) ) : 9; 

                //Enable answer box shadow
                $enable_answer_box_shadow = (isset($_POST['ays_pd_enable_answer_box_shadow']) && $_POST['ays_pd_enable_answer_box_shadow'] == 'on') ? 'on' : 'off';

                //Answer box shadow color
                $answer_box_shadow_color = (isset($_POST['ays_pd_answer_box_shadow_color']) && $_POST['ays_pd_answer_box_shadow_color'] != '') ? esc_attr($_POST['ays_pd_answer_box_shadow_color']) : 'rgba(21, 62, 113, 0.14)';

                //Answer box X offset
                $answer_box_shadow_x_offset = (isset($_POST['ays_pd_answer_box_shadow_x_offset']) && ( $_POST['ays_pd_answer_box_shadow_x_offset'] ) != '' && ( $_POST['ays_pd_answer_box_shadow_x_offset'] ) != 0) ? esc_attr( intval( $_POST['ays_pd_answer_box_shadow_x_offset'] ) ) : 0;

                //Answer box Y offset
                $answer_box_shadow_y_offset = (isset($_POST['ays_pd_answer_box_shadow_y_offset']) && ($_POST['ays_pd_answer_box_shadow_y_offset']) != '' && ($_POST['ays_pd_answer_box_shadow_y_offset']) != 0) ? esc_attr( intval( $_POST['ays_pd_answer_box_shadow_y_offset']) ) : 4; 

                //Answer box Z offset
                $answer_box_shadow_z_offset = (isset($_POST['ays_pd_answer_box_shadow_z_offset']) && ($_POST['ays_pd_container_box_shadow_z_offset']) != '' && ($_POST['ays_pd_answer_box_shadow_z_offset']) != 0) ? esc_attr( intval($_POST['ays_pd_answer_box_shadow_z_offset']) ) : 9; 

                //Question font size
                $question_font_size = isset($_POST['ays_pd_question_font_size']) && $_POST['ays_pd_question_font_size'] != '' && $_POST['ays_pd_question_font_size'] > 0 ? absint( sanitize_text_field($_POST['ays_pd_question_font_size'] )) : 16;
                //Question font size for mobile
                $question_font_size_for_mobile = isset($_POST['ays_pd_question_font_size_for_mobile']) && $_POST['ays_pd_question_font_size_for_mobile'] != '' && $_POST['ays_pd_question_font_size_for_mobile'] > 0 ? absint( sanitize_text_field($_POST['ays_pd_question_font_size_for_mobile'] )) : 16;

                //Answer border width
                $answer_border_width = isset($_POST['ays_pd_answer_border_width']) && $_POST['ays_pd_answer_border_width'] != '' ? absint( sanitize_text_field( $_POST['ays_pd_answer_border_width'] )) : 1;
                
                // Enable Answer border width Mobile
                $enable_answer_border_width_mobile = isset($_POST['ays_pd_enable_answer_border_width_mobile']) && $_POST['ays_pd_enable_answer_border_width_mobile'] == 'on' ? 'on' : 'off';

                // Answer border width Mobile
                $answer_border_width_mobile = isset($_POST['ays_pd_answer_border_width_mobile']) && $_POST['ays_pd_answer_border_width_mobile'] != '' ? absint( sanitize_text_field( $_POST['ays_pd_answer_border_width_mobile'] ) ): 1;

                //Answer border style
                $answer_border_style = isset($_POST['ays_pd_answer_border_style']) && $_POST['ays_pd_answer_border_style'] != '' ? sanitize_text_field( $_POST['ays_pd_answer_border_style'] ) : 'solid';

                 //Answer font size
                $answer_font_size = isset($_POST['ays_pd_answer_font_size']) && $_POST['ays_pd_answer_font_size'] != '' && $_POST['ays_pd_answer_font_size'] > 0 ? absint( sanitize_text_field($_POST['ays_pd_answer_font_size'] )) : 15;
                $answer_font_size_for_mobile = isset($_POST['ays_pd_answer_font_size_for_mobile']) && $_POST['ays_pd_answer_font_size_for_mobile'] != '' && $_POST['ays_pd_answer_font_size_for_mobile'] > 0 ? absint( sanitize_text_field($_POST['ays_pd_answer_font_size_for_mobile'] )) : 15;
                $custom_class = (isset($_POST['ays_custom_class']) && sanitize_text_field( $_POST['ays_custom_class'] ) != "") ? esc_attr( sanitize_text_field( $_POST['ays_custom_class'] ) ) : '';

                if( isset($_POST['ays_pd_custom_css']) && $_POST['ays_pd_custom_css'] != '' ){
                    if( function_exists( 'sanitize_textarea_field' ) ){
                        $custom_css = sanitize_textarea_field( $_POST['ays_pd_custom_css'] );
                    }else{
                        $custom_css =  stripslashes ( esc_attr( sanitize_text_field( $_POST['ays_pd_custom_css'] ) ) );
                    }
                }else{
                    $custom_css = "";
                }

                $ays_pd_title = (isset($_POST['ays_pd_title']) && sanitize_text_field( $_POST['ays_pd_title'] ) != "") ? sanitize_text_field( $_POST['ays_pd_title'] ) : 'Dictionary';
                
                $ays_show_pd_title = (isset($_POST['ays_pd_show_title']) && sanitize_text_field( $_POST['ays_pd_show_title'] ) == "on") ? 'on' : 'off';

                $ays_show_pd_title_mobile = (isset($_POST['ays_pd_show_title_mobile']) && sanitize_text_field( $_POST['ays_pd_show_title_mobile'] ) == "on") ? 'on' : 'off';

                $enable_title_text_shadow = (isset($_POST['ays_pd_enable_title_text_shadow']) && $_POST['ays_pd_enable_title_text_shadow'] == 'on') ? 'on' : 'off';

                $title_text_shadow_color = (isset($_POST['ays_pd_title_text_shadow_color']) && $_POST['ays_pd_title_text_shadow_color'] != '') ? esc_attr($_POST['ays_pd_title_text_shadow_color']) : '#333';   

                $title_text_shadow_x_offset = (isset($_POST['ays_pd_title_text_shadow_x_offset']) && ( $_POST['ays_pd_title_text_shadow_x_offset'] ) != '' && ( $_POST['ays_pd_title_text_shadow_x_offset'] ) != 0) ? esc_attr( intval( $_POST['ays_pd_title_text_shadow_x_offset'] ) ) : 2;

                $title_text_shadow_y_offset = (isset($_POST['ays_pd_title_text_shadow_y_offset']) && ($_POST['ays_pd_title_text_shadow_y_offset']) != '' && ($_POST['ays_pd_title_text_shadow_y_offset']) != 0) ? esc_attr( intval( $_POST['ays_pd_title_text_shadow_y_offset']) ) : 2; 

                $title_text_shadow_z_offset = (isset($_POST['ays_pd_title_text_shadow_z_offset']) && ($_POST['ays_pd_title_text_shadow_z_offset']) != '' && ($_POST['ays_pd_title_text_shadow_z_offset']) != 0) ? esc_attr( absint($_POST['ays_pd_title_text_shadow_z_offset']) ) : 2;

                // Title Allignment
                $pd_title_alignment    = ( isset($_POST['ays_pd_title_alignment']) && $_POST['ays_pd_title_alignment'] != "" ) ? sanitize_text_field($_POST['ays_pd_title_alignment']) : "left";
                
                // Enable Title Allignment Mobile
                $enable_pd_title_alignment_mobile = isset($_POST['ays_pd_enable_title_alignment_mobile']) && $_POST['ays_pd_enable_title_alignment_mobile'] == 'on' ? 'on' : 'off';

                // Title Allignment Mobile
                $pd_title_alignment_mobile = isset($_POST['ays_pd_title_alignment_mobile']) && $_POST['ays_pd_title_alignment_mobile'] != '' ?  sanitize_text_field( $_POST['ays_pd_title_alignment_mobile'] ) : 'left';
                
                // Descprition Allignment
                $pd_desc_alignment    = ( isset($_POST['ays_pd_desc_alignment']) && $_POST['ays_pd_desc_alignment'] != "" ) ? sanitize_text_field($_POST['ays_pd_desc_alignment']) : "left";

                // Enable Descprition Allignment Mobile
                $enable_pd_desc_alignment_mobile = isset($_POST['ays_pd_enable_desc_alignment_mobile']) && $_POST['ays_pd_enable_desc_alignment_mobile'] == 'on' ? 'on' : 'off';

                // Descprition Allignment Mobile
                $pd_desc_alignment_mobile = isset($_POST['ays_pd_desc_alignment_mobile']) && $_POST['ays_pd_desc_alignment_mobile'] != '' ?  sanitize_text_field( $_POST['ays_pd_desc_alignment_mobile'] ) : 'left';

                // Answer View
                $pd_answer_view    = ( isset($_POST['ays_pd_answer_view']) && $_POST['ays_pd_answer_view'] != "" ) ? sanitize_text_field($_POST['ays_pd_answer_view']) : "grid";

                //Enable Answer View Mobile
                $enable_pd_answer_view_mobile = isset($_POST['ays_pd_enable_answer_view_mobile']) && $_POST['ays_pd_enable_answer_view_mobile'] == 'on' ? 'on' : 'off';

                //Answer View Mobile
                $pd_answer_view_mobile = isset($_POST['ays_pd_answer_view_mobile']) && $_POST['ays_pd_answer_view_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_answer_view_mobile'] ) : 'grid';

                // PD Description
                $pd_description = (isset($_POST['ays_pd_description']) && wp_kses_post( $_POST['ays_pd_description'] ) != "") ? wp_kses_post($_POST['ays_pd_description']) : '';

                $show_pd_description = (isset($_POST['ays_pd_show_description']) && sanitize_text_field( $_POST['ays_pd_show_description'] ) == "on") ? 'on' : 'off';

                $show_pd_description_mobile = (isset($_POST['ays_pd_show_description_mobile']) && sanitize_text_field( $_POST['ays_pd_show_description_mobile'] ) == "on") ? 'on' : 'off';
                
                // Add logo
                $pd_logo = (isset( $_POST[ 'ays_pd_add_logo' ]) && $_POST[ 'ays_pd_add_logo' ] != '') ? stripslashes ( sanitize_text_field( $_POST[ 'ays_pd_add_logo' ] ) ) : '';

                // Logo url
                $pd_logo_image_url = (isset( $_POST[ 'ays_pd_logo_image_url' ] ) && $_POST[ 'ays_pd_logo_image_url' ] != '') ? sanitize_text_field( $_POST[ 'ays_pd_logo_image_url' ] ) : '';
                $pd_logo_image_url_check = (isset( $_POST[ 'ays_pd_logo_enable_image_url' ] ) && $_POST[ 'ays_pd_logo_enable_image_url' ] == 'on') ? 'on' : 'off';

                // Logo title
                $pd_logo_title = (isset($_POST["ays_pd_logo_title"]) && $_POST["ays_pd_logo_title"] != '') ? stripslashes(sanitize_text_field( $_POST["ays_pd_logo_title"] )) : '';

                //Open Logo Url in new tab
                $pd_logo_url_new_tab = (isset( $_POST[ 'ays_pd_logo_enable_image_url_new_tab' ] ) && $_POST[ 'ays_pd_logo_enable_image_url_new_tab' ] == 'on') ? "on" : 'off';

                // Logo position
                $pd_logo_position = (isset( $_POST[ 'ays_pd_logo_pos' ] ) && $_POST[ 'ays_pd_logo_pos' ] != '') ? sanitize_text_field( $_POST[ 'ays_pd_logo_pos' ] ) : 'right';

                $description_font_size = isset($_POST['ays_pd_description_font_size']) && $_POST['ays_pd_description_font_size'] != '' && $_POST['ays_pd_description_font_size'] != 0 ? absint( sanitize_text_field( $_POST['ays_pd_description_font_size'] )) : 18;
                $description_font_size_for_mobile = isset($_POST['ays_pd_description_font_size_for_mobile']) && $_POST['ays_pd_description_font_size_for_mobile'] != '' && $_POST['ays_pd_description_font_size_for_mobile'] != 0 ? absint( sanitize_text_field($_POST['ays_pd_description_font_size_for_mobile'] )) : 18;

                $title_font_size = isset($_POST['ays_pd_title_font_size']) && $_POST['ays_pd_title_font_size'] != '' && $_POST['ays_pd_title_font_size'] != 0 ? absint( sanitize_text_field( $_POST['ays_pd_title_font_size'] )) : 30;
                $title_font_size_for_mobile = isset($_POST['ays_pd_title_font_size_for_mobile']) && $_POST['ays_pd_title_font_size_for_mobile'] != '' && $_POST['ays_pd_title_font_size_for_mobile'] != 0 ? absint( sanitize_text_field($_POST['ays_pd_title_font_size_for_mobile'] )) : 30;

                // Description text shadow
                $enable_description_text_shadow = (isset($_POST['ays_pd_enable_description_text_shadow']) && $_POST['ays_pd_enable_description_text_shadow'] == 'on') ? 'on' : 'off';

                // Answer border
                $enable_answer_border = (isset($_POST['ays_pd_enable_answer_border']) && $_POST['ays_pd_enable_answer_border'] == 'on') ? 'on' : 'off';

                $description_text_shadow_color = (isset($_POST['ays_pd_description_text_shadow_color']) && $_POST['ays_pd_description_text_shadow_color'] != '') ? esc_attr($_POST['ays_pd_description_text_shadow_color']) : '#333';   

                $description_text_shadow_x_offset = (isset($_POST['ays_pd_description_text_shadow_x_offset']) && ( $_POST['ays_pd_description_text_shadow_x_offset'] ) != '' && ( $_POST['ays_pd_description_text_shadow_x_offset'] ) != 0) ? esc_attr( intval( $_POST['ays_pd_description_text_shadow_x_offset'] ) ) : 2;

                $description_text_shadow_y_offset = (isset($_POST['ays_pd_description_text_shadow_y_offset']) && ($_POST['ays_pd_description_text_shadow_y_offset']) != '' && ($_POST['ays_pd_description_text_shadow_y_offset']) != 0) ? esc_attr( intval( $_POST['ays_pd_description_text_shadow_y_offset']) ) : 2; 

                $description_text_shadow_z_offset = (isset($_POST['ays_pd_description_text_shadow_z_offset']) && ($_POST['ays_pd_description_text_shadow_z_offset']) != '' && ($_POST['ays_pd_description_text_shadow_z_offset']) != 0) ? esc_attr( intval($_POST['ays_pd_description_text_shadow_z_offset']) ) : 2;

                // Menu Styles Start
                //Menu Items
                $menu_items = isset($_POST['ays_pd_menu_items']) && $_POST['ays_pd_menu_items'] != '' ? sanitize_text_field( $_POST['ays_pd_menu_items'] ) : 'text-icon';

                // Enable Menu Items Mobile
                $enable_menu_items_mobile = isset($_POST['ays_pd_enable_menu_items_mobile']) && $_POST['ays_pd_enable_menu_items_mobile'] == 'on' ? 'on' : 'off';

                //Menu Items Mobile
                $menu_items_mobile = isset($_POST['ays_pd_menu_items_mobile']) && $_POST['ays_pd_menu_items_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_menu_items_mobile'] ) : 'icon';

                //Menu Position
                $menu_position = isset($_POST['ays_pd_menu_position']) && $_POST['ays_pd_menu_position'] != '' ? sanitize_text_field( $_POST['ays_pd_menu_position'] ) : 'left';

                // Enable Menu Position Mobile
                $enable_menu_position_mobile = isset($_POST['ays_pd_enable_menu_position_mobile']) && $_POST['ays_pd_enable_menu_position_mobile'] == 'on' ? 'on' : 'off';

                //Menu Position Mobile
                $menu_position_mobile = isset($_POST['ays_pd_menu_position_mobile']) && $_POST['ays_pd_menu_position_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_menu_position_mobile'] ) : 'top';

                //Menu Layout
                $menu_layout = isset($_POST['ays_pd_menu_layout']) && $_POST['ays_pd_menu_layout'] != '' ? sanitize_text_field( $_POST['ays_pd_menu_layout'] ) : 'grid';

                // Enable Menu Layout Mobile
                $enable_menu_layout_mobile = isset($_POST['ays_pd_enable_menu_layout_mobile']) && $_POST['ays_pd_enable_menu_layout_mobile'] == 'on' ? 'on' : 'off';

                //Menu Layout Mobile
                $menu_layout_mobile = isset($_POST['ays_pd_menu_layout_mobile']) && $_POST['ays_pd_menu_layout_mobile'] != '' ? sanitize_text_field( $_POST['ays_pd_menu_layout_mobile'] ) : 'grid';
                // Menu Styles End

                // Set options
                $meta_options['learned_points'] = $learned_points;
                $meta_options['right_points'] = $right_points;
                $meta_options['wrong_points'] = $wrong_points;
                $meta_options['enable_full_screen_mode'] = $enable_full_screen_mode;
                $meta_options['enable_full_screen_mode_mobile'] = $enable_full_screen_mode_mobile;
                $meta_options['enable_add_words_from_front'] = $enable_add_words_from_front;
                $meta_options['enable_add_image_from_front'] = $enable_add_image_from_front;
                $meta_options['enable_add_audio_from_front'] = $enable_add_audio_from_front;
                $meta_options['enable_add_image_to_games'] = $enable_add_image_to_games;
                $meta_options['enable_add_audio_to_games'] = $enable_add_audio_to_games;
                $meta_options['show_games'] = $show_games;
                $meta_options['show_game_find_the_word'] = $show_game_find_the_word;
                $meta_options['show_game_find_the_translation'] = $show_game_find_the_translation;
                $meta_options['show_game_matching_words'] = $show_game_matching_words;
                $meta_options['show_game_write_the_translation'] = $show_game_write_the_translation;
                $meta_options['show_correct_answer'] = $show_correct_answer;
                $meta_options['show_correct_answer_mobile'] = $show_correct_answer_mobile;
                $meta_options['show_next_button'] = $show_next_button;
                $meta_options['show_next_button_mobile'] = $show_next_button_mobile;
                $meta_options['games_animation_effect'] = $games_animation_effect;
                $meta_options['enable_games_animation_effect_mobile'] = $enable_games_animation_effect_mobile;
                $meta_options['games_animation_effect_mobile'] = $games_animation_effect_mobile;
                $meta_options['bg_color'] = $bg_color;
                $meta_options['enable_bg_color_mobile'] = $enable_bg_color_mobile;
                $meta_options['bg_color_mobile'] = $bg_color_mobile;
                $meta_options['main_color'] = $main_color;
                $meta_options['enable_main_color_mobile'] = $enable_main_color_mobile;
                $meta_options['main_color_mobile'] = $main_color_mobile;
                $meta_options['text_color'] = $text_color;
                $meta_options['enable_text_color_mobile'] = $enable_text_color_mobile;
                $meta_options['text_color_mobile'] = $text_color_mobile;
                $meta_options['container_border_color'] = $container_border_color;
                $meta_options['enable_container_border_color_mobile'] = $enable_container_border_color_mobile;
                $meta_options['container_border_color_mobile'] = $container_border_color_mobile;
                $meta_options['answer_border_color'] = $answer_border_color;
                $meta_options['answer_bg_color'] = $answer_bg_color;
                $meta_options['button_text_color'] = $button_text_color;
                $meta_options['button_font_size'] = $button_font_size;
                $meta_options['button_font_size_for_mobile'] = $button_font_size_for_mobile;
                $meta_options['buttons_left_right_padding'] = $buttons_left_right_padding;
                $meta_options['buttons_top_bottom_padding'] = $buttons_top_bottom_padding;
                $meta_options['buttons_border_radius'] = $buttons_border_radius;
                $meta_options['container_border_radius'] = $container_border_radius;
                $meta_options['container_border_radius_mobile'] = $container_border_radius_mobile;
                $meta_options['enable_container_border_radius_mobile'] = $enable_container_border_radius_mobile;
                $meta_options['container_border_width'] = $container_border_width;
                $meta_options['container_border_width_mobile'] = $container_border_width_mobile;
                $meta_options['enable_container_border_width_mobile'] = $enable_container_border_width_mobile;
                $meta_options['enable_container_box_shadow'] = $enable_container_box_shadow;
                $meta_options['container_box_shadow_color'] = $container_box_shadow_color;
                $meta_options['container_box_shadow_x_offset'] = $container_box_shadow_x_offset;
                $meta_options['container_box_shadow_y_offset'] = $container_box_shadow_y_offset;
                $meta_options['container_box_shadow_z_offset'] = $container_box_shadow_z_offset;
                $meta_options['enable_answer_box_shadow'] = $enable_answer_box_shadow;
                $meta_options['answer_box_shadow_color'] = $answer_box_shadow_color;
                $meta_options['answer_box_shadow_x_offset'] = $answer_box_shadow_x_offset;
                $meta_options['answer_box_shadow_y_offset'] = $answer_box_shadow_y_offset;
                $meta_options['answer_box_shadow_z_offset'] = $answer_box_shadow_z_offset;
                $meta_options['answer_border_width'] = $answer_border_width;
                $meta_options['enable_answer_border_width_mobile'] = $enable_answer_border_width_mobile;
                $meta_options['answer_border_width_mobile'] = $answer_border_width_mobile;
                $meta_options['container_border_style'] = $container_border_style;
                $meta_options['enable_container_border_style_mobile'] = $enable_container_border_style_mobile;
                $meta_options['container_border_style_mobile'] = $container_border_style_mobile;
                $meta_options['answer_border_style'] = $answer_border_style;
                $meta_options['question_font_size'] = $question_font_size;
                $meta_options['question_font_size_for_mobile'] = $question_font_size_for_mobile;
                $meta_options['answer_font_size'] = $answer_font_size;
                $meta_options['answer_font_size_for_mobile'] = $answer_font_size_for_mobile;
                $meta_options['custom_class'] = $custom_class;
                $meta_options['custom_css'] = $custom_css;
                $meta_options['title'] = $ays_pd_title;
                $meta_options['show_title'] = $ays_show_pd_title;
                $meta_options['show_title_mobile'] = $ays_show_pd_title_mobile;
                $meta_options['enable_title_text_shadow'] = $enable_title_text_shadow;
                $meta_options['title_text_shadow_color'] = $title_text_shadow_color;
                $meta_options['title_text_shadow_x_offset'] = $title_text_shadow_x_offset;
                $meta_options['title_text_shadow_y_offset'] = $title_text_shadow_y_offset;
                $meta_options['title_text_shadow_z_offset'] = $title_text_shadow_z_offset;
                $meta_options['title_alignment'] = $pd_title_alignment;
                $meta_options['title_alignment_mobile'] = $pd_title_alignment_mobile;
                $meta_options['enable_title_alignment_mobile'] = $enable_pd_title_alignment_mobile;
                $meta_options['answer_view'] = $pd_answer_view;
                $meta_options['enable_answer_view_mobile'] = $enable_pd_answer_view_mobile;
                $meta_options['answer_view_mobile'] = $pd_answer_view_mobile;
                $meta_options['pd_description'] = $pd_description;
                $meta_options['show_description'] = $show_pd_description;
                $meta_options['show_description_mobile'] = $show_pd_description_mobile;
                $meta_options['pd_add_logo'] = $pd_logo;
                $meta_options['pd_logo_pos'] = $pd_logo_position;
                $meta_options['pd_logo_url'] = $pd_logo_image_url;
                $meta_options['pd_logo_title'] = $pd_logo_title;
                $meta_options['pd_enable_logo_url'] = $pd_logo_image_url_check;
                $meta_options['pd_logo_url_new_tab'] = $pd_logo_url_new_tab;
                $meta_options['description_font_size'] = $description_font_size;
                $meta_options['description_font_size_for_mobile'] = $description_font_size_for_mobile;
                $meta_options['title_font_size'] = $title_font_size;
                $meta_options['title_font_size_for_mobile'] = $title_font_size_for_mobile;
                $meta_options['desc_alignment'] = $pd_desc_alignment;
                $meta_options['enable_desc_alignment_mobile'] = $enable_pd_desc_alignment_mobile;
                $meta_options['desc_alignment_mobile'] = $pd_desc_alignment_mobile;
                $meta_options['enable_description_text_shadow'] = $enable_description_text_shadow;
                $meta_options['enable_answer_border'] = $enable_answer_border;
                $meta_options['description_text_shadow_color'] = $description_text_shadow_color;
                $meta_options['description_text_shadow_x_offset'] = $description_text_shadow_x_offset;
                $meta_options['description_text_shadow_y_offset'] = $description_text_shadow_y_offset;
                $meta_options['description_text_shadow_z_offset'] = $description_text_shadow_z_offset;
                $meta_options['menu_items'] = $menu_items;
                $meta_options['enable_menu_items_mobile'] = $enable_menu_items_mobile;
                $meta_options['menu_items_mobile'] = $menu_items_mobile;
                $meta_options['menu_position'] = $menu_position;
                $meta_options['enable_menu_position_mobile'] = $enable_menu_position_mobile;
                $meta_options['menu_position_mobile'] = $menu_position_mobile;
                $meta_options['menu_layout'] = $menu_layout;
                $meta_options['enable_menu_layout_mobile'] = $enable_menu_layout_mobile;
                $meta_options['menu_layout_mobile'] = $menu_layout_mobile;
                $meta_options['change_group_name'] = $change_group_name;
                $meta_options['change_word_name'] = $change_word_name;
                $meta_options['change_translation_name'] = $change_translation_name;

                $global_settings = $this->ays_pd_get_setting();
                if(!$global_settings){
                    $global_settings = array();
                }
                $added_values = array_diff_key($meta_options , $global_settings);
                if(!$global_settings){
                    $result = $this->ays_pd_add_setting($meta_options,"", "");
                }
                else if(!empty($added_values)){
                    $result = $this->ays_pd_add_setting($added_values,"", "");
                    $result = $this->ays_pd_update_setting($meta_options ,"", "");
                }
                else{
                    $result = $this->ays_pd_update_setting($meta_options ,"", "");
                }
                
            }
        }

        // Add global settings
        public static function ays_pd_add_setting($metas , $note = "", $options = ""){
            global $wpdb;
            $dictionary_global_settings = esc_sql( $wpdb->prefix . PERSONAL_DICTIONARY_DB_PREFIX . "globsettings" );
            if(isset($metas) && !empty($metas)){
                foreach($metas as $m_key => $m_value){
                    $result = $wpdb->insert(
                        $dictionary_global_settings,
                        array(
                            'meta_key'   => $m_key,
                            'meta_value' => $m_value,
                            'note'       => "",
                            'options'    => ""
                        ),
                        array( '%s', '%s', '%s', '%s' )
                    );

                }
                if($result >= 0){
                    return true;
                }
            }
            return false;
        }

        // Update global settings
        public static function ays_pd_update_setting($metas, $notes = "", $options = ""){
            global $wpdb;
            $dictionary_global_settings = esc_sql( $wpdb->prefix . PERSONAL_DICTIONARY_DB_PREFIX . "globsettings" );
            if(isset($metas) && !empty($metas)){
                foreach($metas as $m_key => $m_value){
                    $result = $wpdb->update(
                        $dictionary_global_settings,
                        array(
                            'meta_value' => $m_value,
                            'note'       => $notes,
                            'options'    => $options
                        ),
                        array(
                            'meta_key' => $m_key
                        ),
                        array(
                            '%s', '%s', '%s'
                        ),
                        array(
                            '%s'
                        )
                    );

                }
                if($result >= 0){
                    return true;
                }
            }
            return false;
        }

        // Get global settings
        public static function ays_pd_get_setting(){
            global $wpdb;
            $settings_table = $wpdb->prefix . PERSONAL_DICTIONARY_DB_PREFIX . "globsettings";
            $sql = "SELECT * FROM ".$settings_table;
            $result = $wpdb->get_results($sql ,"ARRAY_A");
            $values = array();
            if(isset($result) && !empty($result)){
                foreach($result as $key => $value){
                    $values[$value['meta_key']] = $value["meta_value"];
                }
                return $values;
            }
            return false;
        }
}
?>