<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Personal_Dictionary
 * @subpackage Personal_Dictionary/includes
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Personal_Dictionary
 * @subpackage Personal_Dictionary/includes
 * @author     AYS Pro LLC <info@ays-pro.com>
 */
class Personal_Dictionary_Data {

    public static function get_pd_validated_data_from_array($pd){
        global $wpdb;
        // Array for survey validated options
        $settings = array();
        $name_prefix = 'pd_';
        $options = array();
        foreach ($pd as $key => $value) {
            $options[$value['meta_key']] = $value['meta_value'];
        }

        // PD options
        if( isset( $pd->options ) && $pd->options != '' ){
            $options = json_decode( $pd->options, true );
        }

        $settings[ $name_prefix . 'learned_points' ] = (isset($options['learned_points']) && $options['learned_points' ] != '') ? abs( floatval( sanitize_text_field( $options['learned_points' ] ) ) ) : 10;

        $settings[ $name_prefix . 'right_points' ] = (isset($options['right_points' ]) && $options['right_points' ] != '') ? abs( floatval( sanitize_text_field( $options['right_points' ] ) ) ) : 1; 
 
        $settings[ $name_prefix . 'wrong_points' ] = (isset($options['wrong_points' ]) && $options['wrong_points' ] != '') ? abs( floatval( sanitize_text_field( $options['wrong_points' ] ) ) ) : 0.25;

        $settings[ $name_prefix . 'enable_full_screen_mode' ] = (isset($options['enable_full_screen_mode' ]) && $options['enable_full_screen_mode' ] == 'on') ? true : false;       

        $options['enable_full_screen_mode_mobile'] = (isset($options['enable_full_screen_mode_mobile']) && $options['enable_full_screen_mode_mobile'] != '') ? esc_attr($options['enable_full_screen_mode_mobile']) : 'on';
        
        $settings[$name_prefix .'enable_full_screen_mode_mobile'] = (isset($options['enable_full_screen_mode_mobile']) && $options['enable_full_screen_mode_mobile'] == 'on') ? true : false;

        $settings[ $name_prefix . 'enable_add_words_from_front' ] = (isset($options['enable_add_words_from_front' ]) && $options['enable_add_words_from_front' ] == 'on') ? 'on' : 'off';

        $settings[ $name_prefix . 'enable_add_image_from_front' ] = (isset($options['enable_add_image_from_front' ]) && $options['enable_add_image_from_front' ] == 'on') ? 'on' : 'off';

        $settings[ $name_prefix . 'enable_add_audio_from_front' ] = (isset($options['enable_add_audio_from_front' ]) && $options['enable_add_audio_from_front' ] == 'on') ? 'on' : 'off';

        $settings[ $name_prefix . 'enable_add_image_to_games' ] = (isset($options['enable_add_image_to_games' ]) && $options['enable_add_image_to_games' ] == 'on') ? 'on' : 'off';

        $settings[ $name_prefix . 'enable_add_audio_to_games' ] = (isset($options['enable_add_audio_to_games' ]) && $options['enable_add_audio_to_games' ] == 'on') ? 'on' : 'off';

        $settings[ $name_prefix . 'show_games' ] = (isset($options['show_games' ]) && $options['show_games' ] == 'off') ? 'off' : 'on';

        $settings[ $name_prefix . 'show_game_find_the_word' ] = (isset($options['show_game_find_the_word' ]) && $options['show_game_find_the_word' ] == 'off') ? 'off' : 'on';
        
        $settings[ $name_prefix . 'show_game_find_the_translation' ] = (isset($options['show_game_find_the_translation' ]) && $options['show_game_find_the_translation' ] == 'off') ? 'off' : 'on';

        $settings[ $name_prefix . 'show_game_matching_words' ] = (isset($options['show_game_matching_words' ]) && $options['show_game_matching_words' ] == 'off') ? 'off' : 'on';

        $settings[ $name_prefix . 'show_game_write_the_translation' ] = (isset($options['show_game_write_the_translation' ]) && $options['show_game_write_the_translation' ] == 'off') ? 'off' : 'on';

        $settings[ $name_prefix . 'show_correct_answer' ] = (isset($options['show_correct_answer' ]) && $options['show_correct_answer' ] == 'on') ? true : false;
        
        $settings[ $name_prefix . 'show_correct_answer_mobile' ] = (isset($options['show_correct_answer_mobile' ]) && $options['show_correct_answer_mobile' ] == 'on') ? true : false;

        $settings[ $name_prefix . 'show_next_button' ] = (isset($options['show_next_button' ]) && $options['show_next_button' ] == 'off') ? false : true;
        
        $settings[ $name_prefix . 'show_next_button_mobile' ] = (isset($options['show_next_button_mobile' ]) && $options['show_next_button_mobile' ] == 'off') ? false : true;
        
        // Animation effect
        $settings[ $name_prefix . 'games_animation_effect' ] = (isset($options['games_animation_effect' ]) && $options['games_animation_effect' ] != '') ?  sanitize_text_field( $options[ 'games_animation_effect' ] ) : 'none';

        // Enable Animation effect Mobile
        $settings[$name_prefix .'enable_games_animation_effect_mobile'] = (isset($options['enable_games_animation_effect_mobile']) && $options['enable_games_animation_effect_mobile'] == 'off') ? false : true;

        // Animation effect Mobile
        if ($settings[$name_prefix .'enable_games_animation_effect_mobile']) {
           $settings[ $name_prefix . 'games_animation_effect_mobile' ] = (isset($options['games_animation_effect_mobile' ]) && $options['games_animation_effect_mobile' ] != '') ?  sanitize_text_field( $options[ 'games_animation_effect_mobile' ] ) : 'none';
        } else {
           $settings[ $name_prefix . 'games_animation_effect_mobile' ] = $settings[ $name_prefix . 'games_animation_effect' ];
        }

        // BG Color
        $settings[ $name_prefix . 'bg_color' ] = (isset($options['bg_color' ]) && $options['bg_color' ] != '') ?  sanitize_text_field( $options[ 'bg_color' ] )  : '#ffffff';

        // Enable BG Color Mobile
        $settings[$name_prefix .'enable_bg_color_mobile'] = (isset($options['enable_bg_color_mobile']) && $options['enable_bg_color_mobile'] == 'off') ? false : true;

        // BG Color Mobile
        if ($settings[$name_prefix .'enable_bg_color_mobile']) {
            $settings[ $name_prefix . 'bg_color_mobile' ] = (isset($options['bg_color_mobile' ]) && $options['bg_color_mobile' ] != '') ?  sanitize_text_field( $options[ 'bg_color_mobile' ] ) : '#ffffff';
        } else {
            $settings[ $name_prefix . 'bg_color_mobile' ] = $settings[ $name_prefix . 'bg_color' ];
        }

        // Main Color
        $settings[ $name_prefix . 'main_color' ] = (isset($options['main_color' ]) && $options['main_color' ] != '') ?  sanitize_text_field( $options[ 'main_color' ] )  : '#1A7EFB';
        // Enable Main Color Mobile
        $settings[$name_prefix .'enable_main_color_mobile'] = (isset($options['enable_main_color_mobile']) && $options['enable_main_color_mobile'] == 'off') ? false : true;
        // Main Color Mobile
        if ($settings[$name_prefix .'enable_main_color_mobile']) {
            $settings[ $name_prefix . 'main_color_mobile' ] = (isset($options['main_color_mobile' ]) && $options['main_color_mobile' ] != '') ?  sanitize_text_field( $options[ 'main_color_mobile' ] ) : '#1A7EFB';
        } else {
            $settings[ $name_prefix . 'main_color_mobile' ] = $settings[ $name_prefix . 'main_color' ];
        }

       // Text Color        
       $settings[ $name_prefix . 'text_color' ] = (isset($options['text_color' ]) && $options['text_color' ] != '') ?  sanitize_text_field( $options[ 'text_color' ] ) : '#000';

       // Enable Text Color Mobile
       $settings[$name_prefix .'enable_text_color_mobile'] = (isset($options['enable_text_color_mobile']) && $options['enable_text_color_mobile'] == 'off') ? false : true;

       // Text Color Mobile
       if ($settings[$name_prefix .'enable_text_color_mobile']) {
           $settings[ $name_prefix . 'text_color_mobile' ] = (isset($options['text_color_mobile' ]) && $options['text_color_mobile' ] != '') ?  sanitize_text_field( $options[ 'text_color_mobile' ] ) : '#000';
       } else {
           $settings[ $name_prefix . 'text_color_mobile' ] = $settings[ $name_prefix . 'text_color' ];
       }

       // Container Border Color        
       $settings[ $name_prefix . 'container_border_color' ] = (isset($options['container_border_color' ]) && $options['container_border_color' ] != '') ?  sanitize_text_field( $options[ 'container_border_color' ] ) : '#ccc';

       // Enable Container Border Color Mobile
       $settings[$name_prefix .'enable_container_border_color_mobile'] = (isset($options['enable_container_border_color_mobile']) && $options['enable_container_border_color_mobile'] == 'off') ? false : true;

       // Container Border Color Mobile
       if ($settings[$name_prefix .'enable_container_border_color_mobile']) {
           $settings[ $name_prefix . 'container_border_color_mobile' ] = (isset($options['text_color_mobile' ]) && $options['container_border_color_mobile' ] != '') ?  sanitize_text_field( $options[ 'container_border_color_mobile' ] ) : $settings[ $name_prefix . 'container_border_color' ];
       } else {
           $settings[ $name_prefix . 'container_border_color_mobile' ] = $settings[ $name_prefix . 'container_border_color' ];
       }

        $settings[ $name_prefix . 'button_text_color' ] = (isset($options['button_text_color' ]) && $options['button_text_color' ] != '') ?  sanitize_text_field( $options[ 'button_text_color' ] ) : '#ffffff';

        $settings[ $name_prefix . 'button_font_size' ] = (isset($options['button_font_size' ]) && $options['button_font_size' ] != '') ?  sanitize_text_field( $options[ 'button_font_size' ] ) : 14;

        $settings[ $name_prefix . 'button_font_size_for_mobile' ] = (isset($options['button_font_size_for_mobile' ]) && $options['button_font_size_for_mobile' ] != '') ?  absint( sanitize_text_field( $options[ 'button_font_size_for_mobile' ] ) ) : 14;

        $settings[ $name_prefix . 'buttons_left_right_padding' ] = (isset($options['buttons_left_right_padding' ]) && $options['buttons_left_right_padding' ] != '') ?  sanitize_text_field( $options[ 'buttons_left_right_padding' ] ) : 12;
     
        $settings[ $name_prefix . 'buttons_top_bottom_padding' ] = (isset($options['buttons_top_bottom_padding' ]) && $options['buttons_top_bottom_padding' ] != '') ?  sanitize_text_field( $options[ 'buttons_top_bottom_padding' ] ) : 7;

        $settings[ $name_prefix . 'buttons_border_radius' ] = (isset($options['buttons_border_radius' ]) && $options['buttons_border_radius' ] != '') ?  sanitize_text_field( $options[ 'buttons_border_radius' ] ) : 6;

        $settings[ $name_prefix . 'container_border_radius' ] = (isset($options['container_border_radius' ]) && $options['container_border_radius' ] != '') ?  sanitize_text_field( $options[ 'container_border_radius' ] ) : 6;
        
        // Enable Conatiner border radius Mobile
        $settings[$name_prefix .'enable_container_border_radius_mobile'] = (isset($options['enable_container_border_radius_mobile']) && $options['enable_container_border_radius_mobile'] == 'off') ? false : true;

        // Conatiner border radius Mobile
        if ($settings[$name_prefix .'enable_container_border_radius_mobile']) {
            $settings[ $name_prefix . 'container_border_radius_mobile' ] = (isset($options['container_border_radius_mobile' ]) && $options['container_border_radius_mobile' ] != '') ?  sanitize_text_field( $options[ 'container_border_radius_mobile' ] ) : 6;
        } else {
            $settings[ $name_prefix . 'container_border_radius_mobile' ] = $settings[ $name_prefix . 'container_border_radius' ];
        }
        // Conatiner border width
        $settings[ $name_prefix . 'container_border_width' ] = (isset($options['container_border_width' ]) && $options['container_border_width' ] != '') ?  sanitize_text_field( $options[ 'container_border_width' ] ) : 0;
       
        // Enable Conatiner border width Mobile
        $settings[$name_prefix .'enable_container_border_width_mobile'] = (isset($options['enable_container_border_width_mobile']) && $options['enable_container_border_width_mobile'] == 'off') ? false : true;

        // Conatiner border width Mobile
        if ($settings[$name_prefix .'enable_container_border_width_mobile']) {
            $settings[ $name_prefix . 'container_border_width_mobile' ] = (isset($options['container_border_width_mobile' ]) && $options['container_border_width_mobile' ] != '') ?  sanitize_text_field( $options[ 'container_border_width_mobile' ] ) : $settings[ $name_prefix . 'container_border_width' ];
        } else {
            $settings[ $name_prefix . 'container_border_width_mobile' ] = $settings[ $name_prefix . 'container_border_width' ];
        }

       // Answer border width
       $settings[ $name_prefix . 'answer_border_width' ] = (isset($options['answer_border_width' ]) && $options['answer_border_width' ] != '') ?  sanitize_text_field( $options[ 'answer_border_width' ] ) : 1;

       // Enable Answer border width Mobile
       $settings[$name_prefix .'enable_answer_border_width_mobile'] = (isset($options['enable_answer_border_width_mobile']) && $options['enable_answer_border_width_mobile'] == 'off') ? false : true;

       // Answer border width Mobile
       if ($settings[$name_prefix .'enable_answer_border_width_mobile']) {
           $settings[ $name_prefix . 'answer_border_width_mobile' ] = (isset($options['answer_border_width_mobile' ]) && $options['answer_border_width_mobile' ] != '') ?  sanitize_text_field( $options[ 'answer_border_width_mobile' ] ) : $settings[ $name_prefix . 'answer_border_width' ];
       } else {
           $settings[ $name_prefix . 'answer_border_width_mobile' ] = $settings[ $name_prefix . 'answer_border_width' ];
       }

        $settings[ $name_prefix . 'answer_border_color' ] = (isset($options['answer_border_color' ]) && $options['answer_border_color' ] != '') ?  sanitize_text_field( $options[ 'answer_border_color' ] ) : 'rgba(148,148,148,0.85)';

        $settings[ $name_prefix . 'answer_bg_color' ] = (isset($options['answer_bg_color' ]) && $options['answer_bg_color' ] != '') ?  sanitize_text_field( $options[ 'answer_bg_color' ] ) : '#ffffff';

        $settings[ $name_prefix . 'answer_border_style' ] = (isset($options['answer_border_style' ]) && $options['answer_border_style' ] != '') ?  sanitize_text_field( $options[ 'answer_border_style' ] ) : 'solid';
        
        // Conatiner border style
        $settings[ $name_prefix . 'container_border_style' ] = (isset($options['container_border_style' ]) && $options['container_border_style' ] != '') ?  sanitize_text_field( $options[ 'container_border_style' ] ) : 'solid';
        
        // Enable Conatiner border width Mobile
        $settings[$name_prefix .'enable_container_border_style_mobile'] = (isset($options['enable_container_border_style_mobile']) && $options['enable_container_border_style_mobile'] == 'off') ? false : true;

        // Conatiner border style Mobile
        if ($settings[$name_prefix .'enable_container_border_style_mobile']) {
            $settings[ $name_prefix . 'container_border_style_mobile' ] = (isset($options['container_border_style_mobile' ]) && $options['container_border_style_mobile' ] != '') ?  sanitize_text_field( $options[ 'container_border_style_mobile' ] ) : $settings[ $name_prefix . 'container_border_style' ];
        } else {
            $settings[ $name_prefix . 'container_border_style_mobile' ] = $settings[ $name_prefix . 'container_border_style' ];
        }

        $options['enable_container_box_shadow'] = (isset($options['enable_container_box_shadow']) && $options['enable_container_box_shadow'] != '') ? esc_attr($options['enable_container_box_shadow']) : 'on';
        
        $settings[$name_prefix .'enable_container_box_shadow'] = (isset($options['enable_container_box_shadow']) && $options['enable_container_box_shadow'] == 'on') ? true : false;

        $settings[$name_prefix .'container_box_shadow_color'] = (isset($options['container_box_shadow_color']) && $options['container_box_shadow_color'] != '') ? esc_attr($options['container_box_shadow_color']) : '#153e7124';

        $settings[$name_prefix .'container_box_shadow_x_offset'] = (isset($options['container_box_shadow_x_offset']) && ( $options['container_box_shadow_x_offset'] ) != '' && ( $options['container_box_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['container_box_shadow_x_offset'] ) ) : 0;

        $settings[$name_prefix .'container_box_shadow_y_offset'] = (isset($options['container_box_shadow_y_offset']) && ( $options['container_box_shadow_y_offset'] ) != '' && ( $options['container_box_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['container_box_shadow_y_offset'] ) ) : 4;

        $settings[$name_prefix .'container_box_shadow_z_offset'] = (isset($options['container_box_shadow_z_offset']) && ( $options['container_box_shadow_z_offset'] ) != '' && ( $options['container_box_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['container_box_shadow_z_offset'] ) ) : 9;
   
        $options['enable_answer_box_shadow'] = (isset($options['enable_answer_box_shadow']) && $options['enable_answer_box_shadow'] != '') ? esc_attr($options['enable_answer_box_shadow']) : 'off';
        
        $settings[$name_prefix .'enable_answer_box_shadow'] = (isset($options['enable_answer_box_shadow']) && $options['enable_answer_box_shadow'] == 'on') ? true : false; 
         
        $settings[$name_prefix .'answer_box_shadow_color'] = (isset($options['answer_box_shadow_color']) && $options['answer_box_shadow_color'] != '') ? esc_attr($options['answer_box_shadow_color']) : '#153e7124';
       
        $settings[$name_prefix .'answer_box_shadow_x_offset'] = (isset($options['answer_box_shadow_x_offset']) && ( $options['answer_box_shadow_x_offset'] ) != '' && ( $options['answer_box_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['answer_box_shadow_x_offset'] ) ) : 0;
        
        $settings[$name_prefix .'answer_box_shadow_y_offset'] = (isset($options['answer_box_shadow_y_offset']) && ( $options['answer_box_shadow_y_offset'] ) != '' && ( $options['answer_box_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['answer_box_shadow_y_offset'] ) ) : 4;

        $settings[$name_prefix .'answer_box_shadow_z_offset'] = (isset($options['answer_box_shadow_z_offset']) && ( $options['answer_box_shadow_z_offset'] ) != '' && ( $options['answer_box_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['answer_box_shadow_z_offset'] ) ) : 9;
 
        $settings[ $name_prefix . 'question_font_size' ] = (isset($options['question_font_size' ]) && $options['question_font_size' ] != '') ?  absint( sanitize_text_field( $options[ 'question_font_size' ] ) ) : 16;

        $settings[ $name_prefix . 'question_font_size_for_mobile' ] = (isset($options['question_font_size_for_mobile' ]) && $options['question_font_size_for_mobile' ] != '') ?  absint( sanitize_text_field( $options[ 'question_font_size_for_mobile' ] ) ) : 16;

        $settings[ $name_prefix . 'answer_font_size' ] = (isset($options['answer_font_size' ]) && $options['answer_font_size' ] != '') ?  absint( sanitize_text_field( $options[ 'answer_font_size' ] ) ) : 15;

        $settings[ $name_prefix . 'answer_font_size_for_mobile' ] = (isset($options['answer_font_size_for_mobile' ]) && $options['answer_font_size_for_mobile' ] != '') ?  absint( sanitize_text_field( $options[ 'answer_font_size_for_mobile' ] ) ) : 15;

        $settings[ $name_prefix . 'custom_class' ] = (isset($options['custom_class' ]) && $options['custom_class' ] != '') ?  $options['custom_class']  : '';

        $settings[ $name_prefix . 'change_group_name' ] = (isset($options['change_group_name' ]) && $options['change_group_name' ] != '') ?  $options['change_group_name']  : 'Group';

        $settings[ $name_prefix . 'change_word_name' ] = (isset($options['change_word_name' ]) && $options['change_word_name' ] != '') ?  $options['change_word_name']  : 'Word';

        $settings[ $name_prefix . 'change_translation_name' ] = (isset($options['change_translation_name' ]) && $options['change_translation_name' ] != '') ?  $options['change_translation_name']  : 'Translation';

        // Custom CSS
         $settings[ $name_prefix . 'custom_css' ] = (isset($options['custom_css' ]) && $options['custom_css' ] != '') ? stripslashes( htmlspecialchars_decode( $options['custom_css'] ) ) : '';

         // Pd Title
        $settings[ $name_prefix . 'title' ] = (isset($options['title' ]) && $options['title' ] != '') ? stripslashes( htmlspecialchars_decode( $options['title'] ) ) : '';

        // Show PD Title
        $settings[$name_prefix .'show_title'] = (isset($options['show_title']) && $options['show_title'] == 'on') ? 'on' : 'off';

        // Show PD Title mobile
        $settings[$name_prefix .'show_title_mobile'] = (isset($options['show_title_mobile']) && $options['show_title_mobile'] == 'on') ? 'on' : 'off';

        // Title text shadow
        $settings[$name_prefix .'enable_title_text_shadow'] = ( isset($options['enable_title_text_shadow']) && $options['enable_title_text_shadow'] != '') ? esc_attr($options['enable_title_text_shadow']) : 'off';
        $settings[$name_prefix .'enable_title_text_shadow'] = (isset($options['enable_title_text_shadow']) && $options['enable_title_text_shadow'] == 'on') ? true : false;

        $settings[$name_prefix .'title_text_shadow_color'] = (isset($options['title_text_shadow_color']) && $options['title_text_shadow_color'] != '') ? esc_attr($options['title_text_shadow_color']) : '#333';

        // Title Text Shadow X offset
        $settings[$name_prefix .'title_text_shadow_x_offset'] = (isset($options['title_text_shadow_x_offset']) && ( $options['title_text_shadow_x_offset'] ) != '' && ( $options['title_text_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['title_text_shadow_x_offset'] ) ) : 2;

        // Title Text Shadow Y offset
        $settings[$name_prefix .'title_text_shadow_y_offset'] = (isset($options['title_text_shadow_y_offset']) && ( $options['title_text_shadow_y_offset'] ) != '' && ( $options['title_text_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['title_text_shadow_y_offset'] ) ) : 2;

        // Title Text Shadow Z offset
        $settings[$name_prefix .'title_text_shadow_z_offset'] = (isset($options['title_text_shadow_z_offset']) && ( $options['title_text_shadow_z_offset'] ) != '' && ( $options['title_text_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['title_text_shadow_z_offset'] ) ) : 2;

        // Title Alignment
        $settings[$name_prefix .'title_alignment'] = (isset($options['title_alignment']) && ( $options['title_alignment'] ) != '' ) ? sanitize_text_field(  $options['title_alignment'] ) : "left";
        
        // Enable Title Alignment Mobile
        $settings[$name_prefix .'enable_title_alignment_mobile'] = (isset($options['enable_title_alignment_mobile']) && $options['enable_title_alignment_mobile'] == 'off') ? false : true;

        // Title Alignment Mobile
        if ($settings[$name_prefix .'enable_title_alignment_mobile']) {
            $settings[ $name_prefix . 'title_alignment_mobile' ] = (isset($options['title_alignment_mobile' ]) && $options['title_alignment_mobile' ] != '') ?  sanitize_text_field( $options[ 'title_alignment_mobile' ] ) : $settings[ $name_prefix . 'title_alignment' ];
        } else {
            $settings[ $name_prefix . 'title_alignment_mobile' ] = $settings[ $name_prefix . 'title_alignment' ];
        }

        // Answer View
        $settings[$name_prefix .'answer_view'] = (isset($options['answer_view']) && ( $options['answer_view'] ) != '' ) ? sanitize_text_field(  $options['answer_view'] ) : "grid";
        
        // Enable Answer View Mobile
        $settings[$name_prefix .'enable_answer_view_mobile'] = (isset($options['enable_answer_view_mobile']) && $options['enable_answer_view_mobile'] == 'off') ? false : true;

        // Answer View Mobile
        if ( $settings[$name_prefix .'enable_answer_view_mobile'] ) {
            $settings[ $name_prefix . 'answer_view_mobile' ] = (isset($options['answer_view_mobile' ]) && $options['answer_view_mobile' ] != '') ?  sanitize_text_field( $options[ 'answer_view_mobile' ] ) : 'grid';
        } else {
            $settings[ $name_prefix . 'answer_view_mobile' ] = $settings[ $name_prefix . 'answer_view' ];
        }

        // PD Description
        $settings[$name_prefix .'description'] = (isset($options['pd_description' ]) && $options['pd_description' ] != '') ? stripslashes( htmlspecialchars_decode( $options['pd_description'] ) ) : '';

        // Add logo
        $settings[$name_prefix .'add_logo'] = isset($options[ 'pd_add_logo' ]) && $options[ 'pd_add_logo' ] != "" ? stripslashes ( sanitize_text_field( $options[ 'pd_add_logo' ] ) ) : "";

        // Logo url
        $settings[$name_prefix .'logo_image_url']  = (isset($options[ 'pd_logo_url' ]) &&  $options[ 'pd_logo_url' ] != '') ? esc_attr( $options[ 'pd_logo_url' ] ) : '';

        // Logo title
        $settings[$name_prefix .'logo_title']  = (isset($options[ 'pd_logo_title' ]) &&  $options[ 'pd_logo_title' ] != '') ? esc_attr( $options[ 'pd_logo_title' ] ) : '';

        $settings[$name_prefix .'enable_logo_url'] = (isset($options[ 'pd_enable_logo_url' ]) &&  $options[ 'pd_enable_logo_url' ] == 'on') ? true : false;

        // Open logo URL in new tab
        $settings[$name_prefix .'logo_url_new_tab'] = (isset($options['pd_logo_url_new_tab' ]) &&  $options['pd_logo_url_new_tab' ] == 'on') ? true : false;

        // Logo position
        $settings[$name_prefix .'logo_position'] = (isset( $options[ 'pd_logo_pos' ] ) && $options[ 'pd_logo_pos' ] != '') ? esc_attr( $options[ 'pd_logo_pos' ] ) : 'right';

        // Show PD Description
        $settings[$name_prefix .'show_description'] = isset($options['show_description']) && $options['show_description'] == 'on' ? 'on' : 'off';
        
        // Show PD Description mobile
        $settings[$name_prefix .'show_description_mobile'] = isset($options['show_description_mobile']) && $options['show_description_mobile'] == 'on' ? 'on' : 'off';

        // Description font size
        $settings[$name_prefix . 'description_font_size'] = (isset($options['description_font_size']) && $options['description_font_size'] != '') ?  absint( sanitize_text_field( $options['description_font_size'] ) ) : 18;
        $settings[ $name_prefix . 'description_font_size_for_mobile' ] = (isset($options['description_font_size_for_mobile' ]) && $options['description_font_size_for_mobile' ] != '') ?  absint( sanitize_text_field( $options[ 'description_font_size_for_mobile' ] ) ) : 18;

        // Title font size
        $settings[$name_prefix . 'title_font_size'] = (isset($options['title_font_size']) && $options['title_font_size'] != '') ?  absint( sanitize_text_field( $options['title_font_size'] ) ) : 30;
        $settings[ $name_prefix . 'title_font_size_for_mobile' ] = (isset($options['title_font_size_for_mobile' ]) && $options['title_font_size_for_mobile' ] != '') ?  absint( sanitize_text_field( $options[ 'title_font_size_for_mobile' ] ) ) : 30;

        // Description Alignment
        $settings[$name_prefix .'desc_alignment'] = (isset($options['desc_alignment']) && ( $options['desc_alignment'] ) != '' ) ? sanitize_text_field(  $options['desc_alignment'] ) : "left";
        
        // Enable Description Alignment Mobile
        $settings[$name_prefix .'enable_desc_alignment_mobile'] = (isset($options['enable_desc_alignment_mobile']) && $options['enable_desc_alignment_mobile'] == 'off') ? false : true;

        // Description Alignment Mobile
        if ($settings[$name_prefix .'enable_desc_alignment_mobile']) {
            $settings[ $name_prefix . 'desc_alignment_mobile' ] = (isset($options['desc_alignment_mobile' ]) && $options['desc_alignment_mobile' ] != '') ?  sanitize_text_field( $options[ 'desc_alignment_mobile' ] ) : $settings[ $name_prefix . 'desc_alignment' ];
        } else {
            $settings[ $name_prefix . 'desc_alignment_mobile' ] = $settings[ $name_prefix . 'desc_alignment' ];
        }

        // Description text shadow
        $settings[$name_prefix .'enable_description_text_shadow'] = ( isset($options['enable_description_text_shadow']) && $options['enable_description_text_shadow'] != '') ? esc_attr($options['enable_description_text_shadow']) : 'off';
        $settings[$name_prefix .'enable_description_text_shadow'] = (isset($options['enable_description_text_shadow']) && $options['enable_description_text_shadow'] == 'on') ? true : false;

        // Answer border
        $settings[$name_prefix .'enable_answer_border'] = isset($options['enable_answer_border'])  ? $options['enable_answer_border'] : 'on';

        $settings[$name_prefix .'description_text_shadow_color'] = (isset($options['description_text_shadow_color']) && $options['description_text_shadow_color'] != '') ? esc_attr($options['description_text_shadow_color']) : '#333';

        // Description Text Shadow X offset
        $settings[$name_prefix .'description_text_shadow_x_offset'] = (isset($options['description_text_shadow_x_offset']) && ( $options['description_text_shadow_x_offset'] ) != '' && ( $options['description_text_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['description_text_shadow_x_offset'] ) ) : 2;

        // Description Text Shadow Y offset
        $settings[$name_prefix .'description_text_shadow_y_offset'] = (isset($options['description_text_shadow_y_offset']) && ( $options['description_text_shadow_y_offset'] ) != '' && ( $options['description_text_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['description_text_shadow_y_offset'] ) ) : 2;

        // Description Text Shadow Z offset
        $settings[$name_prefix .'description_text_shadow_z_offset'] = (isset($options['description_text_shadow_z_offset']) && ( $options['description_text_shadow_z_offset'] ) != '' && ( $options['description_text_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['description_text_shadow_z_offset'] ) ) : 2;

        // Menu Styles Start
        // Menu Items
        $settings[ $name_prefix . 'menu_items' ] = (isset($options['menu_items' ]) && $options['menu_items' ] != '') ?  sanitize_text_field( $options[ 'menu_items' ] ) : 'text-icon';

        // Enable Menu Items Mobile
        $settings[$name_prefix .'enable_menu_items_mobile'] = (isset($options['enable_menu_items_mobile']) && $options['enable_menu_items_mobile'] == 'off') ? false : true;

        // Menu Items Mobile
        if ($settings[$name_prefix .'enable_menu_items_mobile']) {
            $settings[ $name_prefix . 'menu_items_mobile' ] = (isset($options['menu_items_mobile' ]) && $options['menu_items_mobile' ] != '') ?  sanitize_text_field( $options[ 'menu_items_mobile' ] ) : 'icon';
        } else {
            $settings[ $name_prefix . 'menu_items_mobile' ] = $settings[ $name_prefix . 'menu_items' ];
        }

        // Menu Position
        $settings[ $name_prefix . 'menu_position' ] = (isset($options['menu_position' ]) && $options['menu_position' ] != '') ?  sanitize_text_field( $options[ 'menu_position' ] ) : 'text-icon';

        // Enable Menu Position Mobile
        $settings[$name_prefix .'enable_menu_position_mobile'] = (isset($options['enable_menu_position_mobile']) && $options['enable_menu_position_mobile'] == 'off') ? false : true;

        // Menu Position Mobile
        if ($settings[$name_prefix .'enable_menu_position_mobile']) {
            $settings[ $name_prefix . 'menu_position_mobile' ] = (isset($options['menu_position_mobile' ]) && $options['menu_position_mobile' ] != '') ?  sanitize_text_field( $options[ 'menu_position_mobile' ] ) : 'icon';
        } else {
            $settings[ $name_prefix . 'menu_position_mobile' ] = $settings[ $name_prefix . 'menu_position' ];
        }

        // Menu Layout
        $settings[ $name_prefix . 'menu_layout' ] = (isset($options['menu_layout' ]) && $options['menu_layout' ] != '') ?  sanitize_text_field( $options[ 'menu_layout' ] ) : 'grid';

        // Enable Menu Layout Mobile
        $settings[$name_prefix .'enable_menu_layout_mobile'] = (isset($options['enable_menu_layout_mobile']) && $options['enable_menu_layout_mobile'] == 'on') ? true : false;

        // Menu Layout Layout
        if ($settings[$name_prefix .'enable_menu_layout_mobile']) {
            $settings[ $name_prefix . 'menu_layout_mobile' ] = (isset($options['menu_layout_mobile' ]) && $options['menu_layout_mobile' ] != '') ?  sanitize_text_field( $options[ 'menu_layout_mobile' ] ) : 'grid';
        } else {
            $settings[ $name_prefix . 'menu_layout_mobile' ] = $settings[ $name_prefix . 'menu_layout' ];
        }
        // Menu Styles End
        
        return $settings;
    }

    public static function get_pd_globsettings(){
        global $wpdb;
        $globsettings_table = $wpdb->prefix . PERSONAL_DICTIONARY_DB_PREFIX . 'globsettings';
        $sql = "SELECT *
                FROM {$globsettings_table}";
        $pd = $wpdb->get_results( $sql ,'ARRAY_A');
        return $pd;
    }

    public static function hex2rgba($color, $opacity = false){

        $default = 'rgb(0,0,0)';

        //Return default if no color provided
        if (empty($color))
            return $default;

        //Sanitize $color if "#" is provided
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }else{
            return $color;
        }

        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        //Convert hexadec to rgb
        $rgb = array_map('hexdec', $hex);

        //Check if opacity is set(rgba or rgb)
        if ($opacity) {
            if (abs($opacity) > 1)
                $opacity = 1.0;
            $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
        } else {
            $output = 'rgb(' . implode(",", $rgb) . ')';
        }

        //Return rgb(a) color string
        return $output;
    }

    public static function ays_autoembed( $content ) {
        global $wp_embed;

        if ( is_null( $content ) ) {
            return $content;
        }

        $content = stripslashes( wpautop( $content ) );
        $content = $wp_embed->autoembed( $content );
        if ( strpos( $content, '[embed]' ) !== false ) {
            $content = $wp_embed->run_shortcode( $content );
        }
        $content = do_shortcode( $content );
        return $content;
    }
    
}
