<?php 
class User_Vocabulary_List_Table extends WP_List_Table {
    private $plugin_name;

    /** Class constructor */

    public function __construct($plugin_name) {
        $this->plugin_name = $plugin_name;

        parent::__construct( array(
            'singular' => __( 'User Vocabulary', $this->plugin_name ), //singular name of the listed records
            'plural'   => __( 'Users Vocabulary', $this->plugin_name ), //plural name of the listed records
            'ajax'     => false //does this table support ajax?
        ) );
    }

    /**
     * Override of table nav to avoid breaking with bulk actions & according nonce field
     */
    public function display_tablenav( $which ) {
        ?>
        <div class="tablenav <?php echo esc_attr( $which ); ?>">

            <?php
            $this->extra_tablenav( $which );
            $this->pagination( $which );
            ?>
            <br class="clear" />
        </div>
        <?php
    }

    public function extra_tablenav( $which ){
        global $wpdb;

        $groups_table = $wpdb->prefix . 'ayspd_categories';
        $user_id = isset($_GET['user']) && $_GET['user'] != '' ? sanitize_text_field($_GET['user']) : '';
        
        $groups_sql = "SELECT id, name FROM ".$groups_table." WHERE user_id = " . $user_id . " ORDER BY name ASC";
        $groups = $wpdb->get_results($groups_sql);

        $group_id = null;
        if( isset( $_GET['filterbygroup'] )){
            $group_id = intval($_GET['filterbygroup']);
        }
        
        $groups_select = array();
        foreach($groups as $group){
            $selected = '';
            if($group_id === intval($group->id)){
                $selected = "selected";
            }

            $groups_select[$group->id]['name'] = $group->name;
            $groups_select[$group->id]['selected'] = $selected;
            $groups_select[$group->id]['id'] = $group->id;
        }
        ?>
        
        <div id="group-filter-div-wordslist" class="alignleft actions bulkactions">
            <select name="filterbygroup-<?php echo esc_attr( $which ); ?>" id="bulk-action-group-selector-<?php echo esc_attr( $which ); ?>">
                <option value=""><?php echo __('Select Group',$this->plugin_name)?></option>
                <?php
                    foreach($groups_select as $key => $group){
                        echo "<option ".$group['selected']." value='".$group['id']."'>".$group['name']."</option>";
                    }
                ?>
            </select>
            <input type="button" id="doaction-<?php echo esc_attr( $which ); ?>" class="ays-pd-all-filter-button-<?php echo esc_attr( $which ); ?> button" value="<?php echo __( "Filter", $this->plugin_name ); ?>">
            <a style="margin: 0px 8px 0 0;" href="?page=<?php echo sanitize_text_field( $_REQUEST['page'] ) . '&user=' . $user_id ; ?>" class="button"><?php echo __( "Clear filters", $this->plugin_name ); ?></a>
        </div>

        <?php
    }

    /**
     * Retrieve customers data from the database
     *
     * @param int $per_page
     * @param int $page_number
     *
     * @return mixed
     */
    public static function get_user_vocabulary($per_page = 20, $page_number = 1) {

        if( self::get_where_condition() === false ){
            return;
        }

        global $wpdb;
        $words_table = $wpdb->prefix . "ayspd_words";
        $sql = "SELECT * FROM ".$words_table;
        $sql .= self::get_where_condition();

        if ( ! empty( $_REQUEST['orderby'] ) ) {

            $order_by = ( isset( $_REQUEST['orderby'] ) && sanitize_text_field( $_REQUEST['orderby'] ) != '' ) ? sanitize_text_field( $_REQUEST['orderby'] ) : 'id';
            $order_by .= ( ! empty( $_REQUEST['order'] ) && strtolower( $_REQUEST['order'] ) == 'asc' ) ? ' ASC' : ' DESC';

            $sql_orderby = sanitize_sql_orderby($order_by);

            if ( $sql_orderby ) {
                $sql .= ' ORDER BY ' . $sql_orderby;
            } else {
                $sql .= ' ORDER BY id DESC';
            }
        } else {
            $sql .= ' ORDER BY id DESC';
        }

        $sql .= " LIMIT $per_page";
        $sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;

        $result = $wpdb->get_results( $sql, 'ARRAY_A' );

        return $result;
    }

    public static function get_where_condition(){

        
        $where = array();
        $user_id = isset($_GET['user']) && $_GET['user'] != '' ? sanitize_text_field($_GET['user']) : '';

        if ($user_id === '') {
            return false;
        } else {
            $where[] = ' `user_id` = '. $user_id .' ';
        }

        global $wpdb;
        $sql = '';

        $search = ( isset( $_REQUEST['s'] ) ) ? $_REQUEST['s'] : false;
        if( $search ){
            $s = array();
            $s[] = sprintf( " `word` LIKE '%%%s%%' ", esc_sql( $wpdb->esc_like( $search ) ) );
            $s[] = sprintf( " `translation` LIKE '%%%s%%' ", esc_sql( $wpdb->esc_like( $search ) ) );

            $where[] = ' ( ' . implode(' OR ', $s) . ' ) ';
        }

        if( isset( $_REQUEST['filterbygroup'] ) && absint( sanitize_text_field( $_REQUEST['filterbygroup'] ) ) > 0){
            $category_id = absint( sanitize_text_field( $_REQUEST['filterbygroup'] ) );
            $where[] = ' `category_id` = '. $category_id .' ';
        }

        if( ! empty($where) ){
            $sql = " WHERE " . implode( " AND ", $where );
        }
        return $sql;
    }

    /**
     * Returns the count of records in the database.
     *
     * @return null|string
     */
    public static function record_count() {
        global $wpdb;
        
        $words_table = $wpdb->prefix . "ayspd_words";

        $sql = "SELECT COUNT(*) FROM " . $words_table;
        $sql .= self::get_where_condition();
        return $wpdb->get_var( $sql );
    }

    /**
     *  Associative array of columns
     *
     * @return array
     */  
    function get_columns() {     
        $columns = array(
            'word' => __( 'Word', $this->plugin_name ),
            'translation' => __( 'Translation', $this->plugin_name ),
            'category_id' => __( 'Group', $this->plugin_name ),
            'percentage'  => __( 'User Learning Progress', $this->plugin_name),
            'image' => __( 'Image', $this->plugin_name ),
            'audio' => __( 'Audio', $this->plugin_name ),
            'date_created' => __( 'Created', $this->plugin_name ),
            'id' => __('ID', $this->plugin_name),
        );

        return $columns;
    }

    /**
     * Columns to make sortable.
     *
     * @return array
     */
    public function get_sortable_columns() {
        $sortable_columns = array(
            'category_id' => array( 'category_id', true ),
            'id' => __('id', $this->plugin_name),
        );

        return $sortable_columns;
    }

    /**
     * Render a column when no column specific method exist.
     *
     * @param array $item
     * @param string $column_name
     *
     * @return mixed
     */
    public function column_default($item, $column_name) {
        return $item[$column_name];
    }

    /**
     * Method for category_id column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    public function column_category_id($item) {
        $category_id = $item['category_id'];

        global $wpdb;
        
        $groups_table = $wpdb->prefix . "ayspd_categories";
        $sql = "SELECT name FROM " . $groups_table . " WHERE id = " . $category_id;
        $result = $wpdb->get_var($sql);

        return $result;
    }

    /**
     * Handles data query and filter, sorting, and pagination.
     */
    public function prepare_items() {

        global $wpdb;

        $this->_column_headers = $this->get_column_info();

        $per_page     = $this->get_items_per_page( 'pd_user_vocabulary_per_page', 20 );
        $current_page = $this->get_pagenum();
        $total_items  = self::record_count();

        $this->set_pagination_args( array(
            'total_items' => $total_items, //WE have to calculate the total number of items
            'per_page'    => $per_page //WE have to determine how many items to show on a page
        ) );

        $this->items = self::get_user_vocabulary($per_page, $current_page);
    }

    /** Text displayed when no customer data is available */
    public function no_items() {
        echo __( 'There are no words yet.', $this->plugin_name );
    }

    public function column_image($item) {
        $attachment_id = $item['image']; 
        if ($attachment_id) {
            $image_url = wp_get_attachment_url($attachment_id);
            $file_path = get_attached_file($attachment_id);

            if ($image_url && $file_path) {
                $file_name = basename($file_path); 
                $image = "<a href='" . esc_url($image_url) . "' download='" . esc_attr($file_name) . "'>" . esc_html($file_name) . "</a>";
                return $image;
            }
        }
        return '';
    }
    public function column_audio($item) {
        $attachment_id = $item['audio']; 
        if ($attachment_id) {
            $audio_url = wp_get_attachment_url($attachment_id);
            
            if ($audio_url) {
                $audio = "<audio controls style='width: 300px; height: 30px;'><source src='" . esc_url($audio_url) . "' type='audio/mpeg'></audio>";
                return $audio;
            }
        }
        return ''; 
    }

}

?>