(function( $ ) {
	'use strict';
	$.fn.serializeFormJSON = function () {
        let o = {},
            a = this.serializeArray();
        $.each(a, function () {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };

    function AysPDPlugin(element, options){
        this.el = element;
        this.$el = $(element);
        this.htmlClassPrefix = 'ays-pd-';
        this.dbOptionsPrefix = 'pd_';
        this.ajaxAction = 'ays_pd_ajax';
        this.dbOptions = undefined;

        this.init();

        return this;
    }

    AysPDPlugin.prototype.init = function() {
		var _this = this;
		var dataFunction = _this.$el.find('.ays-pd-tab-content').attr('data-function');

		if(dataFunction == 'ays_groups_pd' || dataFunction == 'ays_pd_get_groups' ){
			_this.selectGroupsAjax();
		}

		if( typeof window.aysPdOptions != 'undefined' ){
			_this.dbOptions = JSON.parse(atob(window.aysPdOptions));
        }

		this.setup();
        this.setEvents();
    }

    AysPDPlugin.prototype.setup = function() {
		var _this = this;

		var linkSearch = location.search;
		
		if(linkSearch != ''){
			var linkUrl = linkSearch.split('?')[1].split('&');
			for(var i = 0; i < linkUrl.length; i++){
				if(linkUrl[i].split("=")[0] == 'ays-pd-tab'){
					_this.goTo();
				}
			}	
		}
		
    }

    AysPDPlugin.prototype.setEvents = function(e) {
        var _this = this;

		_this.$el.find('.'+_this.htmlClassPrefix+'import-select').select2({
			placeholder: ''+aysPdLangObj.selectGroup+'',
			dropdownParent: $('.ays-pd-import-select-group-block')
		});

        _this.$el.on('click', '.'+_this.htmlClassPrefix+'add_group_btn', function(e){
            e.preventDefault();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-edit-layer').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-name-inp').val('');
			_this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').removeAttr('data-catid');
			_this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').removeAttr('data-command');

			var content = '';
			
			content += '<div class="ays-pd-add-group-form">';
				content +='<div class="ays-pd-group-close-button-div ays-pd-add-group-close-button-div"><input type="text" placeholder="' + aysPdLangObj.groupName + '" class="ays-pd-group-name-inp ays-pd-group-adding-fields"></div>';
				content += '<div class="ays-pd-group-delete-button-block "><input type="button" value="'+aysPdLangObj.save+'" class="ays-pd-save_group_button ays-pd-group-adding-fields"><input type="button" value="'+aysPdLangObj.cancel+'" class="ays-pd-box-close-button ays-pd-group-adding-fields ays-pd-secondary-input-fields"></div>';
			content += '</div>';

			_this.$el.find('.'+_this.htmlClassPrefix+'save-groups-block').html(content);

			_this.$el.find('.'+_this.htmlClassPrefix+'save-groups-block').show();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-name-inp').focus();

        });

        _this.$el.on('click','.ays-pd-save_group_button',function(e){
			_this.groupsSaveAjax();
		});

      	_this.$el.on('click','.ays-pd-group-tab .ays-pd-groups-box',function(e){
			var pd_div = _this.$el.find('.'+_this.htmlClassPrefix+'groups_progress_bar_icons');

			_this.removeGroupsSearchBox();
			if(!pd_div.is(e.target) && pd_div.has(e.target).length === 0){
				_this.$el.find('.'+_this.htmlClassPrefix+'save-groups-block').hide();
				var dataId = $(this).attr('data-id');
				_this.selectWordsAjax(dataId);
				e.preventDefault();
			}

        });

		_this.$el.on('click','.'+_this.htmlClassPrefix+'header-previous-page-btn',function(e){
            e.preventDefault();
            _this.selectGroupsAjax();
			var prevBttnBox = _this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box');
			if (!prevBttnBox.hasClass('ays-pd-games-settings-previous-page-btn')) {
				_this.$el.find('.ays-pd-header-main h3').text(aysPdLangObj.groups)
				var topBttns = _this.$el.find('.ays-pd-header-main .ays-pd-header-btn-box');
				topBttns.each(function() {
					_this.$el.find('.ays-pd-search-word-container').addClass('ays_display_none');
					$(this).addClass('ays_display_none');
					if ($(this).hasClass(_this.htmlClassPrefix + 'header-search-group-btn-box')) {
						$(this).removeClass('ays_display_none');					
					}
				});
			}
            _this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').hide();			
        });

		_this.$el.on('click','.'+_this.htmlClassPrefix+'games-type-previous-page-btn',function(e){
            e.preventDefault();
			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content').hide(200);
			_this.$el.find('.'+_this.htmlClassPrefix+'games-choosing-type').show(200);
			_this.$el.find('.ays-pd-header-main h3').text(aysPdLangObj.games);
			var prevBttn = _this.$el.find('.ays-pd-header-main .ays-pd-header-btn-box');
			prevBttn.addClass('ays_display_none');
            _this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').hide();
        });

		_this.$el.on('click','.'+_this.htmlClassPrefix+'games-settings-previous-page-btn',function(e){
            e.preventDefault();
			_this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box').removeClass('ays-pd-games-settings-previous-page-btn');
			_this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box').addClass('ays-pd-games-type-previous-page-btn');
			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game').html('');
			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'games-select-groups').show(200);
            _this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').hide();
        });
		
        _this.$el.on('click','.'+_this.htmlClassPrefix+'each_word_item' + ',' + '.'+_this.htmlClassPrefix+'word-edit-btn', function(e){
			e.preventDefault();
			
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').html('');

			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-edit-layer').not($(this).parents('.'+_this.htmlClassPrefix+'words-box').next()).hide();

			var deleteIcon = '<svg xmlns="http://www.w3.org/2000/svg" width="13" height="16" viewBox="0 0 13 16" fill="none"><path d="M11.75 2H9V1.5C9 0.672906 8.32709 0 7.5 0H5.5C4.67291 0 4 0.672906 4 1.5V2H1.25C0.56075 2 0 2.56075 0 3.25V5C0 5.27612 0.223875 5.5 0.5 5.5H0.77325L1.20522 14.5713C1.24338 15.3725 1.9015 16 2.7035 16H10.2965C11.0985 16 11.7567 15.3725 11.7948 14.5713L12.2268 5.5H12.5C12.7761 5.5 13 5.27612 13 5V3.25C13 2.56075 12.4392 2 11.75 2ZM5 1.5C5 1.22431 5.22431 1 5.5 1H7.5C7.77569 1 8 1.22431 8 1.5V2H5V1.5ZM1 3.25C1 3.11216 1.11216 3 1.25 3H11.75C11.8878 3 12 3.11216 12 3.25V4.5H1V3.25ZM10.7959 14.5238C10.7899 14.6522 10.7347 14.7733 10.6417 14.862C10.5487 14.9507 10.425 15.0001 10.2965 15H2.7035C2.57497 15.0001 2.45133 14.9507 2.35831 14.862C2.26529 14.7733 2.21005 14.6522 2.20409 14.5238L1.77437 5.5H11.2256L10.7959 14.5238Z" class="ays-pd-icon-main-color-fill" /><path d="M6.5 14C6.77612 14 7 13.7761 7 13.5V7C7 6.72387 6.77612 6.5 6.5 6.5C6.22388 6.5 6 6.72387 6 7V13.5C6 13.7761 6.22384 14 6.5 14ZM9 14C9.27612 14 9.5 13.7761 9.5 13.5V7C9.5 6.72387 9.27612 6.5 9 6.5C8.72388 6.5 8.5 6.72387 8.5 7V13.5C8.5 13.7761 8.72384 14 9 14ZM4 14C4.27613 14 4.5 13.7761 4.5 13.5V7C4.5 6.72387 4.27613 6.5 4 6.5C3.72387 6.5 3.5 6.72387 3.5 7V13.5C3.5 13.7761 3.72384 14 4 14Z" class="ays-pd-icon-main-color-fill"/></svg>';			
			var imageIcon = '<svg class="w-6 h-6 text-gray-800 dark:text-white imageIcon " aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 15v2a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3v-2M12 4v12m0-12 4 4m-4-4L8 8"/></svg>';
			var closeIcon = '<svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18 17.94 6M18 18 6.06 6"/></svg>';
			var loaderIcon = '<svg width="15" height="15" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><style>.spinner_7mtw{transform-origin:center;animation:spinner_jgYN .6s linear infinite}@keyframes spinner_jgYN{100%{transform:rotate(360deg)}}</style><path class="spinner_7mtw" d="M2,12A11.2,11.2,0,0,1,13,1.05C12.67,1,12.34,1,12,1a11,11,0,0,0,0,22c.34,0,.67,0,1-.05C6,23,2,17.74,2,12Z"/></svg>';
			
			var content = '';

			content += '<div class="ays-pd-word-translation-fields-parent">';
				content += '<input type="text" class="ays-pd-edit_word_field ays-pd-word_editing_fields" placeholder="'+aysPdLangObj.word+'">';
				content += '<input type="text" class="ays-pd-edit_translation_field ays-pd-word_editing_fields" placeholder="'+aysPdLangObj.translation+'">';
			content += '</div>';	
			content += '<div class="ays-pd-image-audio-fields-parent">';
				content += '<div class="ays-pd-edit-upload-image-ready-box" style="display:none;">';
					content += '<div class="ays-pd-edit-upload-image-ready-link-box">';
						content += '<a class="ays-pd-edit-upload-image-ready-link edit-image-name"></a>';
						content += '<input class="ays-pd-edit-upload-image-ready-url-link" type="hidden">';
					content += '</div>';
					content += '<div class="ays-pd-edit-upload-image-close-button" data-type="image">';
						content += closeIcon;
					content += '</div>';
				content += '</div>';
				content += '<div class="ays-pd-edit-upload-image-button"  style="display:none;">';
					content += '<label class="ays-pd-edit-image-input-label">';
						content += '<div class="ays-pd-image-fields-parent">';
							content += '<input type="file" id="edit-image" class="ays-pd-edit_input_image" data-type="image" title="'+aysPdLangObj.imageTitle+'" accept="image/*" hidden>';
							content += '<div class="image-icon" style="display:flex;">';
							content += imageIcon;
							content += '</div>';
							content	+= '<div class="ays-pd-image-loader" style="display:none; align-items:center;justify-content:center;">';
								content += loaderIcon;
							content += '</div>';
							content += '<span class="ays-pd-add-image">' + aysPdLangObj.image + '</span>';
						content += '</div>';
					content += '</label>';
				content += '</div>';
				content += '<div class="ays-pd-edit-upload-audio-ready-box" style="display:none;">';
					content += '<div class="ays-pd-edit-upload-audio-ready-link-box">';
						content += '<a class="ays-pd-edit-upload-audio-ready-link edit-audio-name"></a>';
						content += '<input class="ays-pd-edit-upload-audio-ready-url-link" type="hidden">';
					content += '</div>';
					content += '<div class="ays-pd-edit-upload-audio-close-button" data-type="audio">';
						content += closeIcon;
					content += '</div>';
				content += '</div>';
				content += '<div class="ays-pd-edit-upload-audio-button" style="display:none;">';
					content += '<label class="ays-pd-edit-audio-input-label">';
						content += '<div class="ays-pd-audio-fields-parent">';
							content += '<input type="file" id="edit-audio" class="ays-pd-edit_input_audio" data-type="audio" title="'+aysPdLangObj.audioTitle+'" accept="audio/*" hidden>';
							content += '<div class="audio-icon" style="display:flex;">';
							content += imageIcon;
							content += '</div>';
							content	+= '<div class="ays-pd-audio-loader" style="display:none; align-items:center;justify-content:center;">';
								content += loaderIcon;
							content += '</div>';
							content += '<span class="ays-pd-add-audio">' + aysPdLangObj.audio + '</span>';
						content += '</div>';
					content += '</label>';
				content += '</div>';
				content += '<span class="ays-pd-error-message" style="color: red; display: none; margin-top: 5px; font-size:12px;"></span>';
			content += '</div>';
			content += '<div class="ays-pd-word-save-and-delete-button-block">'
				content += '<div class="ays-pd-word-save-and-cancel-button-block">';
					content += '<input type="button" value="' + aysPdLangObj.save + '" class="ays-pd-edit-words-btn ays-pd-words_save_btn">';
					content += '<span class="ays-pd-box-close-button ays-pd-box-close-button-word-edit">'+ aysPdLangObj.cancel +'</span>';
				content += '</div>';
				content += '<div class="ays-pd-word-delete-button-item">';
					content += deleteIcon;
				content += '</div>';
			content += '</div>';
			$(this).parents('.'+_this.htmlClassPrefix+'words-each-item-block').find('.'+_this.htmlClassPrefix+'group-tab-edit-layer').html(content);
			
			
			_this.$el.find('.'+_this.htmlClassPrefix+'each_word_item').removeAttr('data-command');
			var dataId =	$(this).parents('.'+_this.htmlClassPrefix+'words-box').attr('data-id');	
			_this.$el.find('.'+_this.htmlClassPrefix+'edit-words-btn').attr('data-wordid',dataId);
			_this.$el.find('.'+_this.htmlClassPrefix+'edit-words-btn').attr('data-command','edit');
            var thisWord 			= $(this).parents('.'+_this.htmlClassPrefix+'words-box').find('.ays-pd-each_word_span').text().trim();
            var thisTranslation 	= $(this).parents('.'+_this.htmlClassPrefix+'words-box').find('.ays-pd-each_translation').text().trim();
			var thisImage			= $(this).parents('.'+_this.htmlClassPrefix+'words-box').find('.ays-pd-each_image_span').text();
			var thisAudio			= $(this).parents('.'+_this.htmlClassPrefix+'words-box').find('.ays-pd-each_audio_span').text();
			var imageHref           = $(this).parents('.'+_this.htmlClassPrefix+'words-box').find('.ays-pd-each_image_span').attr('href');
			var audioHref           = $(this).parents('.'+_this.htmlClassPrefix+'words-box').find('.ays-pd-each_audio_span').attr('href');
			
            _this.$el.find('.'+_this.htmlClassPrefix+'edit_word_field').val(thisWord);
            _this.$el.find('.'+_this.htmlClassPrefix+'edit_translation_field').val(thisTranslation);

			$(this).parents('.'+_this.htmlClassPrefix+'words-box').next().slideToggle(function(){
				$('.'+_this.htmlClassPrefix+'edit_word_field').focus();
			});
	
			if (_this.dbOptions.pd_enable_add_audio_from_front == 'on') {
				if(!thisAudio || thisAudio.trim() === ''){
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-audio-button').show();
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-audio-ready-box').hide();
				}else{
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-audio-button').hide();
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-audio-ready-box').show();
					_this.$el.find('.edit-audio-name').text(thisAudio).attr('title', thisAudio).attr('download',thisAudio).attr('href',audioHref);					
				}	
			}
			
			if (_this.dbOptions.pd_enable_add_image_from_front == 'on') {
				if(!thisImage || thisImage.trim() === ''){
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-image-button').show();
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-image-ready-box').hide();
				}else{
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-image-button').hide();
					_this.$el.find('.'+_this.htmlClassPrefix+'edit-upload-image-ready-box').show();
					_this.$el.find('.edit-image-name').text(thisImage).attr('title', thisImage).attr('download',thisImage).attr('href',imageHref);

				}	

			}

        });
		
		_this.$el.on('click', '.'+_this.htmlClassPrefix+'edit-upload-image-close-button , .' +_this.htmlClassPrefix+'edit-upload-audio-close-button', function() {
			var $this = $(this);
			var data_type =  $this.attr('data-type');
			parent = $this.parents('.ays-pd-image-audio-fields-parent');
			
			if (data_type === 'image') {
				parent.find('.image-icon').css('display', 'flex');		
				parent.find('.ays-pd-edit-upload-image-ready-box').hide();
				parent.find('.ays-pd-edit-upload-image-button').show();
				parent.find('.ays-pd-edit_input_image').val('');
			} else if (data_type === 'audio') {
				parent.find('.audio-icon').css('display', 'flex');		
				parent.find('.ays-pd-edit-upload-audio-ready-box').hide();
				parent.find('.ays-pd-edit-upload-audio-button').show();
				parent.find('.ays-pd-edit_input_audio').val('');
			}
			_this.mediaDelete(data_type);
			
		});

		_this.$el.on('change', '.' + _this.htmlClassPrefix + 'edit_input_image, .' + _this.htmlClassPrefix + 'edit_input_audio', function () {
			var $this = $(this);
			const file = this.files[0];
			var fileName = file.name;
			var fileType = file.type;
			var data_type =  $this.attr('data-type');
			var mainBox = $this.parents('.ays-pd-image-audio-fields-parent');	
			var imageLoader = mainBox.find('.ays-pd-image-loader');
			var errorBox = mainBox.find('.ays-pd-error-message');
    		errorBox.text('').hide();
			var allowedImageTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
			var allowedAudioTypes = ['audio/mpeg', 'audio/wav', 'audio/ogg'];
			
			if (data_type === 'image' && !allowedImageTypes.includes(fileType)){
				errorBox.text(aysPdLangObj.errorMessageUploadImage).show();
				$this.val(''); 
				return;
			} else if(data_type === 'audio' && !allowedAudioTypes.includes(fileType)){
				errorBox.text(aysPdLangObj.errorMessageUploadAudio).show();
				$this.val(''); 
				return;
			}
			if (data_type === 'image') {			
				imageLoader.css('display', 'flex');
				mainBox.find('.image-icon').css('display', 'none');	
				mainBox.find('.ays-pd-image-fields-parent').addClass('disabled').prop('disabled', true);

			} else if (data_type === 'audio'){
				mainBox.find('.ays-pd-audio-loader').css('display', 'flex');
				mainBox.find('.audio-icon').css('display', 'none');		
				mainBox.find('.ays-pd-audio-fields-parent').addClass('disabled').prop('disabled', true);		
			}
			var formData = new FormData();
			var sFunction = 'ays_pd_upload_file';
			formData.append('file', file);
			formData.append('function', sFunction);
			formData.append('action', _this.ajaxAction);
			_this.uploadFile(formData, mainBox, fileName, true);	
		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'group-more-btn',function(e){
			$(this).parents('.'+_this.htmlClassPrefix+'each_group_item').find('.'+_this.htmlClassPrefix+'group-dropdown-menu').toggle();
		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'word-more-btn',function(e){
			$(this).parents('.'+_this.htmlClassPrefix+'words-each-item-block').find('.'+_this.htmlClassPrefix+'word-dropdown-menu').toggle();
		});	

		$(document).on("mouseup", function(e) {
			var container = _this.$el.find('.'+_this.htmlClassPrefix+'dropdown-buttons');
			if (!container.is(e.target) && container.has(e.target).length === 0){
				container.hide();
			}
		});

        _this.$el.on('click','.'+_this.htmlClassPrefix+'group-edit-btn',function(e){
			e.preventDefault();
			
			_this.$el.find('.'+_this.htmlClassPrefix+'save-groups-block').html('');
            _this.$el.find('.'+_this.htmlClassPrefix+'save-groups-block').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-edit-layer').not($(this).parents('.'+_this.htmlClassPrefix+'groups-box').next()).hide();
			
			var content = '';
			
			content += '<div class="ays-pd-add-group-form">';
			content +='<div class="ays-pd-close-button-div"><input type="text" placeholder="' + aysPdLangObj.groupName + '" class="ays-pd-group-name-inp ays-pd-group-edit-name"><span class="ays-pd-box-close-button">'+ aysPersonalDictionaryAjaxPublic.icons.close_icon+'</span></div>';
			content += '<div class="ays-pd-group-delete-button-block "><input type="button" value="'+aysPdLangObj.save+'" class="ays-pd-save_group_button"><a class="ays-pd-delete-button-icon ays-pd-group-delete-button-item ">' + aysPdLangObj.delete + '</a></div>';
			content += '</div>';
			
			$(this).parents('.'+_this.htmlClassPrefix+'each_group_item').find('.'+_this.htmlClassPrefix+'group-edit-layer').html(content);
			_this.$el.find('.'+_this.htmlClassPrefix+'each_group_item').removeAttr('data-command');
			$(this).parents('.'+_this.htmlClassPrefix+'each_group_item').attr('data-command','edit');
			var dataId = $(this).parents('.'+_this.htmlClassPrefix+'each_group_item').attr('data-id');	
			var dataCommand = $(this).parents('.'+_this.htmlClassPrefix+'each_group_item').attr('data-command');
			_this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').attr('data-catid',dataId);
			_this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').attr('data-command',dataCommand);
            var thisGroup = $(this).parents('.'+_this.htmlClassPrefix+'each_group_item').find('.ays-pd_each_group_name').text().trim();
            _this.$el.find('.'+_this.htmlClassPrefix+'group-name-inp').val(thisGroup);
			
			$(this).parents('.'+_this.htmlClassPrefix+'groups-box').next().slideToggle(function(){
				$('.'+_this.htmlClassPrefix+'group-edit-name').focus();
			});

        });

        _this.$el.on('click','.'+_this.htmlClassPrefix+'add-group-form ' + '.'+_this.htmlClassPrefix+'box-close-button' ,function(e){
            e.preventDefault();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-edit-layer').slideUp();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-edit-layer').html('');
			_this.$el.find('.'+_this.htmlClassPrefix+'group-name-inp').val('');
			_this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').removeAttr('data-catid');
			_this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').removeAttr('data-command');
			_this.$el.find('.'+_this.htmlClassPrefix+'each_group_item').removeAttr('data-command');
        });
		
        _this.$el.on('click','.ays-pd-header-add-word-btn, .ays-pd-add_word_btn',function(e){
            e.preventDefault();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-edit-layer').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'word_field').val('');
            _this.$el.find('.'+_this.htmlClassPrefix+'translation_field').val('');
			_this.$el.find('.'+_this.htmlClassPrefix+'add-edit-words-btn').removeAttr('data-wordid');
			_this.$el.find('.'+_this.htmlClassPrefix+'add-edit-words-btn').removeAttr('data-command');
			_this.$el.find('.'+_this.htmlClassPrefix+'each_word_item').removeAttr('data-command');

			var deleteIcon = '<svg xmlns="http://www.w3.org/2000/svg" width="13" height="16" viewBox="0 0 13 16" fill="none"><path d="M11.75 2H9V1.5C9 0.672906 8.32709 0 7.5 0H5.5C4.67291 0 4 0.672906 4 1.5V2H1.25C0.56075 2 0 2.56075 0 3.25V5C0 5.27612 0.223875 5.5 0.5 5.5H0.77325L1.20522 14.5713C1.24338 15.3725 1.9015 16 2.7035 16H10.2965C11.0985 16 11.7567 15.3725 11.7948 14.5713L12.2268 5.5H12.5C12.7761 5.5 13 5.27612 13 5V3.25C13 2.56075 12.4392 2 11.75 2ZM5 1.5C5 1.22431 5.22431 1 5.5 1H7.5C7.77569 1 8 1.22431 8 1.5V2H5V1.5ZM1 3.25C1 3.11216 1.11216 3 1.25 3H11.75C11.8878 3 12 3.11216 12 3.25V4.5H1V3.25ZM10.7959 14.5238C10.7899 14.6522 10.7347 14.7733 10.6417 14.862C10.5487 14.9507 10.425 15.0001 10.2965 15H2.7035C2.57497 15.0001 2.45133 14.9507 2.35831 14.862C2.26529 14.7733 2.21005 14.6522 2.20409 14.5238L1.77437 5.5H11.2256L10.7959 14.5238Z" class="ays-pd-icon-main-color-fill" /><path d="M6.5 14C6.77612 14 7 13.7761 7 13.5V7C7 6.72387 6.77612 6.5 6.5 6.5C6.22388 6.5 6 6.72387 6 7V13.5C6 13.7761 6.22384 14 6.5 14ZM9 14C9.27612 14 9.5 13.7761 9.5 13.5V7C9.5 6.72387 9.27612 6.5 9 6.5C8.72388 6.5 8.5 6.72387 8.5 7V13.5C8.5 13.7761 8.72384 14 9 14ZM4 14C4.27613 14 4.5 13.7761 4.5 13.5V7C4.5 6.72387 4.27613 6.5 4 6.5C3.72387 6.5 3.5 6.72387 3.5 7V13.5C3.5 13.7761 3.72384 14 4 14Z" class="ays-pd-icon-main-color-fill" /></svg>';
			var imageIcon = '<svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 15v2a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3v-2M12 4v12m0-12 4 4m-4-4L8 8"/></svg>';
			var closeIcon = '<svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18 17.94 6M18 18 6.06 6"/></svg>';
			var loaderIcon = '<svg width="15" height="15" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><style>.spinner_7mtw{transform-origin:center;animation:spinner_jgYN .6s linear infinite}@keyframes spinner_jgYN{100%{transform:rotate(360deg)}}</style><path class="spinner_7mtw" d="M2,12A11.2,11.2,0,0,1,13,1.05C12.67,1,12.34,1,12,1a11,11,0,0,0,0,22c.34,0,.67,0,1-.05C6,23,2,17.74,2,12Z"/></svg>';		
			var content = '';

			content += '<div class="ays-pd-close-button-div ays-pd-close-button-div-word-top"><div class="ays-pd-box-close-button">'+ aysPersonalDictionaryAjaxPublic.icons.close_icon+'</div></div>';
				content += '<div class="ays-pd-word-translation-fields-parent">';
					content += '<input type="text" class="ays-pd-word_field ays-pd-word_saving_fields" placeholder="'+aysPdLangObj.word+'">';
					content += '<input type="text" class="ays-pd-translation_field ays-pd-word_saving_fields" placeholder="'+aysPdLangObj.translation+'">';
				content += '</div>';

			content += '<div class="ays-pd-image-audio-fields-parent">';
				content += '<div class="ays-pd-upload-image-ready-box" style="display:none;">';
					content += '<div class="ays-pd-upload-image-ready-link-box">';
						content += '<a class="ays-pd-upload-image-ready-link image-name"></a>';
						content += '<input class="ays-pd-upload-image-ready-url-link" type="hidden">';
					content += '</div>';
					content += '<div class="ays-pd-upload-image-close-button" data-type="image">';
						content += closeIcon;
					content += '</div>';
				content += '</div>';
				content += '<div class="ays-pd-upload-image-button" style="display:none;">';
					content += '<label class="ays-pd-image-input-label">';
						content += '<div class="ays-pd-image-fields-parent">';
							content += '<input type="file" id="image" class="ays-pd-input_image" title="'+aysPdLangObj.imageTitle+'" accept="image/*" data-type="image" hidden>';
							content += '<div class="image-icon" style="display:flex;">';
							content += imageIcon;
							content += '</div>';
							content	+= '<div class="ays-pd-image-loader" style="display:none; align-items:center;justify-content:center;">';
								content += loaderIcon;
							content += '</div>';
							content += '<span class="ays-pd-add-image">' + aysPdLangObj.image + '</span>';
						content += '</div>';
					content += '</label>';
				content += '</div>';
				content += '<div class="ays-pd-upload-audio-ready-box" style="display:none;">';
					content += '<div class="ays-pd-upload-audio-ready-link-box">';
						content += '<a class="ays-pd-upload-audio-ready-link audio-name"></a>';
						content += '<input class="ays-pd-upload-audio-ready-url-link" type="hidden">';
					content += '</div>';
					content += '<div class="ays-pd-upload-audio-close-button" data-type="audio">';
						content += closeIcon;
					content += '</div>';
				content += '</div>';
				content += '<div class="ays-pd-upload-audio-button" style="display:none;">';
					content += '<label class="ays-pd-audio-input-label">';
						content += '<div class="ays-pd-audio-fields-parent">';
							content += '<input type="file" id="audio" class="ays-pd-input_audio" title="'+aysPdLangObj.audioTitle+'" data-type="audio" accept="audio/*" hidden >';
							content += '<div class="audio-icon" style="display:flex;">';
							content += imageIcon;
							content += '</div>';
							content	+= '<div class="ays-pd-audio-loader" style="display:none; align-items:center;justify-content:center;">';
								content += loaderIcon;
							content += '</div>';
							content += '<span class="ays-pd-add-audio">' + aysPdLangObj.audio + '</span>';
						content += '</div>';
					content += '</label>';
				content += '</div>';
				content += '<span class="ays-pd-error-message" style="color: red; display: none; margin-top: 5px; font-size:12px;"></span>';
			content += '</div>';
			content += '<div class="ays-pd-word-save-and-delete-btn-block-div">';
				content += '<div class="ays-pd-word-save-bttns-block-div">';
					content += '<input type="button" value="'+aysPdLangObj.save+'" class="ays-pd-add-edit-words-btn ays-pd-words_save_btn ays-pd-word_saving_fields">'
					content += '<input type="button" value="'+aysPdLangObj.saveAndClose+'" class="ays-pd-add-edit-words-btn ays-pd-words_save_and_close_btn ays-pd-secondary-input-fields">'
				content += '</div>';
				content += '<div class="ays-pd-delete-button-icon ays-pd-word-delete-button-item">';
					content += deleteIcon;
				content += '</div>';
			content += '</div>';

			
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-words').html(content);

			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-words').show();
			$('.'+_this.htmlClassPrefix+'word_field').focus();

			if (_this.dbOptions.pd_enable_add_image_from_front == 'on') {
				_this.$el.find('.ays-pd-upload-image-button').show();
			}
			if (_this.dbOptions.pd_enable_add_audio_from_front == 'on') {
				_this.$el.find('.ays-pd-upload-audio-button').show();
			}
        });

		_this.$el.on('change', '.' + _this.htmlClassPrefix + 'input_image, .' + _this.htmlClassPrefix + 'input_audio', function () {
			var $this = $(this);
			const file = this.files[0];
			var fileName = file.name;
			var fileType = file.type;
			var data_type =  $this.attr('data-type');
			var mainBox = $this.parents('.ays-pd-image-audio-fields-parent');	
			var errorBox = mainBox.find('.ays-pd-error-message');
    		errorBox.text('').hide();
			var allowedImageTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
			var allowedAudioTypes = ['audio/mpeg', 'audio/wav', 'audio/ogg'];

			if (data_type === 'image' && !allowedImageTypes.includes(fileType)){
				errorBox.text(aysPdLangObj.errorMessageUploadImage).show();
				$this.val(''); 
				return;
			} else if(data_type === 'audio' && !allowedAudioTypes.includes(fileType)){
				errorBox.text(aysPdLangObj.errorMessageUploadAudio).show();
				$this.val(''); 
				return;
			}
			if (data_type === 'image') {
				mainBox.find('.ays-pd-image-loader').css('display','flex');
				mainBox.find('.image-icon').css('display','none');
				mainBox.find('.ays-pd-image-fields-parent').addClass('disabled').prop('disabled', true);
			} else if (data_type === 'audio'){
				mainBox.find('.ays-pd-audio-loader').css('display','flex');
				mainBox.find('.audio-icon').css('display','none');			
				mainBox.find('.ays-pd-audio-fields-parent').addClass('disabled').prop('disabled', true);
			}
			var formData = new FormData();
			var sFunction = 'ays_pd_upload_file';
			formData.append('file', file);
			formData.append('function', sFunction);
			formData.append('action', _this.ajaxAction);
			_this.uploadFile(formData, mainBox, fileName, false);		
		});

		_this.$el.on('click', '.'+_this.htmlClassPrefix+'upload-image-close-button , .' +_this.htmlClassPrefix+'upload-audio-close-button', function() {
			var $this = $(this);
			var data_type =  $this.attr('data-type');	
			parent = $this.parents('.ays-pd-image-audio-fields-parent');
			if (data_type === 'image') {
				parent.find('.image-icon').css('display','flex');
				parent.find('.ays-pd-upload-image-ready-box').hide();
				parent.find('.ays-pd-upload-image-button').show();
				parent.find('.ays-pd-input_image').val('');
			} else if (data_type === 'audio') {
				parent.find('.audio-icon').css('display','flex');
				parent.find('.ays-pd-upload-audio-ready-box').hide();
				parent.find('.ays-pd-upload-audio-button').show();
				parent.find('.ays-pd-input_audio').val('');
			}
		});		
		

		_this.$el.on('click', '.' + _this.htmlClassPrefix +'header-search-group-btn', function() {
			_this.generateGroupsSearchBox();
		});

		_this.$el.on('click', '.' + _this.htmlClassPrefix +'remove-group-search-box', function() {
			_this.removeGroupsSearchBox();
		});

		_this.$el.on('input', '#' + _this.htmlClassPrefix +'group-search', function() {
			_this.aysPDSearchGroup($(this));
		});

		_this.$el.on('click', '.' + _this.htmlClassPrefix +'header-search-word-btn', function() {
			_this.$el.find('.ays-pd-search-word-container').removeClass('ays_display_none');
			_this.generateWordSearchBox();
		});

		_this.$el.on('click', '.' + _this.htmlClassPrefix +'remove-word-search-box', function() {
			_this.removeWordSearchBox();
		});

		_this.$el.on('input', '#' + _this.htmlClassPrefix +'word-search', function() {
			_this.aysPDSearchWord($(this));
		});

        _this.$el.on('click','.'+_this.htmlClassPrefix+'group-tab-add-layer ' + '.'+_this.htmlClassPrefix+'box-close-button',function(e){
			e.preventDefault();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').hide();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-add-layer').html('');
			_this.$el.find('.'+_this.htmlClassPrefix+'word_field').val('');
            _this.$el.find('.'+_this.htmlClassPrefix+'translation_field').val('');
			_this.$el.find('.'+_this.htmlClassPrefix+'each_word_item').removeAttr('data-command');
        });	

        _this.$el.on('click','.'+_this.htmlClassPrefix+'group-tab-edit-layer ' + '.'+_this.htmlClassPrefix+'box-close-button',function(e){
			e.preventDefault();
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-edit-layer').slideUp();
			_this.$el.find('.'+_this.htmlClassPrefix+'edit_word_field').val('');
            _this.$el.find('.'+_this.htmlClassPrefix+'edit_translation_field').val('');
			_this.$el.find('.'+_this.htmlClassPrefix+'edit-words-btn').removeAttr('data-wordid');
			_this.$el.find('.'+_this.htmlClassPrefix+'edit-words-btn').removeAttr('data-command');
			_this.$el.find('.'+_this.htmlClassPrefix+'each_word_item').removeAttr('data-command');
			_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-edit-layer').html('');
        });	

        _this.$el.on('click','.'+_this.htmlClassPrefix+'words_save_btn',function(e){
            e.preventDefault();
			if(!_this.$el.find('.'+_this.htmlClassPrefix+'words_save_btn').attr('data-wordid')){
				_this.wordsSaveAjax();
				$('.'+_this.htmlClassPrefix+'word_field').val('');
				$('.'+_this.htmlClassPrefix+'translation_field').val('');
				if (_this.dbOptions.pd_enable_add_image_from_front == 'on' ) {
					$('.ays-pd-upload-image-button').show();
					$('.image-icon').show();
				}
				if (_this.dbOptions.pd_enable_add_audio_from_front == 'on') {
					$('.ays-pd-upload-audio-button').show();
					$('.audio-icon').show();
				}
				$('.ays-pd-error-message').hide();
				$('.ays-pd-upload-image-ready-box').hide();
				$('.ays-pd-input_image').val('');
				$('.ays-pd-upload-audio-ready-box').hide();		
				$('.ays-pd-input_audio').val('');
				$('.'+_this.htmlClassPrefix+'word_field').focus();
			}else{
				_this.wordsSaveAjax();
				$('.'+_this.htmlClassPrefix+'word_field').focus();
				$('.ays-pd-error-message').hide();
			}
		});
		
		_this.$el.on('click','.'+_this.htmlClassPrefix+'words_save_and_close_btn',function(e){
			var word = $('.'+_this.htmlClassPrefix+'word_field').val();
			var translation = $('.'+_this.htmlClassPrefix+'translation_field').val();
			if (word != '' && translation != '') {
				e.preventDefault();
				_this.wordsSaveAjax();
				_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-words').html('');
				_this.$el.find('.'+_this.htmlClassPrefix+'group-tab-words').hide();
				var word = $('.'+_this.htmlClassPrefix+'word_field').val('');
				var translation = $('.'+_this.htmlClassPrefix+'translation_field').val('');
				$('.ays-pd-upload-image-ready-box').hide();
				$('.ays-pd-upload-image-button').show();
				$('.ays-pd-input_image').val('');
				$('.ays-pd-upload-audio-ready-box').hide();
				$('.ays-pd-upload-audio-button').show();
				$('.ays-pd-input_audio').val('');
				$('.'+_this.htmlClassPrefix+'word_field').focus();
				_this.$el.find('.'+_this.htmlClassPrefix+'edit-words-btn').removeAttr('data-wordid');
				_this.$el.find('.'+_this.htmlClassPrefix+'edit-words-btn').removeAttr('data-command');
			} else {
				$('.'+_this.htmlClassPrefix+'word_field').focus();
			}
		});
		
		_this.$el.on('click','.'+_this.htmlClassPrefix+'word-delete-button-item',function(e){
			var confirm = window.confirm( aysPdLangObj.deleteWordConfirm );

            if(confirm == true){
				e.preventDefault();
				var wordId = $(this).parents('.'+_this.htmlClassPrefix+'words-each-item-block').find('.'+_this.htmlClassPrefix+'words-box').attr('data-id');
				_this.wordsDeleteAjax(wordId);
				_this.$el.find('.'+_this.htmlClassPrefix+'word-dropdown-menu').hide();
				_this.$el.find('.'+_this.htmlClassPrefix+'box-close-button').trigger('click');
			}

		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'group-delete-button-item',function(e){
			var confirm = window.confirm( "Are you sure you want to delete the group?" );

            if(confirm == true){
				e.preventDefault();
				var catId = $(this).parents('.'+_this.htmlClassPrefix+'each_group_item').attr('data-id');
				_this.groupsDeleteAjax(catId);
				_this.$el.find('.'+_this.htmlClassPrefix+'group-dropdown-menu').hide();
				_this.$el.find('.'+_this.htmlClassPrefix+'box-close-button').trigger('click');
			}
		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'word-move-button-item',function(e){
				e.preventDefault();
				var currentWordId = $(this).data("wordId");
				var currentGroupId = $(this).data("groupId");
				var data = {
					"word_id": currentWordId,
					"group_id": currentGroupId
				}
				_this.groupsShowPopupAjax(data);
				_this.$el.find('.'+_this.htmlClassPrefix+'word-dropdown-menu').hide();
		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'groups-box-move',function(e){
			e.preventDefault();
			var currentWordId = $(this).data("wordId");
			var currentGroupId = $(this).data("id");
			var currentGroupName = $(this).parents('.ays-pd-each_group_item-move').find('.ays-pd_each_group_name-move').html();
				var data = {
					"word_id" : currentWordId,
					"group_id" : currentGroupId,
					"group_name" : currentGroupName
				}
				_this.moveWordToGroupajax(data);
		});

		$(document).on("keydown", function(e){
			if(e.keyCode === 27){
				$(document).find('.'+_this.htmlClassPrefix+'close-group-modal').trigger('click');
				return false;
			}
		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'word-reset-btn',function(e){
			var confirm = window.confirm( "Are you sure you want to reset the word?" );

            if(confirm == true){
				e.preventDefault();
				var wordId = $(this).parents('.'+_this.htmlClassPrefix+'words-each-item-block').find('.'+_this.htmlClassPrefix+'words-box').attr('data-id');
				_this.wordResetAjax(wordId);
				_this.$el.find('.'+_this.htmlClassPrefix+'word-dropdown-menu').hide();
			}

		});

		_this.$el.on('click','.'+_this.htmlClassPrefix+'group-reset-btn',function(e){
			var confirm = window.confirm( "Are you sure you want to reset the group?" );

            if(confirm == true){
				e.preventDefault();
				var catId = $(this).parents('.'+_this.htmlClassPrefix+'each_group_item').attr('data-id');
				_this.groupResetAjax(catId);
				_this.$el.find('.'+_this.htmlClassPrefix+'group-dropdown-menu').hide();
			}
		});

		_this.$el.on('click','.ays_pd_open_full_screen',function(e){
            var pd_container = $(this).parents('.ays-pd-box').get(0);
            _this.toggleFullscreen(pd_container);
        });
		$(document).on("fullscreenchange", function() {
            var fullscreenElement = document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement || document.msFullscreenElement;

			if (!fullscreenElement) {
				_this.$el.find('.ays-pd-open-full-screen').css({'padding':'13px 10px','display':'flex','justify-content':'flex-end'});
				_this.$el.find('.ays_pd_open_full_screen').parents('.ays-pd-box').find('.step:not(:eq(0))').css({'height':'auto'});
				_this.$el.find('.ays-pd-nav-menu').show();
				_this.$el.find('.ays-pd-content').removeClass('ays-pd-full-screen-mode-width');
				_this.$el.removeClass('ays-pd-box-id-scroll');
				_this.$el.find('.ays-pd-content.ays-pd-content-flashcards').removeClass('ays-pd-full-screen-mode-on');
			} else {
				_this.$el.find('.ays_pd_open_full_screen').parents('.ays-pd-box').find('.step:not(:eq(0))').css({'height': '100vh'});
				_this.$el.find('.ays-pd-open-full-screen').css({'padding':'13px 10px','display':'flex','justify-content':'flex-end'});
				_this.$el.find('.ays-pd-nav-menu').hide();
				_this.$el.find('.ays-pd-content').css({'width': '100%'});
				_this.$el.find('.ays-pd-content').addClass('ays-pd-full-screen-mode-width');
				_this.$el.addClass('ays-pd-box-id-scroll');
				_this.$el.find('.ays-pd-content.ays-pd-content-flashcards').addClass('ays-pd-full-screen-mode-on');
			}
		});

		_this.$el.on("keydown" , '.'+_this.htmlClassPrefix+'word_saving_fields', function(event) {
			var $thisValue = $(this).val();
			if (event.keyCode === 13) {
				if($(this).hasClass("ays-pd-translation_field")){
					var saveButton = _this.$el.find(".ays-pd-words_save_btn");
					saveButton.trigger("click");
					event.preventDefault();
				}else{
					var nextInput = _this.$el.find(".ays-pd-translation_field");
					nextInput.focus();
				}
				
			}
		});

		_this.$el.on("keydown" , '.'+_this.htmlClassPrefix+'group-adding-fields', function(event) {
			if (event.keyCode === 13) {
				var saveButton = _this.$el.find(".ays-pd-save_group_button");
				saveButton.trigger("click");
				event.preventDefault();
			}
		});

		_this.$el.on("keydown" , '.'+_this.htmlClassPrefix+'word_editing_fields', function(event) {
			if (event.keyCode === 13) {
				if($(this).hasClass("ays-pd-edit_translation_field")){
					var saveButton = _this.$el.find(".ays-pd-words_save_btn");
					saveButton.trigger("click");
					event.preventDefault();
				}else{
					var nextInput = _this.$el.find(".ays-pd-edit_translation_field");
					nextInput.focus();
				}
				
			}
		});

		_this.$el.on("keydown" , '.'+_this.htmlClassPrefix+'group-edit-name', function(event) {
			if (event.keyCode === 13) {
				var saveButton = _this.$el.find(".ays-pd-save_group_button");
				saveButton.trigger("click");
				event.preventDefault();
			}
		});

		// Games 
		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'game-type-item', function(event) {
			_this.$el.find('.'+_this.htmlClassPrefix+'games-choosing-type').hide(200);
			var prevBttn = _this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box');
			prevBttn.removeClass('ays_display_none');
			prevBttn.addClass('ays-pd-games-type-previous-page-btn');
			var gameName= $(this).find('.'+_this.htmlClassPrefix+'game-type-item-title').text();
			_this.$el.find('.'+_this.htmlClassPrefix+'header-main h3').html(gameName);
			_this.selectGroupsAjax();
			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content').show(200);
		});

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'form-check-label', function(event) {
			var countLabels = _this.$el.find('.'+_this.htmlClassPrefix+'form-check-label');
			countLabels.each(function() {
				$(this).removeClass(_this.htmlClassPrefix+'form-check-label-active');
			})
			$(this).addClass(_this.htmlClassPrefix+'form-check-label-active');
		});
		
		_this.$el.on("click" , '#'+_this.htmlClassPrefix+'games-start-button', function(event) {

			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game').show(200);
			var selectedGroupsIds = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item').val();

			var gameType = _this.$el.find('.'+_this.htmlClassPrefix+'game-type-rad:checked').val();
			var groupWordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item :selected');
			var count = 0;

			groupWordsCount.each(function(i, sel){
				count += parseInt($(sel).attr('data-count'));
			});
			
			var dataIds = new Array();
			if(selectedGroupsIds != ''){
				if(count >= 4){
					_this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box').removeClass('ays-pd-games-type-previous-page-btn');
					_this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box').addClass('ays-pd-games-settings-previous-page-btn');

					switch(gameType){
						case 'find_word':
							_this.gameFindWordAjax(selectedGroupsIds,0,dataIds);						
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
						case 'find_translation':
							_this.gameFindTranslationAjax(selectedGroupsIds,0,dataIds);						
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
						case 'matching_words':
						    _this.gameMatchingWordsAjax(selectedGroupsIds,0,dataIds);
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
						case 'write_translation':
							_this.gameWriteTranslationAnswers = [];
							_this.gameWriteTranslationAjax(selectedGroupsIds, 0, dataIds);
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
					}

				}else{
					_this.$el.find('.'+_this.htmlClassPrefix+'game-settings-message').css('color','red');
				}	
			}else{
				_this.$el.find('.'+_this.htmlClassPrefix+'game-settings-message').css('color','red');			
			}
		});

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'next-button', function(event) {
			
			var gameType = _this.$el.find('.'+_this.htmlClassPrefix+'game-type-rad:checked').val();
			var selectedGroupsIds = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item').val();

			var animationEffect = $(this).parents('.ays-pd-games-tab').attr('data-animation-effect');
			var currentPage = $(this).parents('.ays-pd-games-type-content-game-box');
			var gameNextPage = currentPage.next();
			var nextPage = $(this).hasClass('ays-pd-finish') ? '' : gameNextPage;

			_this.aysAnimateStep(animationEffect, currentPage, nextPage);
			gameNextPage.addClass('active_step');
			$(this).parents('.ays-pd-games-type-content-game-box').addClass('ays_display_none');

			if (gameType === 'write_translation') {
				gameNextPage.find('.' + _this.htmlClassPrefix + 'games-write-translation-answer').focus();
			}

			if (gameType === 'find_word' || gameType === 'find_translation') {
				var gameFieldsContainer = gameNextPage.find('.' + _this.htmlClassPrefix + 'game-fields-container');
				var fields = gameFieldsContainer.find('.' + _this.htmlClassPrefix + 'game-fields label');

				var labelHeights = [];
				fields.each(function(index, field) {
					labelHeights.push($(field).outerHeight());
				});
				var maxHeight = Math.max.apply(null, labelHeights);
				fields.css({'min-height': maxHeight});
			}
			
			var numberLimit = $(this).attr('data-limit');
			var callAjaxId = $(this).attr('data-next');
			
			var dataIds = new Array();
			var nextButtons = _this.$el.find('.'+_this.htmlClassPrefix+'next-button');
			
			if( parseInt(callAjaxId)  == nextButtons.length - 3 ){
				for(var i = 0; i < nextButtons.length; i++ ){
					
					if($(nextButtons[i]).attr('data-next') == _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val()){
						$(nextButtons[i]).addClass('ays-pd-finish');
						$(nextButtons[i]).val('Finish');
					} 
					var wordDataId = $(nextButtons[i]).attr('data-id');
					dataIds.push(wordDataId);
				}
				if(selectedGroupsIds != ''){
					switch(gameType){
						case 'find_word':
							_this.$el.find('.'+_this.htmlClassPrefix+'next-button').attr('disabled',true);
							_this.gameFindWordAjax(selectedGroupsIds,numberLimit,dataIds);
							break;
						case 'find_translation':
							_this.$el.find('.'+_this.htmlClassPrefix+'next-button').attr('disabled',true);
							_this.gameFindTranslationAjax(selectedGroupsIds,numberLimit,dataIds);
							break;
						// case 'matching_words':
						// 	_this.gameMatchingWordsAjax(selectedGroupsIds,numberLimit,dataIds);
						case 'write_translation':
							_this.$el.find('.'+_this.htmlClassPrefix+'next-button').attr('disabled',true);
							_this.gameWriteTranslationAjax(selectedGroupsIds, numberLimit, dataIds);
							break;
					}
				}
			}

			if(selectedGroupsIds != '') {
				switch(gameType){
					case 'find_word':
						var wordId = $(this).attr('data-id');
						var voted = $(this).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'translation-'+wordId+':checked').val();
			   
						if (currentAudio) {
							currentAudio.pause(); 
							currentAudio.currentTime = 0; 
						}
						_this.updateWord(wordId, gameType, voted);
						break;
					case 'find_translation':
						var wordId = $(this).attr('data-id');
						var voted = $(this).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'word-'+wordId+':checked').val();

						_this.updateWord(wordId, gameType, voted);
						break;
					// case 'matching_words':
						// break;
					case 'write_translation':
						var wordId = $(this).attr('data-id');
						var answered = $(this).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'games-write-translation-answer[data-word-id=' + wordId + ']').val();
						if (currentAudio) {
							currentAudio.pause(); 
							currentAudio.currentTime = 0; 
						}
						_this.updateWord( wordId, gameType, '', answered);
						break;

				}
			}

			for(var i = 0; i < nextButtons.length; i++ ){
				if($(nextButtons[i]).attr('data-next') == _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val()){
					$(nextButtons[i]).addClass('ays-pd-finish');
					$(nextButtons[i]).val('Finish');
				}
			}					
		});

		_this.$el.on("click" , '.' + _this.htmlClassPrefix + 'finish', function(event) {
			var gameType = _this.$el.find('.'+_this.htmlClassPrefix+'game-type-rad:checked').val();
			var selectedGroupsIds = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item').val();
			var correct_answer = 0;
			var nextButtons = _this.$el.find('.'+_this.htmlClassPrefix+'next-button');
			var score = 0;
			var wordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val();
			var contentClone = '';

			if(selectedGroupsIds != ''){
				contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-finish-game-box">';
				switch(gameType){
					case 'find_word':
						for(var i = 0; i < nextButtons.length; i++ ){							
							var wordId = $(nextButtons[i]).attr('data-id');
							var translationVal = _this.$el.find('.' + _this.htmlClassPrefix+'translation-' + wordId+':checked').val();
							var wordVal = _this.$el.find('.' + _this.htmlClassPrefix + 'word-' + wordId).val();

							var cloneDiv = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game-box[data-id="' + wordId + '"]').clone();
							cloneDiv.find('.' + _this.htmlClassPrefix + 'games-find-word-next-btn-block').remove();
							
							cloneDiv.find('.'+_this.htmlClassPrefix+'games-type-find-word-translations').each(function() {
								if($(this).find('.'+_this.htmlClassPrefix+'translation-'+wordId).val() == wordVal){
									$(this).find('label').addClass('true');
								}

								if ($(this).find('.'+_this.htmlClassPrefix+'translation-'+wordId+':checked').val() != wordVal) {
									$(this).find('label').addClass('false');
								}
							});

							if (cloneDiv.find('.no_selected').length == 0 || cloneDiv.find('.no_selected').length == 4) {
								if (cloneDiv.find('.no_selected').length == 0) {
									cloneDiv.find('label[for="' + _this.htmlClassPrefix + 'games-find-word-translation-rad-' + wordId + '-' + wordId + '"]').addClass('no_selected');
								}
								contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-game-box-clone"><fieldset class="ays_pd_fieldset"><legend>You have not answered this question</legend>' + cloneDiv.html() + '</fieldset></div>';
							}else{
								contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-game-box-clone">' + cloneDiv.html() + '</div>';
							}

							if(translationVal == wordVal){
								correct_answer = correct_answer + 1;
							}
						}
						score = (correct_answer / wordsCount) * 100;
						contentClone += '</div>';
						if(score != 0){
							if(Math.round(score) !== score) {
								score = score.toFixed(1);
							}
						}

					break;
					case 'find_translation':
						for(var i = 0; i < nextButtons.length; i++ ){							
							var wordId = $(nextButtons[i]).attr('data-id');
							var wordVal = _this.$el.find('.'+_this.htmlClassPrefix+'word-'+wordId+':checked').val();
							var translationVal = _this.$el.find('.'+_this.htmlClassPrefix+'translation-'+wordId).val();

							var cloneDiv = _this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game-box[data-id="'+wordId+'"]').clone();							
							cloneDiv.find('.'+_this.htmlClassPrefix+'games-find-translation-next-btn-block').remove();							
							
							cloneDiv.find('.'+_this.htmlClassPrefix+'games-type-find-translation-words').each(function() {
								if($(this).find('.'+_this.htmlClassPrefix+'word-'+wordId).val() == translationVal){
									$(this).find('label').addClass('true');
								}

								if ($(this).find('.'+_this.htmlClassPrefix+'word-'+wordId+':checked').val() != translationVal) {
									$(this).find('label').addClass('false');
								}
							});

							if (cloneDiv.find('.no_selected').length == 0 || cloneDiv.find('.no_selected').length == 4) {
								if (cloneDiv.find('.no_selected').length == 0) {
									cloneDiv.find('label[for="' + _this.htmlClassPrefix + 'games-find-word-translation-rad-' + wordId + '-' + wordId + '"]').addClass('no_selected');
								}
								contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-game-box-clone"><fieldset class="ays_pd_fieldset"><legend>You have not answered this question</legend>' + cloneDiv.html() + '</fieldset></div>';
							}else{
								contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-game-box-clone">' + cloneDiv.html() + '</div>';
							}

							if(translationVal == wordVal){
								correct_answer = correct_answer + 1; 
							}
							
						}
						score = (correct_answer / wordsCount) * 100;
						
						contentClone += '</div>';
						if(score != 0){
							if(Math.round(score) !== score) {
								score = score.toFixed(1);
							}
						}
					break;
					case 'matching_words':
						var contentClone = '';
						contentClone += "<div class = 'ays-pd-matching-words-results-page ays-pd-matching-words-parent ays-pd-matching-words-columns'>";					
						var cloneDiv =  $('.'+_this.htmlClassPrefix+'matching-words-columns').clone();
						var labelsArr = cloneDiv.find('label.ays-pd-matching-words-label.ui-sortable-handle');
						cloneDiv.find('.ays-pd-matching-words-sortable').addClass('remove-mouseover');
						cloneDiv.find('.remove-mouseover').css('pointer-events', 'none');
						cloneDiv.find('.ays-pd-matching-words').addClass('');
						var wordsOrderString = $('.'+_this.htmlClassPrefix+'matching-words-hidden-words').val();
						var wordsOrderArr = wordsOrderString.split("*").filter(element => element);
						var translationsOrderString = $('.'+_this.htmlClassPrefix+'matching-words-hidden-translations').val();
						var translationsOrderArr = translationsOrderString.split("*").filter(element => element);
						$('.'+_this.htmlClassPrefix+'matching-words-parent').addClass('ays_display_none');
						for(var i = 0;i < wordsOrderArr.length;i++) {
							for(var j = 0;j < translationsOrderArr.length;j++) {
								if(wordsOrderArr[i] === translationsOrderArr[j] && i == j) {
									correct_answer++;
									var wordId = wordsOrderArr[i];
									var votedId = translationsOrderArr[j];
									_this.updateWord(wordId, gameType, votedId);
									labelsArr.eq(i).addClass('ays-pd-matching-game-correct');
								}
							}
							labelsArr.eq(i).addClass('ays-pd-matching-game-results');		
						}
						
						contentClone += cloneDiv.html();
						contentClone += "</div>";

						score = (correct_answer / wordsCount) * 100;
	
						if(score != 0){
							if(Math.round(score) !== score) {
								score = score.toFixed(1);
							}
						}

						var pdLogoContainer = _this.$el.find('.' + _this.htmlClassPrefix + 'games-logo-block');
						if (pdLogoContainer.length) {
							pdLogoContainer.remove();
						}
						break;
					case 'write_translation':
						for(var i = 0; i < nextButtons.length; i++ ){
							var wordId = $(nextButtons[i]).attr('data-id');
							var answerInp = _this.$el.find('.' + _this.htmlClassPrefix + 'games-write-translation-answer[data-word-id=' + wordId + ']');
							var answer = answerInp.val();
							_this.$el.find('input.' + _this.htmlClassPrefix + 'word-' + wordId + '[name="ays-pd-word[' + wordId + ']"]').val(answer);

							var translationsArr = _this.gameWriteTranslationAnswers;
							var correctAnswerObj = translationsArr.find(translationObj => translationObj.id == wordId);
							var correctTranslation = correctAnswerObj.translation;

							var cloneDiv = _this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game-box[data-id="'+wordId+'"]').clone();
							cloneDiv.find('.'+_this.htmlClassPrefix+'games-find-word-next-btn-block').remove();
							cloneDiv.find('.' + _this.htmlClassPrefix + 'games-write-translation-check-answer').remove();
							cloneDiv.find('.' + _this.htmlClassPrefix + 'games-write-translation-right-answer').remove();
							cloneDiv.find('input.' + _this.htmlClassPrefix + 'word-' + wordId + '[name="ays-pd-word[' + wordId + ']"]').val(correctTranslation);
							var clonedAnswerInp = cloneDiv.find('.' + _this.htmlClassPrefix + 'games-write-translation-answer');
							clonedAnswerInp.prop('disabled', true);
							clonedAnswerInp.attr('value', answer);
							var clonedMainBox = cloneDiv.find('.' + _this.htmlClassPrefix + 'games-write-translation-answer-main-block');

							if ($.trim(answer) == $.trim(correctTranslation)) {
								correct_answer++;
								clonedAnswerInp.addClass(_this.htmlClassPrefix + 'answered-right');
							} else {
								clonedAnswerInp.addClass(_this.htmlClassPrefix + 'answered-wrong');
								var rightAnswerConteiner = $('<div class="' + _this.htmlClassPrefix + 'games-write-translation-right-answer">' + correctTranslation + '</div>');
								clonedMainBox.append(rightAnswerConteiner);
							}

							if ($.trim(answer) == '') {
								contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-game-box-clone"><fieldset class="ays_pd_fieldset"><legend>You have not answered this question</legend>' + cloneDiv.html() + '</fieldset></div>';
							}else{
								contentClone += '<div class="'+_this.htmlClassPrefix+'games-type-content-game-box-clone">' + cloneDiv.html() + '</div>';
							}
						}
						score = (correct_answer / wordsCount) * 100;
						contentClone += '</div>';
						if(score != 0){
							if(Math.round(score) !== score) {
								score = score.toFixed(1);
							}
						}

						_this.gameWriteTranslationAnswers = [];

						break;
					}
			}

			var content = '';
			content += '<div class="ays-pd-games-type-content-game-box ays-pd-finish-game-message" >';
			content += '<p class="ays-pd-finish-game-message-result-score" >'+aysPdLangObj.result+': '+score+'%</p>';
			content += '<p class="ays-pd-finish-game-message-result-count" >'+correct_answer+' / '+wordsCount+'</p>';
			content += '<div class="ays-pd-finish-game-message-reload" >';
			content += '<input type="button" class="ays-pd-finish-game-message-reload-btn" value="Start Again">';
			content += '</div>';
			content += contentClone;
			content += '</div>';
			$(this).parents('.ays-pd-games-type-content-game').append(content);
			
			var res = $(this).parents('.ays-pd-games-type-content-game').serializeFormJSON();
			_this.addGameResults(res);			
		});

		_this.$el.on("click" , '.' + _this.htmlClassPrefix + 'games-write-translation-check-answer', function(e) {
			e.preventDefault();
			var checkBttn = $(this);
			_this.checkWriteTranslationGameAnswer(checkBttn);
		});

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'finish-game-message-reload-btn', function(e) {
			e.preventDefault();
			
			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game').html(''); 
			_this.$el.find('.'+_this.htmlClassPrefix+'games-type-content-game').show(200);
			var selectedGroupsIds = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item').val();
			
			var gameType = _this.$el.find('.'+_this.htmlClassPrefix+'game-type-rad:checked').val();
			var groupWordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item :selected');
			var count = 0;
			
			groupWordsCount.each(function(i, sel){
				count += parseInt($(sel).attr('data-count'));
				
			});			
			
			var dataIds = new Array();
			if(selectedGroupsIds != ''){
				if(count >= 4){
					_this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box').removeClass('ays-pd-games-type-previous-page-btn');
					_this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box').addClass('ays-pd-games-settings-previous-page-btn');

					switch(gameType){
						case 'find_word':
							_this.gameFindWordAjax(selectedGroupsIds,0,dataIds);
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
						case 'find_translation':
							_this.gameFindTranslationAjax(selectedGroupsIds,0,dataIds);
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
						case 'matching_words':
						    _this.gameMatchingWordsAjax(selectedGroupsIds,0,dataIds);
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
						case 'write_translation':
							_this.gameWriteTranslationAjax(selectedGroupsIds, 0, dataIds);
							_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
							break;
					}

				}else{
					_this.$el.find('.'+_this.htmlClassPrefix+'game-settings-message').css('color','red');
				}	
			}else{
				_this.$el.find('.'+_this.htmlClassPrefix+'game-settings-message').css('color','red');			
			}

		});	
		
		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'game-fields', function(e) {
			var checked = _this.$el.find('.'+_this.htmlClassPrefix+'game-fields input:checked');
			// var answersContainer = checked.parents('.' + _this.htmlClassPrefix + 'game-fields-container');
			_this.$el.find('.'+_this.htmlClassPrefix+'game-fields label').addClass('no_selected');
			_this.$el.find('.'+_this.htmlClassPrefix+'game-fields label').removeClass('checked_answer');
			checked.next().removeClass('no_selected');
			checked.next().addClass('checked_answer');
		});

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'close-group-modal', function(event) {
			var hideModalPopup = _this.aysPdGroupsModal('hide');
			_this.$el.find('.'+_this.htmlClassPrefix+'groups-modal-main').hideModalPopup;
			setTimeout(function(){
				_this.$el.find('div.'+_this.htmlClassPrefix+'groups-modal-main').remove();
			}, 250);
		});  

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'confirm-modal-submit', function() {
			window.location.reload();
		});  

		_this.$el.on("change" , 'input[class^="ays-pd-games-answers"]', function(e) {
			if (_this.detectMobileDevice()) {
				if(_this.dbOptions.pd_show_correct_answer_mobile){
					var checked_inputs = $(e.target).parents().eq(1).find('input:checked');
					checked_inputs.next().addClass('answered');
					(checked_inputs.prev().val() == 1) ? checked_inputs.next().addClass('correct') : checked_inputs.next().addClass('wrong');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[name="ays-pd-answer-correct[]"][value="1"]').next().next().addClass('correct answered');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[name="ays-pd-answer-correct[]"][value="1"]').parent().addClass('correct_div').addClass('checked_answer_div');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[class^="ays-pd-games-answers"]').attr('disabled', true);
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[class^="ays-pd-games-answers"]').off('change');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('.ays-pd-game-fields').css({
						'pointer-events': 'none'
					});
					_this.$el.find('.'+_this.htmlClassPrefix+'game-fields label').removeClass('checked_answer');
				}
         	}else{
				if(_this.dbOptions.pd_show_correct_answer){
					var checked_inputs = $(e.target).parents().eq(1).find('input:checked');
					checked_inputs.next().addClass('answered');
					(checked_inputs.prev().val() == 1) ? checked_inputs.next().addClass('correct') : checked_inputs.next().addClass('wrong');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[name="ays-pd-answer-correct[]"][value="1"]').next().next().addClass('correct answered');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[name="ays-pd-answer-correct[]"][value="1"]').parent().addClass('correct_div').addClass('checked_answer_div');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[class^="ays-pd-games-answers"]').attr('disabled', true);
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('input[class^="ays-pd-games-answers"]').off('change');
					$(e.target).parents('div.ays-pd-games-type-content-game-box').find('.ays-pd-game-fields').css({
						'pointer-events': 'none'
					});
					_this.$el.find('.'+_this.htmlClassPrefix+'game-fields label').removeClass('checked_answer');
				}
         	}
			if (!_this.dbOptions.pd_show_next_button) {
				if (!_this.detectMobileDevice()) {
					if (_this.dbOptions.pd_show_correct_answer) {
						setTimeout(function(){
							$(e.target).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'next-button').trigger('click');
						}, 2000);	
					}else{
						$(e.target).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'next-button').trigger('click');				
					}	
				}
			}
			if (!_this.dbOptions.pd_show_next_button_mobile) {
				if (_this.detectMobileDevice()) {
					if (_this.dbOptions.pd_show_correct_answer_mobile) {
						setTimeout(function(){
							$(e.target).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'next-button').trigger('click');
						}, 2000);
					}else{
						$(e.target).parents('.'+_this.htmlClassPrefix+'games-type-content-game-box').find('.'+_this.htmlClassPrefix+'next-button').trigger('click');				
					}
				}
			}
		});

		var currentAudio = null;
		var currentAudioId = null;
		_this.$el.on("click", '.' + _this.htmlClassPrefix + 'games-find-word-audio, .ays-pd-games-write-translation-audio', function(e) {
			var audioSrc = $(this).data('audio'); 
			var audioId = $(this).data('id'); 
			var playIcon = $(this).find('.audio-icon-play');
			var pauseIcon = $(this).find('.audio-icon-pause');

			if (currentAudio) {
				if (currentAudioId === audioId) {  
					if (!currentAudio.paused) {
						currentAudio.pause();  
						playIcon.hide();  
						pauseIcon.show();  
					} else {
						currentAudio.currentTime = 0; 
						currentAudio.play();  
						playIcon.show();  
						pauseIcon.hide();  
					}
				} else { 
					currentAudio.pause();  
					$('.' + _this.htmlClassPrefix + 'games-find-word-audio, .ays-pd-games-write-translation-audio').each(function() {
						$(this).find('.audio-icon-play').show();
						$(this).find('.audio-icon-pause').hide();
					});

					currentAudio = new Audio(audioSrc);
					currentAudio.play();
					currentAudioId = audioId;

					playIcon.show();
					pauseIcon.hide();

					currentAudio.addEventListener("ended", function() {
						playIcon.show();
						pauseIcon.hide();
						currentAudioId = null;
					});
				}
			} else {
				if (audioSrc) {
					currentAudio = new Audio(audioSrc);
					currentAudio.play();
					currentAudioId = audioId;

					playIcon.show();
					pauseIcon.hide();

					currentAudio.addEventListener("ended", function() {
						playIcon.show();
						currentAudioId = null;
					});
				}
			}
		});
		
		function sortWordsInGroup(a, b) {
            return ($(b).text().toUpperCase()) < ($(a).text().toUpperCase()) ? 1 : -1; 
        }

        function sortWordsDescInGroup(a, b) {
            return ($(b).text().toUpperCase()) > ($(a).text().toUpperCase()) ? 1 : -1; 
        }

        function resetSortInGroup(a, b) {
        	return $(b).data("id") - $(a).data("id");
        }

		_this.$el.on("click", '.'+_this.htmlClassPrefix+'header-sort-btn', function() {
			var content = '';
			
			content += '<div>';
			content += '<button class="ays-pd-sort-words-asc">'+'A-Z'+'</button>';
			content += '<button class="ays-pd-sort-words-desc">'+'Z-A'+'</button>';
			content += '<button class="ays-pd-reset-sort">'+aysPdLangObj.defaultSort+'</button>';
			content += '</div>';

			_this.$el.find('.'+_this.htmlClassPrefix+'sort-words-in-group-popup').html(content);
			_this.$el.find('.'+_this.htmlClassPrefix+'sort-words-in-group-popup').css("display", "block");
		})

		_this.$el.on("click", '.'+_this.htmlClassPrefix+'sort-words-asc', function() {
			_this.$el.find('.'+_this.htmlClassPrefix+'words-each-item-block').sort(sortWordsInGroup).appendTo(_this.$el.find('.'+_this.htmlClassPrefix+'tab-content'));
			_this.$el.find('.'+_this.htmlClassPrefix+'tab-content').append(_this.$el.find('.ays-pd-add-group-word-buttons-container'));
			_this.$el.find('.'+_this.htmlClassPrefix+'sort-words-in-group-popup').css("display", "none");
		})

		_this.$el.on("click", '.'+_this.htmlClassPrefix+'sort-words-desc', function() {
			_this.$el.find('.'+_this.htmlClassPrefix+'words-each-item-block').sort(sortWordsDescInGroup).appendTo(_this.$el.find('.'+_this.htmlClassPrefix+'tab-content'));
			_this.$el.find('.'+_this.htmlClassPrefix+'tab-content').append(_this.$el.find('.ays-pd-add-group-word-buttons-container'));
			_this.$el.find('.'+_this.htmlClassPrefix+'sort-words-in-group-popup').css("display", "none");
		})

		_this.$el.on("click", '.'+_this.htmlClassPrefix+'reset-sort', function() {
			$(_this.$el.find('.'+_this.htmlClassPrefix+'words-each-item-block')).sort(resetSortInGroup).appendTo(_this.$el.find('.'+_this.htmlClassPrefix+'tab-content'));
			_this.$el.find('.'+_this.htmlClassPrefix+'tab-content').append(_this.$el.find('.ays-pd-add-group-word-buttons-container'));
			_this.$el.find('.'+_this.htmlClassPrefix+'sort-words-in-group-popup').css("display", "none");
		})

		$(document).on("mouseup", function(e) {
			var container = _this.$el.find('.'+_this.htmlClassPrefix+'sort-words-in-group-popup');
			if (!container.is(e.target) && container.has(e.target).length === 0){
				container.hide();
			}
		});

		_this.$el.on("mouseover touchstart",'.'+_this.htmlClassPrefix+'matching-words-sortable',function(e){
			var sortedArrNode;
			var sortedArr;
			_this.$el.find('.'+_this.htmlClassPrefix+'matching-words-sortable').sortable({
				stop:function(ev,ui) {
					sortedArrNode = $('.ays-pd-matching-words-label input[data-type ="translations"]');
					sortedArr = Array.from(sortedArrNode);
					var string = "*";
					for(var i = 0; i < sortedArr.length;i++) {
						string += $(sortedArr[i]).val() + "*";
					}
					$('.ays-pd-matching-words-hidden-translations').val(string);
				}
			});
		})

		// Flashcards
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcards-group-item').select2({
			placeholder: ''+aysPdLangObj.selectGroup+'',
			dropdownParent: $('.ays-pd-flashcards-select-groups')
		});

		_this.$el.on("click" , '#'+_this.htmlClassPrefix+'flashcards-start-button', function(event) {
			var selectedGroupsIds = _this.$el.find('.'+_this.htmlClassPrefix+'flashcards-group-item').val();

			var groupWordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'flashcards-group-item :selected');
			var count = 0;

			groupWordsCount.each(function(i, sel){
				count += parseInt($(sel).attr('data-count'));
			});

			if(selectedGroupsIds.length === 0) {
				_this.$el.find('#'+_this.htmlClassPrefix+'flashcards-no-group-message').show(200);
				_this.$el.find('#'+_this.htmlClassPrefix+'flashcards-no-words-message').hide(200);
				return;
			} else if (count < 1) {
				_this.$el.find('#'+_this.htmlClassPrefix+'flashcards-no-group-message').hide(200);
				_this.$el.find('#'+_this.htmlClassPrefix+'flashcards-no-words-message').show(200);
				return
			}
			_this.$el.find('#'+_this.htmlClassPrefix+'flashcards-no-group-message').hide(200);
			_this.$el.find('#'+_this.htmlClassPrefix+'flashcards-no-words-message').hide(200);

			_this.$el.find('div.ays-pd-preloader').css('display', 'flex');

			var wordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'flashcards-words-count:checked').val();
			var data = {};
			data.groupsIds = selectedGroupsIds;
			data.wordsCount = wordsCount;
			data.action = _this.ajaxAction;
			data.function = 'ays_pd_get_data_for_flashcards';

			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method:'post',
				data: data,
				success: function(res) {
					if(res.status !== true){ 
						return false;
					}

					var results = res['results'];
					if (!results.length) {
						return false;
					}

					
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					var prevBttn = _this.$el.find('.ays-pd-header-main .ays-pd-header-previous-page-btn-box');
					prevBttn.removeClass('ays_display_none');
					prevBttn.addClass('ays-pd-flashcards-return-to-settings-btn');
					_this.generateFlashCardsContent(results);
					_this.$el.find('.ays-pd-flashcards-settings-content').hide(200);
				}
			});
		});

		// Import
		_this.$el.on('click','.'+_this.htmlClassPrefix+'import-select-file-box', function(e){
			var importFileInp = _this.$el.find('#' + _this.htmlClassPrefix + 'import_file');
			importFileInp.trigger('click');
		});

		_this.$el.on('change','#'+_this.htmlClassPrefix+'import_file', function(e){
            var pattern = /(.xlsx|.XLSX)$/g;
			var importFileInpValue = $(this).val()
            if(pattern.test(importFileInpValue)){
				var text = importFileInpValue.substring(importFileInpValue.lastIndexOf("\\") + 1, importFileInpValue.length);
				_this.$el.find('.'+_this.htmlClassPrefix+'import-select-file-box-text').text(text);
                $(this).parents('form').find('input[name="ays-pd-import-save-btn"]').removeAttr('disabled');
            }
        });
	}

	AysPDPlugin.prototype.setFlashcardEvents = function(e) {
        var _this = this;
		_this.flashcardEventsSetted = true;
		_this.flashcardsDataArr = [];
		_this.knowWordsDataArr = [];
		_this.unknownWordsDataArr = [];

		_this.$el.on('click','.' + _this.htmlClassPrefix + 'flashcards-return-to-settings-btn' ,function(e) {
			e.preventDefault();
			_this.returnToFlashcardsSettingsPage();
        });

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'flashcard-each-word-box', _this.toggleFlashCard);

		_this.$el.on("click" , '.'+_this.htmlClassPrefix+'flashcard-data-box-check-answer', function() {
			_this.toggleFlashCardAnswer($(this));
		});

		$(document).on('keyup',function(event) {
			switch (event.which) {
				case 39: // right arrow (swipe right)
					event.preventDefault();
					$(document).find('.ays-pd-flashcard-data-box-check-answer[data-type="know"]').trigger('click');
					break;
				case 37: // left arrow (swipe left)
					event.preventDefault();
					$(document).find('.ays-pd-flashcard-data-box-check-answer[data-type="dknow"]').trigger('click');
					break;
			}
		});

		var startX, dist;
		_this.$el.on('touchstart', '.ays-pd-flashcard-each-word-box:not(".ays-pd-flashcard-each-word-finish-box")', function (e) {
			dist = 0;
			startX = e.originalEvent.touches[0].pageX;
			e.preventDefault();
		});
		
		_this.$el.on('touchmove', '.ays-pd-flashcard-each-word-box:not(".ays-pd-flashcard-each-word-finish-box")', function (e) {
			dist = e.originalEvent.touches[0].pageX - startX;
			e.preventDefault();
		});

		_this.$el.on('touchend', '.ays-pd-flashcard-each-word-box:not(".ays-pd-flashcard-each-word-finish-box")', function (e) {
			if (dist >= 100) {
				// swipe right
				e.preventDefault();
				_this.$el.find('.ays-pd-flashcard-data-box-check-answer[data-type="know"]').trigger('click');
			} else if (dist <= -100) {
				// swipe left
				e.preventDefault();
				_this.$el.find('.ays-pd-flashcard-data-box-check-answer[data-type="dknow"]').trigger('click');
			} else {
				// No swipe, consider it a click event
				$(this).trigger('click');
			}
        });

		_this.$el.on('click', '.' + _this.htmlClassPrefix + 'flashcard-data-box-prev-button', function() {
			_this.returnToPreviousFlashcard($(this));
		});

		_this.$el.on('click', '.' + _this.htmlClassPrefix + 'flashcard-restart-button', function() {
			_this.$el.find('div.' + _this.htmlClassPrefix + 'flashcards-box').remove();
			_this.resetFlashcardsDataBox();

			// check for restart from 0 or continue current progress
			var newFlashcardsContent = _this.unknownWordsDataArr;
			if ($(this).hasClass(_this.htmlClassPrefix + 'flashcard-finish-restart-from-zero-button')) {
				newFlashcardsContent = _this.flashcardsDataArr;
			}

			_this.generateFlashCardsContent(shuffleArr(newFlashcardsContent));
			_this.resetFlashcardsDataArrays();
		});

		_this.$el.on('click', '.' + _this.htmlClassPrefix + 'flashcard-finish-return-to-settings-button', function() {
			_this.returnToFlashcardsSettingsPage();
		});
	}

	AysPDPlugin.prototype.addGameResults = function(res) {
		var _this = this;
		var gameType = _this.$el.find('.'+_this.htmlClassPrefix+'game-type-rad:checked').val();
		var selectedGroupsIds = _this.$el.find('.'+_this.htmlClassPrefix+'games-group-item').val();
		var data = res;
		data.gameType = gameType;
		data.groupsIds = selectedGroupsIds;
		data.action = _this.ajaxAction;
		data.function = 'ays_pd_add_game_results';
		
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true){
					
				}
			}
		});
	}

	AysPDPlugin.prototype.updateWord = function(wordId, gameType, voted = '', answered = '') {
		var _this = this;
		var data = {};
		data.action = _this.ajaxAction;
		data.wordId = wordId;
		data.voted = voted;
		data.answered = answered;
		data.gameType = gameType;
		data.function = 'ays_pd_update_word';
		
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true){

				}
			}
		});
	}

	AysPDPlugin.prototype.gameFindWordAjax = function(selectedGroupsIds,numberLimit,dataIds) {
		var _this = this;
		
		var wordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-count:checked').val();
		var wordsPercentageFrom = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-from').val();
		var wordsPercentageTo = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-to').val();
		var hiddenCount = _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val();
		var data = {};
		data.groupsIds = selectedGroupsIds;
		data.ids = dataIds;
		data.wordsCount = wordsCount;
		data.number = numberLimit;
		data.wordsPercentageFrom = wordsPercentageFrom;
		data.wordsPercentageTo = wordsPercentageTo;
		data.hiddenCount = hiddenCount;
		data.action = _this.ajaxAction;
		data.function = 'ays_pd_game_find_word';
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true){
					_this.$el.find('.'+_this.htmlClassPrefix+'next-button').attr('disabled',false);
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					var words = (res['results']);
					var counter = '';
					var content = '';
					if(words.length > 0){
						_this.$el.find('.'+_this.htmlClassPrefix+'games-select-groups').hide(200);
						$.each(words,function(index,element){
							if(wordsCount > element.count || wordsCount == 'All'){
								counter = element.count;
							}else{
								counter = wordsCount;
							}	                               				
							numberLimit = parseInt(numberLimit) + 1;
							var audioIcon = '<svg fill="#000000" width="20px" height="20px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.953 2.059c-0.326-0.173-0.721-0.154-1.028 0.053l-10.034 7.878-3.332 0.002c-1.704 0-3.090 1.208-3.090 2.7l0.053 6.598c0 1.486 1.386 2.695 3.089 2.695l3.331 0.002 9.981 7.898c0.168 0.113 0.363 0.171 0.559 0.171 0.161 0 0.323-0.039 0.469-0.117 0.327-0.173 0.532-0.512 0.532-0.883v-26.115c0-0.369-0.204-0.709-0.531-0.883zM16.484 27.176l-8.675-7.016c-0.165-0.111-0.36-0.171-0.559-0.171l-3.637-0.002c-0.642 0-1.090-0.366-1.090-0.702l-0.054-6.598c0-0.328 0.448-0.693 1.090-0.693l3.638-0.002c0.199 0 0.393-0.059 0.558-0.171l8.729-7v22.355zM26.515 16.172c0-2.656-1.826-4.889-4.341-5.309-0.553-0.091-1.061 0.277-1.151 0.822s0.277 1.060 0.822 1.151c1.573 0.262 2.671 1.635 2.671 3.336 0 1.62-1.137 3.021-2.703 3.334-0.542 0.108-0.893 0.634-0.785 1.176 0.095 0.476 0.512 0.805 0.98 0.805 0.064 0 0.131-0.006 0.197-0.020 2.498-0.498 4.312-2.726 4.312-5.296zM25.188 6.997c-0.517-0.192-1.094 0.070-1.286 0.588-0.194 0.517 0.070 1.093 0.587 1.286 3.017 1.126 5.043 4.059 5.043 7.301 0 3.243-2.026 6.183-5.041 7.313-0.517 0.195-0.779 0.77-0.586 1.287 0.151 0.402 0.532 0.649 0.937 0.649 0.117 0 0.235-0.020 0.351-0.064 3.792-1.422 6.34-5.113 6.34-9.186s-2.55-7.759-6.344-9.175z"></path></svg>';
							var audioIconpause = '<svg fill="#000000" width="20px" height="20px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.953 2.059c-0.326-0.173-0.721-0.154-1.028 0.053l-10.034 7.878-3.332 0.002c-1.704 0-3.090 1.208-3.090 2.7l0.053 6.598c0 1.486 1.386 2.695 3.089 2.695l3.331 0.002 9.981 7.898c0.168 0.113 0.363 0.171 0.559 0.171 0.161 0 0.323-0.039 0.469-0.117 0.327-0.173 0.532-0.512 0.532-0.883v-26.115c0-0.369-0.204-0.709-0.531-0.883zM16.484 27.176l-8.675-7.016c-0.165-0.111-0.36-0.171-0.559-0.171l-3.637-0.002c-0.642 0-1.090-0.366-1.090-0.702l-0.054-6.598c0-0.328 0.448-0.693 1.090-0.693l3.638-0.002c0.199 0 0.393-0.059 0.558-0.171l8.729-7v22.355z"></path></svg>';
							content += '<div class="ays-pd-games-type-content-game-box" data-id="'+element.id+'">';
								content += '<p class="ays-pd-games-type-content-game-counter" value="'+numberLimit+'" >' + numberLimit + '/' +  counter +'</p>';
								
								if (element.image) {
									content += '<div class="ays-pd-games-find-word-image ays-pd-games-find-word-media ays-pd-games-images"><img src="'+element.image+'" alt="'+element.word+'"></div>';
								}
								if (element.audio) {
									content += '<div class="ays-pd-games-find-word-audio ays-pd-games-find-word-media" data-audio="' + element.audio + '" data-id="'+element.id+'">';
										content += '<svg class="audio-icon-play" style="width:20px ;height:20px"> ' + audioIcon + '</svg>';
										content += '<svg class="audio-icon-pause" style="display:none;width:20px; height:20px">' + audioIconpause + '</svg>';
									content +='</div>';
								}
								content += '<p class="ays-pd-games-question-para ays-pd-games-find-word" value="'+element.id+'" >' + element.word + '</p>';
								content += '<input type="hidden" class="ays-pd-word-'+element.id+'" name="ays-pd-word['+element.id+']" value="'+element.id+'">';
								content += '<div class="ays-pd-game-fields-container" >';
									for(var i=0;i<element.translations.length;i++){
										var j = i + 1;
										var ays_pd_correct_answer = 0;
										if(element.translations[i][0] == element.id){
											ays_pd_correct_answer = 1;
										}
									content += '<div class="ays-pd-game-fields ays-pd-games-type-find-word-translations" >';
										content += '<input type="hidden"  name="ays-pd-answer-correct[]" value="'+ays_pd_correct_answer+'">';
										content += '<input type="radio" class="ays-pd-games-answers ays-pd-translation-'+element.id+'" name="ays-pd-translation[' +element.id+ ']" id="ays-pd-games-find-word-translation-rad-'+element.id+'-'+element.translations[i][0]+'" value="'+element.translations[i][0]+'">';
										content += '<label for="ays-pd-games-find-word-translation-rad-'+element.id+'-'+element.translations[i][0]+'" >' + element.translations[i][1] + '</label>';
									content += '</div>';
									}
								content += '</div>';
								var nextButtonType = 'button';
								if (_this.detectMobileDevice()) {
									if (!_this.dbOptions.pd_show_next_button_mobile) {
										nextButtonType = 'hidden';
									}
								}else{
									if (!_this.dbOptions.pd_show_next_button) {
										nextButtonType = 'hidden';
									}
								}
								content += '<div class="ays-pd-games-find-word-next-btn-block" >';
								content += '<input type="'+nextButtonType+'" value="Next" class="ays-pd-next-button" data-limit="'+ element.limitNumber +'" data-next="'+numberLimit+'" data-id="'+element.id+'">';
								content += '</div>';
								content += '<input type="hidden" class="ays-pd-hidden-words-count" value="'+counter+'">';
							content += '</div>';
						});

						var gameForm = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game');
						content += _this.generatePdLogo(gameForm);

						gameForm.append(content);

						if(_this.dbOptions.pd_enable_add_image_to_games == 'on'){
							_this.$el.find('.ays-pd-games-find-word-image').show().css('display', 'flex');
						} else {
							_this.$el.find('.ays-pd-games-find-word-image').hide();
						}

						if(_this.dbOptions.pd_enable_add_audio_to_games == 'on'){
							_this.$el.find('.ays-pd-games-find-word-audio').show().css('display', 'flex');
						} else {
							_this.$el.find('.ays-pd-games-find-word-audio').hide();
						}

						if (data.number == 0) {
							var firstPage = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game-box').eq(0);
							var firstPageFieldsContainer = firstPage.find('.' + _this.htmlClassPrefix + 'game-fields-container');
							var fields = firstPageFieldsContainer.find('.' + _this.htmlClassPrefix + 'game-fields label');
			
							var labelHeights = [];
							fields.each(function(index, field) {
								labelHeights.push($(field).outerHeight());
							});
							var maxHeight = Math.max.apply(null, labelHeights);
							fields.css({'min-height': maxHeight});
						}
					}else{
						_this.$el.find('.'+_this.htmlClassPrefix+'game-percentage-issue-message').css('color','red');
					}

				}
			}
		});
	}

	AysPDPlugin.prototype.gameFindTranslationAjax = function(selectedGroupsIds,numberLimit,dataIds) {
		var _this = this;
		
		var wordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-count:checked').val();
		var hiddenCount = _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val();
		var wordsPercentageFrom = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-from').val();
		var wordsPercentageTo = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-to').val();
		var data = {};
		data.groupsIds = selectedGroupsIds;
		data.ids = dataIds;
		data.wordsCount = wordsCount;
		data.number = numberLimit;
		data.hiddenCount = hiddenCount;
		data.wordsPercentageFrom = wordsPercentageFrom;
		data.wordsPercentageTo = wordsPercentageTo;
		data.action = _this.ajaxAction;
		data.function = 'ays_pd_game_find_translation';
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true){
					_this.$el.find('.'+_this.htmlClassPrefix+'next-button').attr('disabled',false);
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					var words = (res['results']);
					var counter = '';
					var content = '';
					if(words.length > 0){
						_this.$el.find('.'+_this.htmlClassPrefix+'games-select-groups').hide(200);
						$.each(words,function(index,element){
							if(wordsCount > element.count || wordsCount == 'All'){
								counter = element.count;
							}else{
								counter = wordsCount;
							}
							numberLimit = parseInt(numberLimit) + 1;
							content += '<div class="ays-pd-games-type-content-game-box" data-id="'+element.id+'">';
							content += '<p class="ays-pd-games-type-content-game-counter" value="'+numberLimit+'" >' + numberLimit + '/' +  counter +'</p>';
							if (element.image) {
								content += '<div class="ays-pd-games-find-translation-image ays-pd-games-find-word-media ays-pd-games-images"><img src="'+element.image+'" alt="'+element.word+'"></div>';
							}
							content += '<p class="ays-pd-games-find-translation" value="'+element.id+'" >' + element.translation + '</p>';
							content += '<input type="hidden" class="ays-pd-translation-'+element.id+'" name="ays-pd-translation['+element.id+']" value="'+element.id+'">';
							content += '<div class="ays-pd-game-fields-container" >';
							for(var i=0;i<element.words.length;i++){
								var j = i + 1;
							var ays_pd_correct_answer = 0;
								if(element.words[i][0] == element.id){
									ays_pd_correct_answer = 1;
								}
						
								content += '<div class="ays-pd-game-fields ays-pd-games-type-find-translation-words" >';
								content += '<input type="hidden"  name="ays-pd-answer-correct[]" value="'+ays_pd_correct_answer+'">';
								content += '<input type="radio" class="ays-pd-games-answers ays-pd-word-'+element.id+'" name="ays-pd-word[' +element.id+ ']" id="ays-pd-games-find-translation-word-rad-'+element.id+'-'+element.words[i][0]+'" value="'+element.words[i][0]+'">';
								content += '<label for="ays-pd-games-find-translation-word-rad-'+element.id+'-'+element.words[i][0]+'" >' + element.words[i][1] + '</label>';
								content += '</div>';
							}
							content += '</div>';
							var nextButtonType = 'button';
							if (_this.detectMobileDevice()) {
								if (!_this.dbOptions.pd_show_next_button_mobile) {
									nextButtonType = 'hidden';
								}
							}else{
								if (!_this.dbOptions.pd_show_next_button) {
									nextButtonType = 'hidden';
								}	
							}
							content += '<div class="ays-pd-games-find-translation-next-btn-block" >';
							content += '<input type="'+nextButtonType+'" value="Next" class="ays-pd-next-button" data-limit="'+ element.limitNumber +'" data-next="'+numberLimit+'" data-id="'+element.id+'">';
							content += '</div>';
							content += '<input type="hidden" class="ays-pd-hidden-words-count" value="'+counter+'">';
							content += '</div>';
						});
						var gameForm = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game');
						content += _this.generatePdLogo(gameForm);

						gameForm.append(content);

						if(_this.dbOptions.pd_enable_add_image_to_games == 'on'){
							_this.$el.find('.ays-pd-games-find-translation-image').show().css('display', 'flex');
						} else {
							_this.$el.find('.ays-pd-games-find-translation-image').hide();
						}
						if (data.number == 0) {
							var firstPage = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game-box').eq(0);
							var firstPageFieldsContainer = firstPage.find('.' + _this.htmlClassPrefix + 'game-fields-container');
							var fields = firstPageFieldsContainer.find('.' + _this.htmlClassPrefix + 'game-fields label');
			
							var labelHeights = [];
							fields.each(function(index, field) {
								labelHeights.push($(field).outerHeight());
							});
							var maxHeight = Math.max.apply(null, labelHeights);
							fields.css({'min-height': maxHeight});
						}
					}else{
						_this.$el.find('.'+_this.htmlClassPrefix+'game-percentage-issue-message').css('color','red');
					}

				}
			}
		});
	}

	AysPDPlugin.prototype.gameMatchingWordsAjax = function(selectedGroupsIds,numberLimit,dataIds) {
		var _this = this;
	
		var wordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-count:checked').val();
		var hiddenCount = _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val();
		var wordsPercentageFrom = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-from').val();
		var wordsPercentageTo = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-to').val();
		var data = {};
		data.groupsIds = selectedGroupsIds;
		data.ids = dataIds;
		data.wordsCount = wordsCount;
		data.number = numberLimit;
		data.hiddenCount = hiddenCount;
		data.wordsPercentageFrom = wordsPercentageFrom;
		data.wordsPercentageTo = wordsPercentageTo;
		data.action = _this.ajaxAction;
		data.function = 'ays_pd_game_matching_words';
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true){
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					var result = (res['results']);
					var words_ordering = '*';
					var translations_ordering = "*";
					var counter = '';
					var content = '';
					if(result.translations && result.translations.length > 0){
						if(wordsCount > result.count || wordsCount == 'All') {
							counter = result.count;
						}

						else {
							counter = wordsCount;
						}
						_this.$el.find('.'+_this.htmlClassPrefix+'games-select-groups').hide(200);
						content += "<div class = 'ays-pd-matching-words-parent '>";
							content += "<div class='ays-pd-matching-words-columns'>";
								content += "<div>";
								for(var i = 0;i < result.words.length;i++) {
									content += "<label class ='ays-pd-matching-words-label'>";
									content += "<input type = 'radio' class = 'ays-pd-matching-words' value = '" + result.words[i][0] +"'>";
									content +=  result.words[i][1] + "</label>";
								}
								content += "</div>";
								content += "<div class = 'ays-pd-matching-words-sortable'>";
								for(var i = 0;i < result.translations.length;i++) {
									content += "<label  class ='ays-pd-matching-words-label'>";
									content += "<input type = 'radio' data-type = 'translations'  class = 'ays-pd-matching-words' value = '" + result.translations[i][0] + "'>";
									content +=  result.translations[i][1]  + "</label>";

								}
								content += "</div>";
							content += "</div>";

						for(var i = 0;i < result.words.length;i++) {
							words_ordering += result.words[i][0] + "*";
						}

						for(var i = 0;i < result.translations.length;i++) {
							translations_ordering += result.translations[i][0] + "*";
						}
						
						content += "<div class = 'ays-pd-matching-words-finish-container'>";
							
							content += "<input type = 'button' class = 'ays-pd-finish'  value = 'finish'>";
						
						content += "</div>";

						content += "<input type = 'hidden' name = 'ays-pd-matching-words-hidden' class = 'ays-pd-matching-words-hidden-words' value = '" + words_ordering + "'>";
						content += "<input type = 'hidden' name = 'ays-pd-matching-translations-hidden' class = 'ays-pd-matching-words-hidden-translations' value = '" + translations_ordering + "'>";
						content += '<input type = "hidden" class = "ays-pd-hidden-words-count" value="' + counter + '">';

						content += "</div>";

						var gameForm = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game');
						content += _this.generatePdLogo(gameForm);

						gameForm.append(content);
						
						_this.$el.find('.' + _this.htmlClassPrefix + 'matching-words-sortable').trigger('mouseover');

						var labelHeights = [];
						_this.$el.find('.' + _this.htmlClassPrefix + 'matching-words-label').each(function() {
							labelHeights.push($(this).outerHeight());
						});
						var maxHeight = Math.max.apply(null, labelHeights);
						_this.$el.find('.' + _this.htmlClassPrefix + 'matching-words-label').css({'min-height': maxHeight});
					}else{
						_this.$el.find('.'+_this.htmlClassPrefix+'game-percentage-issue-message').css('color','red');
					}
				}
			}
		});
	}

	AysPDPlugin.prototype.gameWriteTranslationAjax = function(selectedGroupsIds, numberLimit, dataIds) {
		var _this = this;

		var wordsCount = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-count:checked').val();
		var hiddenCount = _this.$el.find('.'+_this.htmlClassPrefix+'hidden-words-count').val();
		var wordsPercentageFrom = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-from').val();
		var wordsPercentageTo = _this.$el.find('.'+_this.htmlClassPrefix+'games-words-learned-percentage-to').val();

		var data = {};
		data.groupsIds = selectedGroupsIds;
		data.ids = dataIds;
		data.wordsCount = wordsCount;
		data.number = numberLimit;
		data.hiddenCount = hiddenCount;
		data.wordsPercentageFrom = wordsPercentageFrom;
		data.wordsPercentageTo = wordsPercentageTo;
		data.action = _this.ajaxAction;
		data.function = 'ays_pd_game_write_translation';

		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true) {
					_this.$el.find('.'+_this.htmlClassPrefix+'next-button').attr('disabled',false);
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');

					var results = res.results ? res.results : {};
					var words = results.words ? results.words : [];
					shuffleArr(words);

					if ( words.length > 0 ) {
						_this.$el.find('.'+_this.htmlClassPrefix+'games-select-groups').hide(200);
					} else {
						_this.$el.find('.'+_this.htmlClassPrefix+'game-percentage-issue-message').css('color','red');
						return;
					}

					var displayCheckButton = (_this.dbOptions && _this.dbOptions.pd_show_correct_answer) ? _this.dbOptions.pd_show_correct_answer : false;

					var counter = '';
					var content = '';
					$.each(words,function(index,wordObj) {
						if (wordsCount > results.count || wordsCount == 'All') {
							counter = results.count;
						} else {
							counter = wordsCount;
						}
						numberLimit = parseInt(numberLimit) + 1;
						var answerData = {
							id: wordObj.id,
							translation: wordObj.translation
						}
						_this.gameWriteTranslationAnswers.push(answerData);
						var audioIcon = '<svg fill="#000000" width="20px" height="20px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.953 2.059c-0.326-0.173-0.721-0.154-1.028 0.053l-10.034 7.878-3.332 0.002c-1.704 0-3.090 1.208-3.090 2.7l0.053 6.598c0 1.486 1.386 2.695 3.089 2.695l3.331 0.002 9.981 7.898c0.168 0.113 0.363 0.171 0.559 0.171 0.161 0 0.323-0.039 0.469-0.117 0.327-0.173 0.532-0.512 0.532-0.883v-26.115c0-0.369-0.204-0.709-0.531-0.883zM16.484 27.176l-8.675-7.016c-0.165-0.111-0.36-0.171-0.559-0.171l-3.637-0.002c-0.642 0-1.090-0.366-1.090-0.702l-0.054-6.598c0-0.328 0.448-0.693 1.090-0.693l3.638-0.002c0.199 0 0.393-0.059 0.558-0.171l8.729-7v22.355zM26.515 16.172c0-2.656-1.826-4.889-4.341-5.309-0.553-0.091-1.061 0.277-1.151 0.822s0.277 1.060 0.822 1.151c1.573 0.262 2.671 1.635 2.671 3.336 0 1.62-1.137 3.021-2.703 3.334-0.542 0.108-0.893 0.634-0.785 1.176 0.095 0.476 0.512 0.805 0.98 0.805 0.064 0 0.131-0.006 0.197-0.020 2.498-0.498 4.312-2.726 4.312-5.296zM25.188 6.997c-0.517-0.192-1.094 0.070-1.286 0.588-0.194 0.517 0.070 1.093 0.587 1.286 3.017 1.126 5.043 4.059 5.043 7.301 0 3.243-2.026 6.183-5.041 7.313-0.517 0.195-0.779 0.77-0.586 1.287 0.151 0.402 0.532 0.649 0.937 0.649 0.117 0 0.235-0.020 0.351-0.064 3.792-1.422 6.34-5.113 6.34-9.186s-2.55-7.759-6.344-9.175z"></path></svg>';
						var audioIconpause = '<svg fill="#000000" width="20px" height="20px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.953 2.059c-0.326-0.173-0.721-0.154-1.028 0.053l-10.034 7.878-3.332 0.002c-1.704 0-3.090 1.208-3.090 2.7l0.053 6.598c0 1.486 1.386 2.695 3.089 2.695l3.331 0.002 9.981 7.898c0.168 0.113 0.363 0.171 0.559 0.171 0.161 0 0.323-0.039 0.469-0.117 0.327-0.173 0.532-0.512 0.532-0.883v-26.115c0-0.369-0.204-0.709-0.531-0.883zM16.484 27.176l-8.675-7.016c-0.165-0.111-0.36-0.171-0.559-0.171l-3.637-0.002c-0.642 0-1.090-0.366-1.090-0.702l-0.054-6.598c0-0.328 0.448-0.693 1.090-0.693l3.638-0.002c0.199 0 0.393-0.059 0.558-0.171l8.729-7v22.355z"></path></svg>';
						content += '<div class="' + _this.htmlClassPrefix + 'games-type-content-game-box" data-id="' + wordObj.id + '">';
							// question (word)
						    content += '<p class="' + _this.htmlClassPrefix + 'games-type-content-game-counter" value="' + numberLimit + '" >' + numberLimit + '/' +  counter + '</p>';
							if (wordObj.image) {
								content += '<div class="ays-pd-games-write-translation-image ays-pd-games-find-word-media ays-pd-games-images"><img src="'+wordObj.image+'" alt="'+wordObj.word+'"></div>';
							}
							if (wordObj.audio) {
								content += '<div class="ays-pd-games-write-translation-audio ays-pd-games-find-word-media" data-audio="' + wordObj.audio + '" data-id="'+wordObj.id+'">';
									content += '<svg class="audio-icon-play" style="width:20px ;height:20px"> ' + audioIcon + '</svg>';
									content += '<svg class="audio-icon-pause" style="display:none;width:20px; height:20px">' + audioIconpause + '</svg>';
								content +='</div>';
							}
							
							content += '<p class="' + _this.htmlClassPrefix + 'games-question-para ' + _this.htmlClassPrefix + 'games-write-translation" value="' + wordObj.id + '" >' + wordObj.word + '</p>';
							content += '<input type="hidden" class="' + _this.htmlClassPrefix + 'word-' + wordObj.id + '" name="' + _this.htmlClassPrefix + 'word[' + wordObj.id + ']" value="">';

							// input for answer(translation)
							content += '<div class="' + _this.htmlClassPrefix + 'games-write-translation-answer-main-block">';
								content += '<div class="' + _this.htmlClassPrefix + 'games-write-translation-answer-box">';
									content += '<input class="' + _this.htmlClassPrefix + 'games-write-translation-answer" data-word-id="' + wordObj.id + '">';
									if (displayCheckButton) {
										content += '<button class="' + _this.htmlClassPrefix + 'games-write-translation-check-answer">';
											content += aysPdLangObj.check;
										content += '</button>';
									}
								content += '</div>';
							content += '</div>';

							// next/finish button
							content += '<div class="' + _this.htmlClassPrefix + 'games-find-word-next-btn-block" >';
								content += '<input type="button" value="Next" class="' + _this.htmlClassPrefix + 'next-button" data-limit="' + results.limitNumber + '" data-next="' + numberLimit + '" data-id="' + wordObj.id + '">';
							content += '</div>';
							content += '<input type="hidden" class="' + _this.htmlClassPrefix + 'hidden-words-count" value="' + counter + '">';
						content += '</div>';
					})
					var gameForm = _this.$el.find('.' + _this.htmlClassPrefix + 'games-type-content-game');
					content += _this.generatePdLogo(gameForm);

					gameForm.append(content);

					if(_this.dbOptions.pd_enable_add_image_to_games == 'on'){
						_this.$el.find('.ays-pd-games-write-translation-image').show().css('display', 'flex');
					} else {
						_this.$el.find('.ays-pd-games-write-translation-image').hide();
					}

					if(_this.dbOptions.pd_enable_add_audio_to_games == 'on'){
						_this.$el.find('.ays-pd-games-write-translation-audio').show().css('display', 'flex');
					} else {
						_this.$el.find('.ays-pd-games-write-translation-audio').hide();
					}

					_this.$el.find('.' + _this.htmlClassPrefix + 'games-write-translation-answer').focus();
				}
			}
		});
	}

	AysPDPlugin.prototype.checkWriteTranslationGameAnswer = function(checkBttn) {
		var _this = this;

		var answerBox = checkBttn.parents('.' + _this.htmlClassPrefix + 'games-write-translation-answer-box');
		var answerInp = answerBox.find('input.' +  _this.htmlClassPrefix + 'games-write-translation-answer');
		var answer = answerInp.val()
		if (answer == '') {
			return;
		}

		var wordId = answerInp.attr('data-word-id');
		var translationsArr = _this.gameWriteTranslationAnswers;
		var correctAnswerObj = translationsArr.find(translationObj => translationObj.id == wordId);
		var correctTranslation = correctAnswerObj.translation;

		answerInp.attr('disabled', 'disabled');
		checkBttn.fadeOut(500, function() {
            checkBttn.remove();
        });

		if (answer == correctTranslation) {
			answerInp.addClass(_this.htmlClassPrefix + 'answered-right');
		} else {
			answerInp.addClass(_this.htmlClassPrefix + 'answered-wrong');
			var mainBox = answerBox.parents('.' + _this.htmlClassPrefix + 'games-write-translation-answer-main-block');
			var rightAnswerConteiner = $('<div class="' + _this.htmlClassPrefix + 'games-write-translation-right-answer" style="display: none;">' + correctTranslation + '</div>');

			mainBox.append(rightAnswerConteiner);
			rightAnswerConteiner.slideDown(500);
		}
	}

	AysPDPlugin.prototype.generateGroupsSearchBox = function() {
		var _this = this;
		var searchContainer = _this.$el.find('.'  + _this.htmlClassPrefix + 'search-groups-container');
		if (searchContainer.find('#' + _this.htmlClassPrefix + 'group-search').length > 0) {
			return;
		}

		var searchInput = '<input type="text" id="' + _this.htmlClassPrefix + 'group-search" placeholder="' + aysPdLangObj.searchGroup + '">';
		var closeBttn  = '<svg width="24px" height="24px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path fill="#000000" d="M195.2 195.2a64 64 0 0 1 90.496 0L512 421.504 738.304 195.2a64 64 0 0 1 90.496 90.496L602.496 512 828.8 738.304a64 64 0 0 1-90.496 90.496L512 602.496 285.696 828.8a64 64 0 0 1-90.496-90.496L421.504 512 195.2 285.696a64 64 0 0 1 0-90.496z"></path></g></svg>';

		var searchBox = '';
		searchBox += '<div class="' + _this.htmlClassPrefix + 'group-search-box">'
			searchBox += searchInput;
			searchBox += '<div class="' + _this.htmlClassPrefix + 'remove-group-search-box">'
				searchBox += closeBttn;
			searchBox += '</div>'
		searchBox += '</div>';

		searchContainer.slideDown('fast', function() {
			searchContainer.append(searchBox);
        });
	}

	AysPDPlugin.prototype.removeGroupsSearchBox = function() {
		var _this = this;
		var searchContainer = _this.$el.find('.'  + _this.htmlClassPrefix + 'search-groups-container');
		var searchBox = searchContainer.find('.'  + _this.htmlClassPrefix + 'group-search-box');
		searchContainer.slideUp('fast', function() {
            searchBox.remove();
        });

		var groupItems = _this.$el.find('.' + _this.htmlClassPrefix + 'each_group_item');
		$.each(groupItems, function(index, groupItem) {
			var $groupItem = $(groupItem);
			$groupItem.removeClass('ays_display_none');
		})
	}

	AysPDPlugin.prototype.aysPDSearchGroup = function(searchInp) {
		var _this = this;

		var groupItems = _this.$el.find('.' + _this.htmlClassPrefix + 'each_group_item');
		var query = searchInp.val().toLowerCase();

		if (!query.length) {
			$.each(groupItems, function(index, groupItem) {
			var $groupItem = $(groupItem);
				$groupItem.removeClass('ays_display_none');
			})

			return;
		}

		$.each(groupItems, function(index, groupItem) {
			var $groupItem = $(groupItem);
			$groupItem.addClass('ays_display_none');

			var groupName = $groupItem.find('p.ays-pd_each_group_name').text();
			if (groupName.indexOf(query) >= 0) {
				$groupItem.removeClass('ays_display_none');
			}
		})

	}

	AysPDPlugin.prototype.generateWordSearchBox = function() {
		var _this = this;
		var searchContainer = _this.$el.find('.'  + _this.htmlClassPrefix + 'search-word-container');
		if (searchContainer.find('#' + _this.htmlClassPrefix + 'word-search').length > 0) {
			return;
		}

		var searchInput = '<input type="text" id="' + _this.htmlClassPrefix + 'word-search" placeholder="'+ aysPdLangObj.search + '">';
		var closeBttn  = '<svg width="24px" height="24px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path fill="#000000" d="M195.2 195.2a64 64 0 0 1 90.496 0L512 421.504 738.304 195.2a64 64 0 0 1 90.496 90.496L602.496 512 828.8 738.304a64 64 0 0 1-90.496 90.496L512 602.496 285.696 828.8a64 64 0 0 1-90.496-90.496L421.504 512 195.2 285.696a64 64 0 0 1 0-90.496z"></path></g></svg>';
		var searchBox = '';
		searchBox += '<div class="' + _this.htmlClassPrefix + 'word-search-box">'
			searchBox += searchInput;
			searchBox += '<div class="' + _this.htmlClassPrefix + 'remove-word-search-box">'
				searchBox += closeBttn;
			searchBox += '</div>'
		searchBox += '</div>';
		
		searchContainer.slideDown('fast', function() {
			searchContainer.append(searchBox);
        });
	}

	AysPDPlugin.prototype.removeWordSearchBox = function() {
		var _this = this;
		var searchContainer = _this.$el.find('.'  + _this.htmlClassPrefix + 'search-word-container');
		var searchBox = searchContainer.find('.'  + _this.htmlClassPrefix + 'word-search-box');
		searchContainer.slideUp('fast', function() {
            searchBox.remove();
        });

		var wordItems = _this.$el.find('.' + _this.htmlClassPrefix + 'each_word_item');
		$.each(wordItems, function(index, wordItem) {
			var $wordItem = $(wordItem);
			$wordItem.removeClass('ays_display_none');
		})
	}
	
	AysPDPlugin.prototype.aysPDSearchWord = function(searchInp) {
		var _this = this;

		var wordItems = _this.$el.find('.' + _this.htmlClassPrefix + 'words-each-item-block');
		var query = searchInp.val().toLowerCase();
		if (!query.length) {
			$.each(wordItems, function(index, wordItem) {
				var $wordItem = $(wordItem);
					$wordItem.removeClass('ays_display_none');
				})
			return;
		}

		$.each(wordItems, function(index, wordItem) {
			var $wordItem = $(wordItem);
			
			var wordName = $wordItem.find('span.ays-pd-each_word_span').text().toLowerCase();;
			var translationName = $wordItem.find('span.ays-pd-each_translation').text().toLowerCase();
			$wordItem.addClass('ays_display_none');
			if (wordName.indexOf(query) >= 0 || translationName.indexOf(query) >= 0) {
				$wordItem.removeClass('ays_display_none');
			}
		})

	}
	AysPDPlugin.prototype.groupsDeleteAjax = function(catId) {
		var _this = this;
		var groupName = $('.'+_this.htmlClassPrefix+'group-name-inp').val();
		var dataCatId = catId;	
		if(catId != undefined){
			_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
			var data = {};
			data.action = _this.ajaxAction;
			data.catId = dataCatId;
			data.function = 'ays_groups_delete_ajax';

			
			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method:'post',
				data: data,
				success: function(res) {
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					
					_this.$el.find('.'+_this.htmlClassPrefix+'group-tab').show();
					_this.selectGroupsAjax();
					
				},error: function(err){
					console.log(err);
				}
			});

		}
	}

	AysPDPlugin.prototype.groupResetAjax = function(catId) {
		var _this = this;
		if(catId != undefined){
			_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
			var data = {};
			data.action = _this.ajaxAction;
			data.catId = catId;
			data.function = 'ays_group_reset_ajax';

			
			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method:'post',
				data: data,
				success: function(res) {
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					
					_this.$el.find('.'+_this.htmlClassPrefix+'group-tab').show();
					_this.selectGroupsAjax();
					
				},error: function(err){
					console.log(err);
				}
			});

		}
	}

	AysPDPlugin.prototype.wordsDeleteAjax = function(wordId) {
		var _this = this;
		var word = $('.'+_this.htmlClassPrefix+'word_field').val();
		var thisCatId = _this.$el.find('.ays-pd-tab-content').attr('data-catid');
		if(wordId != undefined){
			_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
			var data = {};
			data.action = _this.ajaxAction;
			data.wordId = wordId;
			data.function = 'ays_words_delete_ajax';

			
			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method:'post',
				data: data,
				success: function(res) {
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					
					_this.$el.find('.'+_this.htmlClassPrefix+'group-tab').show();
					_this.selectWordsAjax(thisCatId);
					
				},error: function(err){
					console.log(err);
				}
			});

		}
	}

	AysPDPlugin.prototype.wordResetAjax = function(wordId) {
		var _this = this;
		var word = $('.'+_this.htmlClassPrefix+'word_field').val();
		var thisCatId = _this.$el.find('.ays-pd-tab-content').attr('data-catid');
		if(wordId != undefined){
			_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
			var data = {};
			data.action = _this.ajaxAction;
			data.wordId = wordId;
			data.function = 'ays_word_reset_ajax';

			
			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method:'post',
				data: data,
				success: function(res) {
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					
					_this.$el.find('.'+_this.htmlClassPrefix+'group-tab').show();
					_this.selectWordsAjax(thisCatId);
					
				},error: function(err){
					console.log(err);
				}
			});

		}
	}

    AysPDPlugin.prototype.selectGroupsAjax = function() {
        var _this = this;
		_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
		var data = {};
		var dataFunction = _this.$el.find('.ays-pd-tab-content').attr('data-function');
		data.action = _this.ajaxAction;
		data.function = dataFunction;

		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status === true){
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					switch ( data.function ) {
						case 'ays_groups_pd':
							var groups = res['results'];
							var content = '';
							var addGroupIcon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" class="ays-pd-icon-main-color-fill" ><path d="M21.8906 9.89062H14.1094V2.10938C14.1094 0.944391 13.165 0 12 0C10.835 0 9.89062 0.944391 9.89062 2.10938V9.89062H2.10938C0.944391 9.89062 0 10.835 0 12C0 13.165 0.944391 14.1094 2.10938 14.1094H9.89062V21.8906C9.89062 23.0556 10.835 24 12 24C13.165 24 14.1094 23.0556 14.1094 21.8906V14.1094H21.8906C23.0556 14.1094 24 13.165 24 12C24 10.835 23.0556 9.89062 21.8906 9.89062Z"/></svg>';
							content += '<div>';
							if( groups.length > 0 ){
								$.each(groups,function(index,element){
									var percentage = 0;
									var w_count = 0;
									if(element.percentage != 0){
										percentage = element.percentage;
										if(Math.round(percentage) !== percentage) {
											percentage = percentage.toFixed(1);
										}
									}
									if(element.w_count != undefined){
										w_count = element.w_count;
									}
									content += '<div class="ays-pd-each_group_item" data-id="' + element.id + '" >';
									content += '<div class="ays-pd-groups-box" data-id="' + element.id + '">';
									content += '<div class="ays-pd-each-group-title">'
									content += '<p class="ays-pd_each_group_name">' + element.name + '</p>';
									content += '<p class="ays-pd_each_group_title_words_count"> ('+w_count+') </p>';
									content += '</div>';
									content += '<div class="ays-pd-groups_progress_bar_icons">';
									content += '<div class="ays-pd-groups_line_percentage_bar">';
									content += '<div class="ays-pd-groups_line_percentage_bar_size" style="width:'+percentage+'%">';
									content += '<span class="ays-pd-groups_line_percentage_span"> ' + percentage + ' %</span>';
									content += '</div>';
									content += '</div>';
									content += '<div class="ays-pd-icon-buttons ays-pd-each_group_icons">';
									content += '<a class="ays-pd-group-edit-btn" title="Edit Title">' + aysPersonalDictionaryAjaxPublic.icons.edit_icon + '</a>';
									content += '<a class="ays-pd-group-more-btn">' + aysPersonalDictionaryAjaxPublic.icons.more_icon + '</a>';
									content += '<div class="ays-pd-dropdown-buttons ays-pd-group-dropdown-menu">';
									content += '<div><button class="ays-pd-group-reset-btn">'+aysPdLangObj.reset+'</button>';
									content += '<button class="ays-pd-group-delete-button-item">'+aysPdLangObj.delete+'</button></div>';

									content += '</div>';
									content += '</div>';
									content += '</div>';
									content += '</div>';

									content += '<div class="ays-pd-group-edit-layer" data-function="ays_groups_pd">';
									content += '</div>';

									content += '</div>';
								});
								content += '<div class="ays-pd-add-group-word-buttons-container">';
									content += '<div class="ays-pd-add_group_btn">' + addGroupIcon + '</div>';
									content += '<span>'+aysPdLangObj.addGroup+'</span>'
								content += '</div>';
							}else{
								content += '<div class="ays-pd-empty-groups-content">';
									content += '<div class="ays-pd-add_group_btn">' + addGroupIcon + '</div>';
									content += '<p class="ays-pd-add-group-text">' + aysPdLangObj.createFirstGroup + '</p>';
								content += '</div>';
							}
							content += '</div>';
							
                            _this.$el.find('.ays-pd-tab-content').html(content);
						break;
						case 'ays_games_pd':
							var result = res['results'];
							var content = '';
							content += '<div class="ays-pd-games-select-groups">';
								content += '<select class="ays-pd-games-settings-item ays-pd-games-group-item" multiple>';
									$.each(result,function(index,element){
										var words_count = 0;
										if(element.words_count != 0 && element.words_count != undefined){
											words_count = parseInt(element.words_count);
										}
										content += '<option value="'+ element.id +'" data-count="'+words_count+'">'+element.name+' ('+words_count+')</option>';									
									});
								content += '</select>';
								content += '<div class="ays-pd-game-settings-message" >';
									content += '<p class="ays-pd-game-settings-message-paragraph" >'+ aysPdLangObj.settingsMessage +'</p>' ;	
								content += '</div>';

								content += '<div class="ays-pd-game-percentage-issue-message" >';
									content += '<p class="ays-pd-game-percentage-issue-message-paragraph" >'+aysPdLangObj.intervalMessage+'</p>' ;	
								content += '</div>';
							
								content += '<div class="ays-pd-games-settings-item ays-pd-games-check-words-count" >';	
									content += '<label class="' + _this.htmlClassPrefix + 'form-check-label ' + _this.htmlClassPrefix + 'form-check-label-active">';
										content += '<input class="ays-pd-games-words-count" type="radio" name="words-count-rad" value="10" checked>';
										content += '<span>10</span>';
									content += '</label>';
									content += '<label class="' + _this.htmlClassPrefix + 'form-check-label">';
										content += '<input class="ays-pd-games-words-count" type="radio" name="words-count-rad" value="30">';
										content += '<span>30</span>';
									content += '</label>';
									content += '<label class="' + _this.htmlClassPrefix + 'form-check-label">';
										content += '<input class="ays-pd-games-words-count" type="radio" name="words-count-rad" value="50">';
										content += '<span>50</span>';
									content += '</label>';
									content += '<label class="' + _this.htmlClassPrefix + 'form-check-label">';
										content += '<input class="ays-pd-games-words-count" type="radio" name="words-count-rad" value="100">';
										content += '<span>100</span>';
									content += '</label>';
									content += '<label class="' + _this.htmlClassPrefix + 'form-check-label">';
										content += '<input class="ays-pd-games-words-count" type="radio" name="words-count-rad" value="All">';
										content += '<span>' + aysPdLangObj.all + '</span>';
									content += '</label>';
								content += '</div>';

								content += '<div class="ays-pd-games-settings-item ays-pd-games-words-learned-percentage" >';
									content += '<div>'+aysPdLangObj.learnedPoints+' %</div>';
									content += '<label class="' + _this.htmlClassPrefix + 'form-input-label ' + _this.htmlClassPrefix + 'form-input-label-first">';
										content += '<span>' + aysPdLangObj.from + '</span>';
										content += '<input class="ays-pd-games-words-learned-percentage-from" type="number" name="ays-pd-games-words-learned-percentage-from" value="0" min="0" max="100">';
									content += '</label>';
									content += '<label class="' + _this.htmlClassPrefix + 'form-input-label">';
										content += '<span>' + aysPdLangObj.to + '</span>';
										content += '<input class="ays-pd-games-words-learned-percentage-to" type="number" name="ays-pd-games-words-learned-percentage-to" value="100" min="0" max="100">';
									content += '</label>';
								content += '</div>';

								content += '<div class="ays-pd-games-settings-item ays-pd-games-start-btn-block" >';	
									content += '<input type="button" value="Start" id="ays-pd-games-start-button">';	
								content += '</div>';
							content += '</div>';
							_this.$el.find('.ays-pd-games-type-content-settings').html(content);
							_this.$el.find('.'+_this.htmlClassPrefix+'games-group-item').select2({
								placeholder: ''+aysPdLangObj.selectGroup+'',
								dropdownParent: $('.ays-pd-games-select-groups')
							});
							break;
						case 'ays_pd_get_groups':
							var result = res['results'];
							var content = '';
							$.each(result,function(index,element){
								var words_count = 0;
								if(element.words_count != 0 && element.words_count != undefined){
									words_count = parseInt(element.words_count);
								}
								content += '<option value="'+ element.id +'" data-count="'+words_count+'">'+element.name+' ('+words_count+')</option>';
							});

							_this.$el.find('select.' + _this.htmlClassPrefix + 'flashcards-group-item').html(content);
							break;
					}
				}
			}
		});
    }

    AysPDPlugin.prototype.selectWordsAjax = function(catId) {
        var _this = this;
        _this.$el.find('.ays-pd-add_group_btn').hide(150);

		var topBttns = _this.$el.find('.ays-pd-header-main .ays-pd-header-btn-box');
		topBttns.each(function() {
			$(this).removeClass('ays_display_none');
			if ($(this).hasClass(_this.htmlClassPrefix + 'header-search-group-btn-box')) {
				$(this).addClass('ays_display_none');
			}
		});
		_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
        _this.$el.find('.'+_this.htmlClassPrefix+'group-tab').attr('data-catId',catId);
        var data = {};
        data.action = _this.ajaxAction;
        data.catId = catId;
        data.function = 'ays_show_words_ajax';
        
        $.ajax({
            url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
            dataType: 'json',
            method:'post',
            data: data,
            success: function(res) {
				_this.$el.find('div.ays-pd-preloader').css('display', 'none');

                var words = res['results'];

				if( typeof res['results'] != 'undefined' && res['results'].length > 0){
					if( words[1] !== null ){
						_this.$el.find('.'+_this.htmlClassPrefix+'header-main h3').html(words[1] + ' ('+words[0].length+')');
					}
				}
				var content = '';
				var content = '<div>';
				if( typeof res['results'] != 'undefined' && res['results'].length > 0){
					if (words[0].length > 0) {
						$.each(words[0], function (index, element) {
							var percentage = 0;
							if (parseFloat(element.percentage) != 0 && element.percentage != null) {
								percentage = parseFloat(element.percentage);
								if (Math.round(percentage) !== percentage) {
									percentage = percentage.toFixed(1);
								}
							}
							content += '<div class="ays-pd-words-each-item-block" data-id="' + element.id + '">';
							content += '<div class="ays-pd-words-box" data-id="' + element.id + '">';
							content += '<p class="ays-pd-each_word_item" data-id="' + element.id + '" >';
							content += '<span class="ays-pd-each_word_span"> ' + element.word + ' </span>';
							content += '<span class="ays-pd-each_translation"> ' + element.translation + ' </span>';
							content += '</p>';
							content += '<div class="ays-pd-groups_progress_bar_icons">';
							content += '<div class="ays-pd-groups_line_percentage_bar">';
							content += '<div class="ays-pd-groups_line_percentage_bar_size" style="width:' + percentage + '%">';
							content += '<span class="ays-pd-groups_line_percentage_span">' + percentage + ' %</span>';
							content += '</div>';
							content += '</div>';
							content += '<div class="ays-pd-icon-buttons ays-pd-each_words_icons">';
							content += '<a class="ays-pd-word-edit-btn">' + aysPersonalDictionaryAjaxPublic.icons.edit_icon + '</a>';
							content += '<a class="ays-pd-word-more-btn">' + aysPersonalDictionaryAjaxPublic.icons.more_icon + '</a>';
							content += '<div class="ays-pd-dropdown-buttons ays-pd-word-dropdown-menu">';
							content += '<div><button class="ays-pd-word-reset-btn">' + aysPdLangObj.reset + '</button>';
							content += '<button class="ays-pd-word-delete-button-item">' + aysPdLangObj.delete + '</button>';
							content += '<button class="ays-pd-word-move-button-item" data-word-id="' + element.id + '" data-group-id="' + data.catId + '">' + aysPdLangObj.move + '</button></div>';
							content += '</div>';
							content += '</div>';
							content += '</div>';
							content += '</div>';
					
							content += '<div class="ays-pd-group-tab-edit-layer" data-function="ays_groups_pd">';
							content += '</div>';
					
							content += '</div>';
					
							if (element.image || element.audio) {
								var attachmentData = {};
								attachmentData.action = _this.ajaxAction;
								attachmentData.attachment_image_id = element.image || '';  
								attachmentData.attachment_audio_id = element.audio || ''; 
								attachmentData.function = 'get_attachment_details';
					
								$.ajax({
									url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
									method: 'POST',
									dataType: 'json',
									data: attachmentData,
									success: function (response) {
										if (response.success) {
											var imageTitleSpan = "";
											var audioTitleSpan = "";
											var wordItemBlock = $('div[data-id="' + element.id + '"]');																	
											if(response.data.image){
												if (response.data.image.mime_type.startsWith('image/')) {
													imageTitleSpan = '<span class="ays-pd-each_image_span" href="'+ response.data.image.guid + '" hidden>' + response.data.image.title + '</span>';
													if (imageTitleSpan) {
														wordItemBlock.find('.ays-pd-each_word_item').append(imageTitleSpan);
													}
												}
											}
											if(response.data.audio){
												if (response.data.audio.mime_type.startsWith('audio/')) {
													audioTitleSpan = '<span class="ays-pd-each_audio_span" href="'+ response.data.audio.guid + '" hidden>' + response.data.audio.title + '</span>';
													if (audioTitleSpan) {
														wordItemBlock.find('.ays-pd-each_word_item').append(audioTitleSpan);
													}
												}
											}
										}
									},error: function(err){
										console.log(err);
									}
								});
							}
							
						});
						var addWordIcon = '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" class="ays-pd-icon-main-color-fill"><path d="M21.8906 9.89062H14.1094V2.10938C14.1094 0.944391 13.165 0 12 0C10.835 0 9.89062 0.944391 9.89062 2.10938V9.89062H2.10938C0.944391 9.89062 0 10.835 0 12C0 13.165 0.944391 14.1094 2.10938 14.1094H9.89062V21.8906C9.89062 23.0556 10.835 24 12 24C13.165 24 14.1094 23.0556 14.1094 21.8906V14.1094H21.8906C23.0556 14.1094 24 13.165 24 12C24 10.835 23.0556 9.89062 21.8906 9.89062Z"/></svg>';

						content += '<div class="ays-pd-add-group-word-buttons-container ays_pd_add_word_button ays-pd-add_word_button_under_words_list">';
							content += '<div class="ays-pd-add_word_btn"><span class="ays-pd-add-group-word-plus-btn">' + addWordIcon + '</span><span>'+aysPdLangObj.addWord+'</span></div>';
						content += '</div>';
					} else{
						var addWordIcon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" class="ays-pd-icon-main-color-fill"><path d="M21.8906 9.89062H14.1094V2.10938C14.1094 0.944391 13.165 0 12 0C10.835 0 9.89062 0.944391 9.89062 2.10938V9.89062H2.10938C0.944391 9.89062 0 10.835 0 12C0 13.165 0.944391 14.1094 2.10938 14.1094H9.89062V21.8906C9.89062 23.0556 10.835 24 12 24C13.165 24 14.1094 23.0556 14.1094 21.8906V14.1094H21.8906C23.0556 14.1094 24 13.165 24 12C24 10.835 23.0556 9.89062 21.8906 9.89062Z"/></svg>';
						
						content += '<div class="ays-pd-empty-groups-content">';
							content += '<div class="ays-pd-add_word_btn">' + addWordIcon + '</div>';
							content += aysPdLangObj.createFirstWord;
						content += '</div>';
					}
				}
				content += '</div>';
				_this.$el.find('.'+_this.htmlClassPrefix+'tab-content').html(content);		
            },error: function(err){
                console.log(err);
            }
        });
    }

    AysPDPlugin.prototype.wordsSaveAjax = function(attachmentId) {
            var _this = this;

			var thisCatId = _this.$el.find('.ays-pd-tab-content').attr('data-catid');
			var dataCommand = _this.$el.find('.'+_this.htmlClassPrefix+'words_save_btn').attr('data-command');	
			var dataWordId =  _this.$el.find('.'+_this.htmlClassPrefix+'words_save_btn').attr('data-wordid');	
			var word = $('.'+_this.htmlClassPrefix+'word_field').val();
			var translation = $('.'+_this.htmlClassPrefix+'translation_field').val();
			var image =  $('.'+_this.htmlClassPrefix+'input_image').val();
			var audio =  $('.'+_this.htmlClassPrefix+'input_audio').val();

			if(image === '' || image === null || image === undefined){
				var dataImageID = "";
			} else {
				var dataImageID = $('.'+_this.htmlClassPrefix+'upload-image-ready-url-link').attr('data-id');
			}
			if(audio === '' || audio === null || audio === undefined){
				var dataAudioID = "";
			} else {
				var dataAudioID = $('.'+_this.htmlClassPrefix+'upload-audio-ready-url-link').attr('data-id');
			}
			
			if (dataCommand === 'edit') {
				word = _this.$el.find('.' + _this.htmlClassPrefix + 'edit_word_field').val();
				translation = _this.$el.find('.' + _this.htmlClassPrefix + 'edit_translation_field').val();
				var image =  $('.'+_this.htmlClassPrefix+'edit_input_image').val();
				var audio =  $('.'+_this.htmlClassPrefix+'edit_input_audio').val();
				if(image === '' || image === null || image === undefined){
					dataImageID = "";
				} else {
					dataImageID = _this.$el.find('.' + _this.htmlClassPrefix + 'edit-upload-image-ready-url-link').last().attr('data-id');
				}
				if(audio === '' || audio === null || audio === undefined){
					dataAudioID = "";
				} else {
					dataAudioID = _this.$el.find('.' + _this.htmlClassPrefix + 'edit-upload-audio-ready-url-link').last().attr('data-id'); 
				}
			} 
			
			if(word != ''){
				_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
				var catId = parseInt(_this.$el.find('.'+_this.htmlClassPrefix+'group-tab').attr('data-catId'));
				var data = {};
				data.action = _this.ajaxAction;
				data.word = word;
				data.command = dataCommand;
				data.wordId = dataWordId;
				data.translation = translation;
				data.category_id = catId;
				data.imageID = dataImageID;
				data.audioID = dataAudioID;
				data.function = 'ays_words_add_ajax';
				
				$.ajax({
					url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
					dataType: 'json',
					method:'post',
					data: data,
					success: function(res) {
						_this.$el.find('div.ays-pd-preloader').css('display', 'none');

						_this.$el.find('.'+_this.htmlClassPrefix+'group-tab').show();
						_this.selectWordsAjax(thisCatId);					
						
					},error: function(err){
						console.log(err);
					}
				});

			}
    }

	AysPDPlugin.prototype.mediaDelete = function(mediaType) {
		var _this = this;
		var thisCatId = _this.$el.find('.ays-pd-tab-content').attr('data-catid');
		var dataCommand = _this.$el.find('.' + _this.htmlClassPrefix + 'words_save_btn').attr('data-command');    
		var wordId = _this.$el.find('.' + _this.htmlClassPrefix + 'words_save_btn').attr('data-wordid');    
	
		if (dataCommand === 'edit' && wordId !== undefined) {

			var data = {
				action: _this.ajaxAction,
				wordId: wordId,
				mediaType: mediaType, 
				function: 'ays_media_delete_ajax'
			};
	
			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method: 'POST',
				data: data,
				success: function(res) {
				},
				error: function(err) {
					console.error(err);
				}
			});
		}
	};
	
	
	
	AysPDPlugin.prototype.uploadFile = function(data, mainBox, fileName, isEdit) {
		var _this = this;
		$.ajax({
			url: window.aysPersonalDictionaryAjaxPublic.ajaxUrl,
			method: 'post',
			dataType: 'json',
			data: data,
			contentType: false,
			processData: false,
			success: function (response) {
				if (response.status) {
					if (response.results.fileType.startsWith('image/')) {
						var loader = mainBox.find('.ays-pd-image-loader');
						if(!isEdit){
							var imageNameBox = mainBox.find('.' + _this.htmlClassPrefix + 'upload-image-ready-box');
							var imageNameLink = imageNameBox.find('.' + _this.htmlClassPrefix + 'upload-image-ready-link');
							var imageHiddenInput = imageNameBox.find('.' + _this.htmlClassPrefix + 'upload-image-ready-url-link');
							var imagename = response.results.fileUrl.split('/').pop();					
							mainBox.find('.' + _this.htmlClassPrefix + 'upload-image-button').hide();						
						} else {
							var imageNameBox = mainBox.find('.' + _this.htmlClassPrefix + 'edit-upload-image-ready-box');
							var imageNameLink = imageNameBox.find('.' + _this.htmlClassPrefix + 'edit-upload-image-ready-link');
							var imageHiddenInput = imageNameBox.find('.' + _this.htmlClassPrefix + 'edit-upload-image-ready-url-link');
							var imagename = response.results.fileUrl.split('/').pop();
							mainBox.find('.' + _this.htmlClassPrefix + 'edit-upload-image-button').hide();
						}
						mainBox.find('.ays-pd-image-fields-parent').removeClass('disabled').prop('disabled', false);	
						imageNameLink.html(imagename);
						imageNameLink.attr("download", fileName);
						imageNameLink.attr("href", response.results.fileUrl);
						imageHiddenInput.val(response.results.fileUrl);
						imageHiddenInput.attr("data-id", response.results.attachmentId);
						imageHiddenInput.attr("data-image-url", imagename);
						imageNameBox.show();
					}
					if (response.results.fileType.startsWith('audio/')) {
						var loader = mainBox.find('.ays-pd-audio-loader');
						if(!isEdit){
							var audioNameBox = mainBox.find('.' + _this.htmlClassPrefix + 'upload-audio-ready-box');
							var audioNameLink = audioNameBox.find('.' + _this.htmlClassPrefix + 'upload-audio-ready-link');
							var audioHiddenInput = audioNameBox.find('.' + _this.htmlClassPrefix + 'upload-audio-ready-url-link');
							var audioname = response.results.fileUrl.split('/').pop();																											
							mainBox.find('.' + _this.htmlClassPrefix + 'upload-audio-button').hide();
						} else {
							var audioNameBox = mainBox.find('.' + _this.htmlClassPrefix + 'edit-upload-audio-ready-box');
							var audioNameLink = audioNameBox.find('.' + _this.htmlClassPrefix + 'edit-upload-audio-ready-link');
							var audioHiddenInput = audioNameBox.find('.' + _this.htmlClassPrefix + 'edit-upload-audio-ready-url-link');
							var audioname = response.results.fileUrl.split('/').pop();																	
							mainBox.find('.' + _this.htmlClassPrefix + 'edit-upload-audio-button').hide();					
						}
						mainBox.find('.ays-pd-audio-fields-parent').removeClass('disabled').prop('disabled', false);	
						audioNameLink.html(audioname);
						audioNameLink.attr("download", fileName);
						audioNameLink.attr("href", response.results.fileUrl);
						audioHiddenInput.val(response.results.fileUrl);
						audioHiddenInput.attr("data-id", response.results.attachmentId);
						audioHiddenInput.attr("data-audio-url", audioname);
						audioNameBox.show();
					}
							
				}
				loader.css('display', 'none');
			}
		});
	};
	
	
	AysPDPlugin.prototype.groupsSaveAjax = function() {
		var _this = this;

		var groupName = $('.'+_this.htmlClassPrefix+'group-name-inp').val();
		var dataCommand = _this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').attr('data-command');	
		var dataCatId =  _this.$el.find('.'+_this.htmlClassPrefix+'save_group_button').attr('data-catid');	

		if(groupName != ''){
			_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
			var data = {};
			data.action = _this.ajaxAction;
			data.value = groupName;
			data.command = dataCommand;
			data.catId = dataCatId;
			data.function = 'ays_groups_add_ajax';
			
			$.ajax({
				url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
				dataType: 'json',
				method:'post',
				data: data,
				success: function(res) {
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					_this.selectGroupsAjax();
					_this.$el.find('.'+_this.htmlClassPrefix+'save-groups-block').hide(250);
					
				},error: function(err){
					console.log(err);
				}
			});
		}
	}

	AysPDPlugin.prototype.groupsShowPopupAjax = function(elem) {
        var _this = this;
		var currentWordId = elem.word_id;
		var currentGroupId = elem.group_id;
		var data = {};
		data.action = _this.ajaxAction;
		data.function = 'ays_groups_pd';
		var groupsModal = "<div class='ays-pd-groups-modal-main' id='ays-pd-groups-modal-main-container'>" +
								"<div class='ays-pd-groups-modal-content'>" +
									"<div class='ays-pd-groups-modal-header'>" +
										"<span class='ays-pd-close-group-modal' id='ays-pd-groups-modal-modal'>&times;</span>" +
										"<span style='font-weight: bold;'>"+aysPdLangObj.groups+"</span>" +
									"</div>" +
									"<div class='ays-pd-groups-modal-body' id='ays-pd-groups-modal-body'></div>" +
								"</div>" +
							"</div>";
		_this.$el.find('div.ays-pd-preloader').css('display', 'flex');
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				var popupContent = "";
				popupContent = ""
				if(res.status){
					_this.$el.find('div.ays-pd-preloader').css('display', 'none');
					_this.$el.append(groupsModal);
					var showFunction = _this.aysPdGroupsModal('show');
					_this.$el.find('.'+_this.htmlClassPrefix+'groups-modal-main').showFunction;
					var groups = res['results'];
					var content = '';
					if( groups.length > 0 ){
						content += '<div>';
						$.each(groups,function(index,element){
							if(currentGroupId != element.id){
								content += '<div class="ays-pd-each_group_item-move" data-id="' + element.id + '" >';
									content += '<div class="ays-pd-groups-box-move" data-id="' + element.id + '" data-word-id="'+currentWordId+'">';
										content += '<div class="ays-pd-each-group-title-move">'
											content += '<p class="ays-pd_each_group_name-move">' + element.name + '</p>';
										content += '</div>';
									content += '</div>';
								content += '</div>';
							}
							else {
								content += '<div>';
									content += '<p class="ays-pd_not_group_found_message">' + "Groups count must be over than 2" + '</p>';
								content += '</div>';
							}
						});
					content += '</div>';
						_this.$el.find('.'+_this.htmlClassPrefix+'groups-modal-body').html(content);
					}
				}
					
				},error: function(err){
					console.log(err);
				}
			});
	}

	AysPDPlugin.prototype.moveWordToGroupajax = function(elem) {
        var _this = this;
        var currentGroupName = elem.group_name;
		var data = {};
		data.action = _this.ajaxAction;
		data.function = 'ays_pd_move_word_to_group';
		data.group_id = elem.group_id;
		data.word_id  = elem.word_id;
		$.ajax({
			url: aysPersonalDictionaryAjaxPublic.ajaxUrl,
			dataType: 'json',
			method:'post',
			data: data,
			success: function(res) {
				if(res.status){
					if(res.moved_to_group){
						var confirmModal = "";
						_this.$el.find('.'+_this.htmlClassPrefix+'groups-modal-main').remove();
						confirmModal += "<div class='"+_this.htmlClassPrefix+"confirm-modal-main' id='"+_this.htmlClassPrefix+"confirm-modal-main-container'>";
							confirmModal += "<div class='"+_this.htmlClassPrefix+"confirm-modal-content'>";
								confirmModal += "<div class='"+_this.htmlClassPrefix+"confirm-modal-content-inner'>";
									confirmModal += "<div class='"+_this.htmlClassPrefix+"confirm-modal-header'>";
										confirmModal += "<p class='"+_this.htmlClassPrefix+"confirm-modal-header-inner'>"+aysPdLangObj.moved_to+" <strong>"+currentGroupName+"</strong> "+aysPdLangObj.group+"</p>";
									confirmModal += "</div>";
									confirmModal += "<div class='"+_this.htmlClassPrefix+"confirm-modal-body'>";
										confirmModal += "<button class='"+_this.htmlClassPrefix+"confirm-modal-submit'>OK</button>";
									confirmModal += "</div>";
								confirmModal += "</div>";
							confirmModal += "</div>";
						confirmModal += "</div>";
						_this.$el.append(confirmModal);
					}
				}
					
			},error: function(err){
				console.log(err);
			}
		});
	}

	AysPDPlugin.prototype.generatePdLogo = function(container) {
		var _this = this;

		var logoBlock = container.find('.' + _this.htmlClassPrefix + 'games-logo-block')
		var isLogoAlreadyExist = logoBlock.length;
		if (isLogoAlreadyExist) {
			logoBlock.remove();
		}

		var logoContent = '';
		if (_this.dbOptions.pd_add_logo != '') {
			logoContent += '<div class="ays-pd-games-logo-block" style="justify-content:'+_this.dbOptions.pd_logo_position+';">';
				if (_this.dbOptions.pd_enable_logo_url) {
					var pd_logo_url_new_tab = _this.dbOptions.pd_logo_url_new_tab ? '_blank' : '_self';
					logoContent += '<a href="' + _this.dbOptions.pd_logo_image_url + '" target="' + pd_logo_url_new_tab + '">';
						logoContent += '<img class="ays-pd-games-logo-img" src="' + _this.dbOptions.pd_add_logo + '" alt="' + _this.dbOptions.pd_logo_title + '" title="' + _this.dbOptions.pd_logo_title + '">';
					logoContent += '</a>';								
				} else {
					logoContent += '<img class="ays-pd-games-logo-img" src="' + _this.dbOptions.pd_add_logo + '">';								
				}
			logoContent += '</div>';
		}

		return logoContent;
	}

	AysPDPlugin.prototype.generateFlashCardsContent = function(wordsArr) {
		var _this = this;
		var content = '';
		var wordsCount = wordsArr.length;
		var counter = 0;
		content += '<div class="' + _this.htmlClassPrefix + 'flashcards-box" data-words-count="' + wordsCount + '">';
			// flashcards
			for (let i = 0; i < wordsCount; i++) {
				var wordData = wordsArr[i];
				var word = wordData.word;
				var wordId = wordData.id;
				var translation = wordData.translation;

				var is_active_flashcard = (counter == 0) ? _this.htmlClassPrefix + 'flashcard-active' : '';
				
				content += '<div class="' + _this.htmlClassPrefix + 'flashcard-each-word-box ays-pd-flashcard-each-word-box-key-' + i + ' ' + is_active_flashcard + '" data-index="' + i + '" data-word-id="' + wordId + '">';
					content += '<div class="' + _this.htmlClassPrefix + 'flashcard-word-part ' + _this.htmlClassPrefix + 'flashcard-box-parts ' + _this.htmlClassPrefix + 'flashcard-box-parts-active">';
						content += word;
					content += '</div>';
					content += '<div class="' + _this.htmlClassPrefix + 'flashcard-translation-part ' + _this.htmlClassPrefix + 'flashcard-box-parts">';
						content += translation;
					content += '</div>';
				content += '</div>';

				counter++;
			}

			// finish page
			var bttnTextColor = typeof _this.dbOptions.pd_button_text_color != 'undefined' ? _this.dbOptions.pd_button_text_color : '';

			var tailSpinSvg = '<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg"><defs><linearGradient x1="8.042%" y1="0%" x2="65.682%" y2="23.865%" id="a"><stop stop-color="#222" stop-opacity="0" offset="0%"/><stop stop-color="#222" stop-opacity=".631" offset="63.146%"/><stop stop-color="#222" offset="100%"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><g transform="translate(1 1)"><path d="M36 18c0-9.94-8.06-18-18-18" id="Oval-2" stroke="url(#a)" stroke-width="2"><animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="0.9s" repeatCount="indefinite" />	</path>	<circle fill="#222" cx="36" cy="18" r="1"><animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="0.9s" repeatCount="indefinite" /></circle></g></g></svg>';
			var continueSvg = '<svg width="20px" height="20px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="' + bttnTextColor + '" stroke="' + bttnTextColor + '"><g stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path fill-rule="evenodd" clip-rule="evenodd" d="M4 2H3V14H4V2ZM7.29062 2.59314L6.5 3.00001V13L7.29062 13.4069L14.2906 8.40687V7.59314L7.29062 2.59314ZM13.1398 8.00001L7.5 12.0284V3.9716L13.1398 8.00001Z"></path></g></svg>';
			var restartSvg = '<svg fill="' + bttnTextColor + '" width="20px" height="20px" viewBox="-3 5 22 22" version="1.1" xmlns="http://www.w3.org/2000/svg" stroke="' + bttnTextColor + '"><g stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <title>restart</title> <path d="M15.88 13.84c-1.68-3.48-5.44-5.24-9.040-4.6l0.96-1.8c0.24-0.4 0.080-0.92-0.32-1.12-0.4-0.24-0.92-0.080-1.12 0.32l-1.96 3.64c0 0-0.44 0.72 0.24 1.040l3.64 1.96c0.12 0.080 0.28 0.12 0.4 0.12 0.28 0 0.6-0.16 0.72-0.44 0.24-0.4 0.080-0.92-0.32-1.12l-1.88-1.040c2.84-0.48 5.8 0.96 7.12 3.68 1.6 3.32 0.2 7.32-3.12 8.88-1.6 0.76-3.4 0.88-5.080 0.28s-3.040-1.8-3.8-3.4c-0.76-1.6-0.88-3.4-0.28-5.080 0.16-0.44-0.080-0.92-0.52-1.080-0.4-0.080-0.88 0.16-1.040 0.6-0.72 2.12-0.6 4.36 0.36 6.36s2.64 3.52 4.76 4.28c0.92 0.32 1.84 0.48 2.76 0.48 1.24 0 2.48-0.28 3.6-0.84 4.16-2 5.92-7 3.92-11.12z"></path> </g></svg>';
			var returnSvg = '<svg width="20px" height="20px" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><g stroke-width="0"></g><g stroke-linecap="round" stroke-linejoin="round"></g><g> <path d="M12.9998 8L6 14L12.9998 21" stroke="' + bttnTextColor + '" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M6 14H28.9938C35.8768 14 41.7221 19.6204 41.9904 26.5C42.2739 33.7696 36.2671 40 28.9938 40H11.9984" stroke="' + bttnTextColor + '" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>';

			content += '<div class="' + _this.htmlClassPrefix + 'flashcard-each-word-box ' + _this.htmlClassPrefix + 'flashcard-each-word-finish-box">';
				content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-loader">';
					content += tailSpinSvg;
				content += '</div>';
				content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-chart-box">';
				content += '</div>';
				content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-congratulation-box" style="display:none">';
					content += '<p>' + aysPdLangObj.congratulations + '</p>'
				content += '</div>';
				content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-buttons-box ' + _this.htmlClassPrefix + 'flashcards-display-none">';
					content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-restart-button-box">';
						content += '<button class="' + _this.htmlClassPrefix + 'flashcard-finish-restart-button ' + _this.htmlClassPrefix + 'flashcard-restart-button">';
							content += continueSvg;
							content += aysPdLangObj.continueLearning;
						content += '</button>';
					content += '</div>';
					content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-restart-from-zero-button-box">';
						content += '<button class="' + _this.htmlClassPrefix + 'flashcard-finish-restart-from-zero-button ' + _this.htmlClassPrefix + 'flashcard-restart-button">';
							content += restartSvg;
							content += aysPdLangObj.restart;
						content += '</button>';
					content += '</div>';
					content += '<div class="' + _this.htmlClassPrefix + 'flashcard-finish-return-to-settings-button-box" style="display:none; margin-top: 10px">';
						content += '<button class="' + _this.htmlClassPrefix + 'flashcard-finish-return-to-settings-button">';
							content += returnSvg;
							content += aysPdLangObj.returnToFlashcardsSettings;
						content += '</button>';
					content += '</div>';
				content += '</div>';
			content += '</div>';

		content += '</div>';

		_this.$el.find('.ays-pd-flashcard-box').append(content);
		_this.$el.find('.ays-pd-flashcard-data-all-questions-count').text(wordsCount);

		var progressBarPercentStep = (100/(wordsCount + 1)).toFixed(2);
		var progressBarPercent = progressBarPercentStep + '%';
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcard-data-progress-bar-inner').css('width', progressBarPercent).attr('data-percent', progressBarPercentStep);

		_this.$el.find('.'+_this.htmlClassPrefix+'flashcards-content-main').show(200);

		if (!_this.flashcardEventsSetted) {
			_this.setFlashcardEvents();
		}
	}

	AysPDPlugin.prototype.returnToFlashcardsSettingsPage = function() {
		var _this = this;

		var headerBttns = _this.$el.find('.' + _this.htmlClassPrefix + 'header-main .ays-pd-header-btn-box');
		headerBttns.addClass('ays_display_none');

		_this.resetFlashcardsDataArrays();
		_this.resetFlashcardsDataBox();

		_this.$el.find('.'+_this.htmlClassPrefix+'flashcards-content-main').hide(200);
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcards-box').remove();
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcards-settings-content').show(200);
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcards-group-item').val(null).trigger('change');
		_this.$el.find('.' + _this.htmlClassPrefix + 'header-main h3').text(aysPdLangObj.flashcards);

		_this.$el.find('div.ays-pd-preloader').css('display', 'none');
	}

	AysPDPlugin.prototype.resetFlashcardsDataBox = function() {
		var _this = this;

		_this.$el.find('.'+_this.htmlClassPrefix+'flashcard-data-words-count-text').text(1);
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcard-data-box-prev-button').addClass(_this.htmlClassPrefix+'flashcard-data-box-prev-button-disabled');
		_this.$el.find('.'+_this.htmlClassPrefix+'flashcard-data-buttons-box').removeClass(_this.htmlClassPrefix+'flashcard-data-buttons-box-disabled');
	}

	AysPDPlugin.prototype.resetFlashcardsDataArrays = function() {
		var _this = this;
		_this.flashcardsDataArr = [];
		_this.knowWordsDataArr = [];
		_this.unknownWordsDataArr = [];
	}

	AysPDPlugin.prototype.toggleFlashCard = function() {
		var _this = $(this);
		var aysPdFlashcardWord = _this.find('.ays-pd-flashcard-word-part');
		var aysPdFlashcardTranslation = _this.find('.ays-pd-flashcard-translation-part');

		if ( aysPdFlashcardWord.hasClass('ays-pd-flashcard-box-parts-active') ) {
			_this.css('transform','rotateX(179deg)');

			aysPdFlashcardWord.removeClass('ays-pd-flashcard-box-parts-active');
			aysPdFlashcardWord.hide();
			aysPdFlashcardTranslation.addClass('ays-pd-flashcard-box-parts-active');
			aysPdFlashcardTranslation.show(100);

		} else if(aysPdFlashcardTranslation.hasClass('ays-pd-flashcard-box-parts-active')) {
			_this.css('transform','rotateX(0deg)');

			aysPdFlashcardTranslation.removeClass('ays-pd-flashcard-box-parts-active');
			aysPdFlashcardTranslation.hide();
			aysPdFlashcardWord.addClass('ays-pd-flashcard-box-parts-active');
			aysPdFlashcardWord.show(100);
		}
	}

	AysPDPlugin.prototype.toggleFlashCardAnswer = function(checkedAnswer) {
		var _this = this;

		// Check the time between events. return if time is less than 400ms
		if ( _this.flashCardAnswerToggleTime && (Date.now() - _this.flashCardAnswerToggleTime < 400) ) {
			return;
		}

		var buttonType = checkedAnswer.attr('data-type');
		var mainBox = checkedAnswer.parents('.ays-pd-flashcards-content-main');
		var flashcardsBox = mainBox.find('.ays-pd-flashcards-box');
		var wordsCount = Number( flashcardsBox.attr('data-words-count') );
		var activeWord = mainBox.find('.ays-pd-flashcard-each-word-box.ays-pd-flashcard-active');

		var index = activeWord.attr('data-index');
		if ( isNaN(index) ) {
			return;
		}

		var wordId = activeWord.attr('data-word-id');
		var word = activeWord.find('.ays-pd-flashcard-word-part').text();
		var translation = activeWord.find('.ays-pd-flashcard-translation-part').text();
		var currentFleshCardData = {
			id: wordId,
			word: word,
			translation: translation,
		};
		_this.flashcardsDataArr.push(currentFleshCardData);
		if (buttonType === 'know') {
			_this.knowWordsDataArr.push(currentFleshCardData);
		} else {
			_this.unknownWordsDataArr.push(currentFleshCardData);
		}

		var $thisFlashcard = mainBox.find('.ays-pd-flashcard-each-word-box-key-' + index);

		index++;

		var animationPos = '-=50';
		var rotatePos = '-2deg';
		var clonedClass = 'ays-pd-flashcards-box-cloned-dknow';
		if(buttonType == 'know'){
			animationPos = '+=50';
			rotatePos = '+2deg';
			clonedClass = 'ays-pd-flashcards-box-cloned-know';
		}

		var ifFinished = (index >= wordsCount) ? true : false;
		if(ifFinished){
			mainBox.find('.ays-pd-flashcard-each-word-finish-box').addClass('ays-pd-flashcard-active');
			_this.submitFleshcardFinishForm(mainBox);
		} else {
			var clonedFlashcard = $thisFlashcard.clone();
			clonedFlashcard.addClass(clonedClass);
			mainBox.find('.ays-pd-flashcards-main-inner-container').append(clonedFlashcard);
			clonedFlashcard.animate({
				left: animationPos,
				rotate: rotatePos,
				opacity: '0.5'
			} , 400, function(){
				clonedFlashcard.remove()
			});
		}
		$thisFlashcard.removeClass('ays-pd-flashcard-active');

		mainBox.find('.ays-pd-flashcard-data-box-prev-button-box').attr('data-prev-word', wordId);
		mainBox.find('.ays-pd-flashcard-data-box-prev-button').removeClass('ays-pd-flashcard-data-box-prev-button-disabled');				
		if( index == 0 || ifFinished){
			mainBox.find('.ays-pd-flashcard-data-box-prev-button').addClass('ays-pd-flashcard-data-box-prev-button-disabled');				
		}

		var nextPage = index + 1;
		if(!ifFinished){
			mainBox.find('.ays-pd-flashcard-data-words-count-text').text(nextPage);
		}

		var percentStep = mainBox.find('.ays-pd-flashcard-data-progress-bar-inner').attr('data-percent');
		var passedPercent = percentStep * nextPage;
		mainBox.find('.ays-pd-flashcard-data-progress-bar-inner').css('width' , passedPercent + '%');

		setTimeout(function(){
			mainBox.find('.ays-pd-flashcard-each-word-box-key-' + index).addClass('ays-pd-flashcard-active');
		}, 400);

		_this.flashCardAnswerToggleTime = Date.now();
	}

	AysPDPlugin.prototype.returnToPreviousFlashcard = function(prevFlashcardBttn) {
		var _this = this;
		var mainBox = prevFlashcardBttn.parents('.ays-pd-flashcards-content-main');
		var activeWord = mainBox.find('.ays-pd-flashcard-each-word-box.ays-pd-flashcard-active');
		var index = activeWord.attr('data-index');
		var wordId = activeWord.attr('data-word-id');
		var $thisFlashcard = mainBox.find('.ays-pd-flashcard-each-word-box-key-' + index);
		index--;

		var clonedFlashcard = $thisFlashcard.clone();
		clonedFlashcard.css({
			'position': 'absolute',
			'background-color': '#fff',
			'top': 0,
			'margin': 0,
		});
		mainBox.find('.ays-pd-flashcards-main-inner-container').append(clonedFlashcard);
		clonedFlashcard.animate({
			left: '+=100',
		}, 350, function() {
			clonedFlashcard.remove()
		});
		
		if (index == 0) {
			prevFlashcardBttn.addClass('ays-pd-flashcard-data-box-prev-button-disabled');
		}
		$thisFlashcard.removeClass('ays-pd-flashcard-active');

		var currentPage = index + 1;
		mainBox.find('.ays-pd-flashcard-data-words-count-text').text(currentPage);
		var percentStep = mainBox.find('.ays-pd-flashcard-data-progress-bar-inner').attr('data-percent');
		var passedPercent = percentStep * currentPage;
		mainBox.find('.ays-pd-flashcard-data-progress-bar-inner').css('width' , passedPercent + '%');

		mainBox.find('.ays-pd-flashcard-each-word-box-key-' + index).addClass('ays-pd-flashcard-active');
		mainBox.find('.ays-pd-flashcard-each-word-box-key-' + index).css('opacity' , '1');

		_this.flashcardsDataArr.pop();

		var prevWordId = mainBox.find('.ays-pd-flashcard-data-box-prev-button-box').attr('data-prev-word');
		mainBox.find('.ays-pd-flashcard-data-box-prev-button-box').attr('data-prev-word', wordId);

		if (_this.unknownWordsDataArr.length && _this.unknownWordsDataArr[_this.unknownWordsDataArr.length - 1].id == prevWordId) {
			_this.unknownWordsDataArr.pop();
			return;
		}
		_this.knowWordsDataArr.pop();
	}

	AysPDPlugin.prototype.submitFleshcardFinishForm = function(mainBox) {
		var _this = this;
		var finishBox = mainBox.find('.ays-pd-flashcard-each-word-finish-box');
		var finishBttnsBox = finishBox.find('.ays-pd-flashcard-finish-buttons-box');
		mainBox.find('.ays-pd-flashcard-data-buttons-box').addClass('ays-pd-flashcard-data-buttons-box-disabled');
		finishBox.addClass('ays-pd-flashcard-each-word-finish-box-finished');

		finishBox.find('.ays-pd-flashcard-finish-loader').hide();
		finishBttnsBox.removeClass('ays-pd-flashcards-display-none');

		if ( !(_this.unknownWordsDataArr).length ) {
			finishBox.find('.ays-pd-flashcard-finish-congratulation-box').show();
			finishBttnsBox.find('.ays-pd-flashcard-finish-restart-button-box').hide();
			finishBttnsBox.find('.ays-pd-flashcard-finish-return-to-settings-button-box').show();
		} else {
			var knowedWordsCount = (_this.knowWordsDataArr).length;
			var unknownWordsCount = (_this.unknownWordsDataArr).length;;
			var wordsChartData = {
				knowedWords: knowedWordsCount,
				unknownWords: unknownWordsCount,
			};

			_this.drawFlashcardResultchart(finishBox, wordsChartData);
		}

	}

	AysPDPlugin.prototype.drawFlashcardResultchart = function (container, chartData){
		var chartBox = container.find('.ays-pd-flashcard-finish-chart-box');
		var settableBox = typeof chartBox[0] != 'undefined' && chartBox[0] ? chartBox[0] : '';

		if(settableBox){
			google.charts.load("current", {packages:["corechart"]});
			google.charts.setOnLoadCallback(drawChart);
			
			function drawChart() {
				var resData = [
					['TOTAL' , "COUNT"],
					['Know' , chartData.knowedWords],
					['Still learning' , chartData.unknownWords],
				];
				var data = google.visualization.arrayToDataTable(resData);
				var options = {
					backgroundColor: 'transparent',
					width: 300,
					height: 150,
					pieHole: 0.6,
					pieSliceText: 'none',
					fontSize: 13,
					legend: {
						position: 'labeled',
					},
					tooltip: {
						trigger: 'none',
					},
					chartArea: {
						width: '80%',
						height: '80%'
					}
				};
	
				var chart = new google.visualization.PieChart( settableBox );		
				chart.draw(data, options);
			}
		}
	}

	AysPDPlugin.prototype.toggleFullscreen = function(elem) {
		var isIOS = navigator.userAgent.match(/(iPod|iPhone|iPad)/);
		if (isIOS) {
			alert(aysPdLangObj.fullScreenNotAllowed);
			return;
		}

		elem = elem || document.documentElement;

		if (!document.fullscreenElement && !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) {
			if (elem.requestFullscreen) {
				elem.requestFullscreen();
			}else if (elem.msRequestFullscreen) {
				elem.msRequestFullscreen();
			}else if (elem.mozRequestFullScreen) {
				elem.mozRequestFullScreen();
			}else if (elem.webkitRequestFullscreen) {
				elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
			}
		}else{
			if(document.exitFullscreen) {
				document.exitFullscreen();
			}else if (document.msExitFullscreen) {
				document.msExitFullscreen();
			}else if (document.mozCancelFullScreen) {
				document.mozCancelFullScreen();
			}else if (document.webkitExitFullscreen) {
				document.webkitExitFullscreen();
			}
		}
	}

	AysPDPlugin.prototype.goTo = function() {
        $('html, body').animate({
            scrollTop: this.$el.offset().top - 110 + 'px'
        }, 'fast');
        return this; // for chaining...
    }

	AysPDPlugin.prototype.detectMobileDevice = function() {
		var a;
	   if (navigator.userAgent.match(/Android/i)
			|| navigator.userAgent.match(/webOS/i)
			|| navigator.userAgent.match(/iPhone/i)
			|| navigator.userAgent.match(/iPad/i)
			|| navigator.userAgent.match(/iPod/i)
			|| navigator.userAgent.match(/BlackBerry/i)
			|| navigator.userAgent.match(/Windows Phone/i)) {
		   a = true;
		} else {
		   a = false;
		}
	   return a;
   	}

    AysPDPlugin.prototype.aysPdGroupsModal = function(action){
        var _this = this;
        switch(action){
            case 'hide':
				setTimeout(function(){
					_this.$el.css("position" , "static");
                    _this.$el.removeClass('modal-open');
                    _this.$el.find('.ays-pd-modal-backdrop').remove();
                    _this.$el.find('.ays-pd-groups-modal-main').hide();
                }, 250);
                break;
            case 'show':
            default:
				_this.$el.css("position" , "relative");
                _this.$el.find('.ays-pd-groups-modal-main').show();
                _this.$el.find('.modal-backdrop').remove();
                _this.$el.append('<div class="ays-pd-modal-backdrop"></div>');
                _this.$el.addClass('modal-open');
                break;
        }
    }
	AysPDPlugin.prototype.aysAnimateStep = function(animation, currentPage, nextPage) {
		var left, opacity, scale; //fieldset properties which we will animate
		var animating; //flag to prevent quick multi-click glitches 
		if (nextPage) {
			switch(animation) {
				case "shake":
					currentPage.animate({opacity: 0}, {
						step: function (now, mx) {
							scale = 1 - (1 - now) * 0.2;
							left = (now * 50) + "%";
							opacity = 1 - now;
							currentPage.css({
								'transform': 'scale(' + scale + ')',
								'position': 'absolute',
								'top':0,
								'opacity': 1,
								'pointer-events': 'none'
							});
							nextPage.css({
								'left': left, 
								'opacity': opacity,
								'display':'block',
								'position':'relative',
								'pointer-events': 'none'
							});
						},
						duration: 800,
						complete: function () {
							currentPage.hide();
							currentPage.css({                        
								'pointer-events': 'auto',
								'opacity': 1,
								'position': 'static'
							});
							nextPage.css({
								'display':'block',
								'position':'relative',
								'transform':'scale(1)',
								'opacity': 1,
								'pointer-events': 'auto'
							});
							animating = false;
						},
						easing: 'easeInOutBack'
					});
					break;
				case "fade":
						currentPage.animate({opacity: 0}, {
							step: function (now, mx) {
								opacity = 1 - now;
								currentPage.css({
									'position': 'absolute',
									'pointer-events': 'none'
								});
								nextPage.css({
									'opacity': opacity,
									'position':'relative',
									'display':'flex',
									'pointer-events': 'none'
								});
							},
							duration: 500,
							complete: function () {
								currentPage.hide();
								currentPage.css({                        
									'pointer-events': 'auto',
									'position': 'static'
								});
								nextPage.css({
									'display':'flex',
									'position':'relative',
									'transform':'scale(1)',
									'opacity': 1,
									'pointer-events': 'auto'
								});
								animating = false;
							}
						});
						break;
				default:				
					currentPage.animate({}, {
						step: function (now, mx) {
							currentPage.css({
								'pointer-events': 'none'
							});
							nextPage.css({
								'position':'relative',
								'pointer-events': 'none'
							});
						},
						duration: 0,
						complete: function () {
							currentPage.hide();
							currentPage.css({                        
								'pointer-events': 'auto'
							});
							nextPage.css({
								'display':'block',
								'position':'relative',
								'transform':'scale(1)',
								'pointer-events': 'auto'
							});
							animating = false;
						}
					});
					break;
			}
		} else {
			switch(animation){
				case "shake":
					currentPage.animate({opacity: 0}, {
						step: function (now, mx) {
							scale = 1 - (1 - now) * 0.2;
							left = (now * 50) + "%";
							opacity = 1 - now;
							currentPage.css({
								'transform': 'scale(' + scale + ')',
							});
						},
						duration: 800,
						complete: function () {
							currentPage.hide();
							animating = false;
						},
						easing: 'easeInOutBack'
					});
					break;
				case "fade":
					currentPage.animate({opacity: 0}, {
						step: function (now, mx) {
							opacity = 1 - now;
						},
						duration: 500,
						complete: function () {
							currentPage.hide();
							animating = false;
						},
						easing: 'easeInOutBack'
					});
					break;
				default:
					currentPage.animate({}, {
						step: function (now, mx) {
							
						},
						duration: 0,
						complete: function () {
							currentPage.hide();
							animating = false;
						}
					});
					break;

			}
		}
	}

    $.fn.AysPersonalDictionary = function(options) {
        return this.each(function() {
            if (!$.data(this, 'AysPersonalDictionary')) {
                $.data(this, 'AysPersonalDictionary', new AysPDPlugin(this, options));
            } else {
                try {
                    $(this).data('AysPersonalDictionary').init();
                } catch (err) {
                    console.error('AysPersonalDictionary has not initiated properly');
                }
            }
        });
    };

	function shuffleArr(array) {
		let currentIndex = array.length,  randomIndex;
	  
		while (currentIndex > 0) {
	  
		  	randomIndex = Math.floor(Math.random() * currentIndex);
		  	currentIndex--;
	  
		  	[array[currentIndex], array[randomIndex]] = [
			array[randomIndex], array[currentIndex]];
		}
	  
		return array;
	}

})( jQuery );
