<?php

/**
 * Bunny.php
 *
 * @package Embera
 * @author Michael Pratt <yo@michael-pratt.com>
 * @link   http://www.michael-pratt.com/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace DevOwl\RealCookieBanner\Vendor\Embera\Provider;

use DevOwl\RealCookieBanner\Vendor\Embera\Url;
/**
 * Bunny Provider
 *
 * @link https://iframe.mediadelivery.net|iframe.mediadelivery.net|video.bunnycdn.com|video.bunnycdn.com
 * @internal
 */
class Bunny extends ProviderAdapter implements ProviderInterface
{
    /** inline {@inheritdoc} */
    protected $endpoint = 'https://video.bunnycdn.com/OEmbed';
    /** inline {@inheritdoc} */
    protected static $hosts = ['*.mediadelivery.net', '*.bunnycdn.com'];
    /** inline {@inheritdoc} */
    protected $allowedParams = ['maxwidth', 'maxheight'];
    /** inline {@inheritdoc} */
    protected $httpsSupport = \true;
    /** inline {@inheritdoc} */
    protected $responsiveSupport = \false;
    /** inline {@inheritdoc} */
    public function validateUrl(Url $url)
    {
        return (bool) \preg_match('~(mediadelivery\\.net|bunnycdn\\.com)/([^/]+)~i', (string) $url);
    }
    /** inline {@inheritdoc} */
    public function normalizeUrl(Url $url)
    {
        $url->convertToHttps();
        $url->removeQueryString();
        $url->removeLastSlash();
        return $url;
    }
    /** inline {@inheritdoc} */
    public function modifyResponse(array $response = [])
    {
        return $response;
    }
    /** inline {@inheritdoc} */
    public function getFakeResponse()
    {
        \preg_match('~v=([a-z0-9_\\-]+)~i', (string) $this->url, $matches);
        $embedUrl = '';
        $attr = [];
        $attr[] = 'width="{width}"';
        $attr[] = 'height="{height}"';
        $attr[] = 'src="' . $embedUrl . '"';
        $attr[] = 'frameborder="0"';
        $attr[] = 'allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"';
        $attr[] = 'allowfullscreen';
        return ['type' => '', 'provider_name' => 'Bunny', 'provider_url' => 'https://iframe.mediadelivery.net|iframe.mediadelivery.net|video.bunnycdn.com|video.bunnycdn.com', 'title' => 'Unknown title', 'html' => '<iframe ' . \implode(' ', $attr) . '></iframe>'];
    }
}
